/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.prism.CompositeMode;
import com.sun.prism.GraphicsResource;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.BaseGraphics;
import com.sun.prism.impl.ps.BaseShaderContext$MaskType;
import com.sun.prism.impl.ps.BaseShaderContext$SpecialShaderType;
import com.sun.prism.impl.ps.BaseShaderContext$State;
import com.sun.prism.impl.ps.BaseShaderGraphics;
import com.sun.prism.impl.ps.PaintHelper;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.Paint$Type;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;

public abstract class BaseShaderContext
extends BaseContext {
    private static final int CHECK_SHADER = 1;
    private static final int CHECK_TRANSFORM = 2;
    private static final int CHECK_CLIP = 4;
    private static final int CHECK_COMPOSITE = 8;
    private static final int CHECK_PAINT_OP_MASK = 15;
    private static final int CHECK_TEXTURE_OP_MASK = 15;
    private static final int CHECK_CLEAR_OP_MASK = 4;
    private static final int NUM_STOCK_SHADER_SLOTS = BaseShaderContext$MaskType.values().length << 4;
    private final Shader[] stockShaders = new Shader[NUM_STOCK_SHADER_SLOTS];
    private final Shader[] stockATShaders = new Shader[NUM_STOCK_SHADER_SLOTS];
    private final Shader[] specialShaders = new Shader[BaseShaderContext$SpecialShaderType.values().length];
    private final Shader[] specialATShaders = new Shader[BaseShaderContext$SpecialShaderType.values().length];
    private Shader externalShader;
    private RTTexture lcdBuffer;
    private final ShaderFactory factory;
    private BaseShaderContext$State state;

    protected BaseShaderContext(Screen screen, ShaderFactory shaderFactory, int n2) {
        super(screen, shaderFactory, n2);
        this.factory = shaderFactory;
        this.init();
    }

    protected void init() {
        this.state = null;
        if (this.externalShader != null && !this.externalShader.isValid()) {
            this.externalShader.dispose();
            this.externalShader = null;
        }
    }

    @Override
    protected void setPerspectiveTransform(GeneralTransform3D generalTransform3D) {
        if (this.checkDisposed()) {
            return;
        }
        this.state.isXformValid = false;
        super.setPerspectiveTransform(generalTransform3D);
    }

    protected void resetLastClip(BaseShaderContext$State baseShaderContext$State) {
        if (this.checkDisposed()) {
            return;
        }
        baseShaderContext$State.lastClip = null;
    }

    protected abstract BaseShaderContext$State updateRenderTarget(RenderTarget var1, NGCamera var2, boolean var3);

    protected abstract void updateTexture(int var1, Texture var2);

    protected abstract void updateShaderTransform(Shader var1, BaseTransform var2);

    protected abstract void updateWorldTransform(BaseTransform var1);

    protected abstract void updateClipRect(Rectangle var1);

    protected abstract void updateCompositeMode(CompositeMode var1);

    /*
     * Enabled aggressive block sorting
     */
    private static int getStockShaderIndex(BaseShaderContext$MaskType baseShaderContext$MaskType, Paint paint) {
        int n2;
        int n3;
        if (paint == null) {
            n3 = 0;
        } else {
            n3 = paint.getType().ordinal();
            if (paint.getType().isGradient()) {
                n2 = ((Gradient)paint).getSpreadMethod();
                return baseShaderContext$MaskType.ordinal() << 4 | n3 << 2 | n2;
            }
        }
        n2 = 0;
        return baseShaderContext$MaskType.ordinal() << 4 | n3 << 2 | n2;
    }

    private Shader getPaintShader(boolean bl2, BaseShaderContext$MaskType object, Paint paint) {
        int n2;
        if (this.checkDisposed()) {
            return null;
        }
        Shader[] shaderArray = bl2 ? this.stockATShaders : this.stockShaders;
        Object object2 = shaderArray[n2 = BaseShaderContext.getStockShaderIndex(object, paint)];
        if (object2 != null && !object2.isValid()) {
            object2.dispose();
            object2 = null;
        }
        if (object2 == null) {
            object2 = object.getName() + "_" + paint.getType().getName();
            if (paint.getType().isGradient() && !object.isNewPaintStyle()) {
                object = (Gradient)paint;
                int n3 = ((Gradient)object).getSpreadMethod();
                if (n3 == 0) {
                    object2 = (String)object2 + "_PAD";
                } else if (n3 == 1) {
                    object2 = (String)object2 + "_REFLECT";
                } else if (n3 == 2) {
                    object2 = (String)object2 + "_REPEAT";
                }
            }
            if (bl2) {
                object2 = (String)object2 + "_AlphaTest";
            }
            shaderArray[n2] = this.factory.createStockShader((String)object2);
            object2 = shaderArray[n2];
        }
        return object2;
    }

    private void updatePaintShader(BaseShaderGraphics baseShaderGraphics, Shader shader, BaseShaderContext$MaskType baseShaderContext$MaskType, Paint paint, float f2, float f3, float f4, float f5) {
        float f6;
        if (this.checkDisposed()) {
            return;
        }
        Paint$Type paint$Type = paint.getType();
        if (paint$Type == Paint$Type.COLOR || baseShaderContext$MaskType.isNewPaintStyle()) {
            return;
        }
        if (paint.isProportional()) {
            f6 = f2;
            f2 = f3;
            f3 = f4;
            f4 = f5;
        } else {
            f6 = 0.0f;
            f2 = 0.0f;
            f3 = 1.0f;
            f4 = 1.0f;
        }
        switch (paint$Type) {
            case LINEAR_GRADIENT: {
                PaintHelper.setLinearGradient(baseShaderGraphics, shader, (LinearGradient)paint, f6, f2, f3, f4);
                return;
            }
            case RADIAL_GRADIENT: {
                PaintHelper.setRadialGradient(baseShaderGraphics, shader, (RadialGradient)paint, f6, f2, f3, f4);
                return;
            }
            case IMAGE_PATTERN: {
                PaintHelper.setImagePattern(baseShaderGraphics, shader, (ImagePattern)paint, f6, f2, f3, f4);
            }
        }
    }

    private Shader getSpecialShader(BaseGraphics baseGraphics, BaseShaderContext$SpecialShaderType baseShaderContext$SpecialShaderType) {
        if (this.checkDisposed()) {
            return null;
        }
        boolean bl2 = baseGraphics.isAlphaTestShader();
        Shader[] shaderArray = bl2 ? this.specialATShaders : this.specialShaders;
        Object object = shaderArray[baseShaderContext$SpecialShaderType.ordinal()];
        if (object != null && !object.isValid()) {
            object.dispose();
            object = null;
        }
        if (object == null) {
            object = baseShaderContext$SpecialShaderType.getName();
            if (bl2) {
                object = (String)object + "_AlphaTest";
            }
            object = this.factory.createStockShader((String)object);
            shaderArray[baseShaderContext$SpecialShaderType.ordinal()] = object;
        }
        return object;
    }

    @Override
    public boolean isSuperShaderEnabled() {
        if (this.checkDisposed()) {
            return false;
        }
        return this.state.lastShader == this.specialATShaders[BaseShaderContext$SpecialShaderType.SUPER.ordinal()] || this.state.lastShader == this.specialShaders[BaseShaderContext$SpecialShaderType.SUPER.ordinal()];
    }

    private void updatePerVertexColor(Paint paint, float f2) {
        if (this.checkDisposed()) {
            return;
        }
        if (paint != null && paint.getType() == Paint$Type.COLOR) {
            this.getVertexBuffer().setPerVertexColor((Color)paint, f2);
            return;
        }
        this.getVertexBuffer().setPerVertexColor(f2);
    }

    @Override
    public void validateClearOp(BaseGraphics baseGraphics) {
        this.checkState((BaseShaderGraphics)baseGraphics, 4, null, null);
    }

    @Override
    public void validatePaintOp(BaseGraphics baseGraphics, BaseTransform baseTransform, Texture texture, float f2, float f3, float f4, float f5) {
        this.validatePaintOp((BaseShaderGraphics)baseGraphics, baseTransform, texture, f2, f3, f4, f5);
    }

    Shader validatePaintOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, BaseShaderContext$MaskType baseShaderContext$MaskType, float f2, float f3, float f4, float f5) {
        return this.validatePaintOp(baseShaderGraphics, baseTransform, baseShaderContext$MaskType, null, f2, f3, f4, f5);
    }

    Shader validatePaintOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, BaseShaderContext$MaskType baseShaderContext$MaskType, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        if (this.checkDisposed()) {
            return null;
        }
        if (this.state.lastConst1 != f6 || this.state.lastConst2 != f7 || this.state.lastConst3 != f8 || this.state.lastConst4 != f9 || this.state.lastConst5 != f10 || this.state.lastConst6 != f11) {
            this.flushVertexBuffer();
            this.state.lastConst1 = f6;
            this.state.lastConst2 = f7;
            this.state.lastConst3 = f8;
            this.state.lastConst4 = f9;
            this.state.lastConst5 = f10;
            this.state.lastConst6 = f11;
        }
        return this.validatePaintOp(baseShaderGraphics, baseTransform, baseShaderContext$MaskType, null, f2, f3, f4, f5);
    }

    Shader validatePaintOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, BaseShaderContext$MaskType baseShaderContext$MaskType, Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        if (this.state.lastConst1 != f6 || this.state.lastConst2 != f7 || this.state.lastConst3 != f8 || this.state.lastConst4 != f9 || this.state.lastConst5 != f10 || this.state.lastConst6 != f11) {
            this.flushVertexBuffer();
            this.state.lastConst1 = f6;
            this.state.lastConst2 = f7;
            this.state.lastConst3 = f8;
            this.state.lastConst4 = f9;
            this.state.lastConst5 = f10;
            this.state.lastConst6 = f11;
        }
        return this.validatePaintOp(baseShaderGraphics, baseTransform, baseShaderContext$MaskType, texture, f2, f3, f4, f5);
    }

    Shader validatePaintOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Texture texture, float f2, float f3, float f4, float f5) {
        return this.validatePaintOp(baseShaderGraphics, baseTransform, BaseShaderContext$MaskType.TEXTURE, texture, f2, f3, f4, f5);
    }

    Shader validatePaintOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, BaseShaderContext$MaskType baseShaderContext$MaskType, Texture texture, float f2, float f3, float f4, float f5) {
        if (baseShaderContext$MaskType == null) {
            throw new InternalError("maskType must be non-null");
        }
        if (this.externalShader == null) {
            Texture texture2;
            Object object;
            Paint paint = baseShaderGraphics.getPaint();
            GraphicsResource graphicsResource = null;
            if (paint.getType().isGradient()) {
                this.flushVertexBuffer();
                graphicsResource = baseShaderContext$MaskType.isNewPaintStyle() ? PaintHelper.getWrapGradientTexture(baseShaderGraphics) : PaintHelper.getGradientTexture(baseShaderGraphics, (Gradient)paint);
            } else if (paint.getType() == Paint$Type.IMAGE_PATTERN) {
                this.flushVertexBuffer();
                object = (ImagePattern)paint;
                graphicsResource = baseShaderGraphics.getResourceFactory();
                graphicsResource = graphicsResource.getCachedTexture(((ImagePattern)object).getImage(), Texture$WrapMode.REPEAT);
            }
            if (this.factory.isSuperShaderAllowed() && graphicsResource == null && texture == this.factory.getGlyphTexture()) {
                object = this.getSpecialShader(baseShaderGraphics, BaseShaderContext$SpecialShaderType.SUPER);
                texture2 = this.factory.getRegionTexture();
            } else {
                if (texture != null) {
                    texture2 = texture;
                    texture = graphicsResource;
                } else {
                    texture2 = graphicsResource;
                    texture = null;
                }
                object = this.getPaintShader(baseShaderGraphics.isAlphaTestShader(), baseShaderContext$MaskType, paint);
            }
            this.checkState(baseShaderGraphics, 15, baseTransform, (Shader)object);
            this.setTexture(0, texture2);
            this.setTexture(1, texture);
            this.updatePaintShader(baseShaderGraphics, (Shader)object, baseShaderContext$MaskType, paint, f2, f3, f4, f5);
            this.updatePerVertexColor(paint, baseShaderGraphics.getExtraAlpha());
            if (graphicsResource != null) {
                graphicsResource.unlock();
            }
            return object;
        }
        this.checkState(baseShaderGraphics, 15, baseTransform, this.externalShader);
        this.setTexture(0, texture);
        this.setTexture(1, null);
        this.updatePerVertexColor(null, baseShaderGraphics.getExtraAlpha());
        return this.externalShader;
    }

    @Override
    public void validateTextureOp(BaseGraphics baseGraphics, BaseTransform baseTransform, Texture texture, PixelFormat pixelFormat) {
        this.validateTextureOp((BaseShaderGraphics)baseGraphics, baseTransform, texture, null, pixelFormat);
    }

    public Shader validateLCDOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Texture texture, Texture texture2, boolean bl2, Paint paint) {
        if (this.checkDisposed()) {
            return null;
        }
        Shader shader = bl2 ? this.getSpecialShader(baseShaderGraphics, BaseShaderContext$SpecialShaderType.TEXTURE_First_LCD) : this.getSpecialShader(baseShaderGraphics, BaseShaderContext$SpecialShaderType.TEXTURE_SECOND_LCD);
        this.checkState(baseShaderGraphics, 15, baseTransform, shader);
        this.setTexture(0, texture);
        this.setTexture(1, texture2);
        this.updatePerVertexColor(paint, baseShaderGraphics.getExtraAlpha());
        return shader;
    }

    Shader validateTextureOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Texture[] textureArray, PixelFormat object) {
        if (this.checkDisposed()) {
            return null;
        }
        if (object == PixelFormat.MULTI_YCbCr_420) {
            if (textureArray.length < 3) {
                return null;
            }
            object = this.externalShader == null ? this.getSpecialShader(baseShaderGraphics, BaseShaderContext$SpecialShaderType.TEXTURE_YV12) : this.externalShader;
        } else {
            return null;
        }
        if (object != null) {
            this.checkState(baseShaderGraphics, 15, baseTransform, (Shader)object);
            int n2 = Math.max(0, Math.min(textureArray.length, 4));
            for (int i2 = 0; i2 < n2; ++i2) {
                this.setTexture(i2, textureArray[i2]);
            }
            this.updatePerVertexColor(null, baseShaderGraphics.getExtraAlpha());
        }
        return object;
    }

    Shader validateTextureOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Texture texture, Texture texture2, PixelFormat object) {
        block7: {
            block6: {
                if (this.checkDisposed()) {
                    return null;
                }
                if (this.externalShader != null) break block6;
                switch (object) {
                    case INT_ARGB_PRE: 
                    case BYTE_BGRA_PRE: 
                    case BYTE_RGB: 
                    case BYTE_GRAY: 
                    case BYTE_APPLE_422: {
                        if (this.factory.isSuperShaderAllowed() && texture == this.factory.getRegionTexture() && texture2 == null) {
                            object = this.getSpecialShader(baseShaderGraphics, BaseShaderContext$SpecialShaderType.SUPER);
                            texture2 = this.factory.getGlyphTexture();
                        } else {
                            object = this.getSpecialShader(baseShaderGraphics, BaseShaderContext$SpecialShaderType.TEXTURE_RGB);
                        }
                        break block7;
                    }
                    default: {
                        throw new InternalError("Pixel format not supported: " + String.valueOf(object));
                    }
                }
            }
            object = this.externalShader;
        }
        this.checkState(baseShaderGraphics, 15, baseTransform, (Shader)object);
        this.setTexture(0, texture);
        this.setTexture(1, texture2);
        this.updatePerVertexColor(null, baseShaderGraphics.getExtraAlpha());
        return object;
    }

    Shader validateMaskTextureOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Texture texture, Texture texture2, PixelFormat object) {
        block5: {
            block4: {
                if (this.checkDisposed()) {
                    return null;
                }
                if (this.externalShader != null) break block4;
                switch (object) {
                    case INT_ARGB_PRE: 
                    case BYTE_BGRA_PRE: 
                    case BYTE_RGB: 
                    case BYTE_GRAY: 
                    case BYTE_APPLE_422: {
                        object = this.getSpecialShader(baseShaderGraphics, BaseShaderContext$SpecialShaderType.TEXTURE_MASK_RGB);
                        break block5;
                    }
                    default: {
                        throw new InternalError("Pixel format not supported: " + String.valueOf(object));
                    }
                }
            }
            object = this.externalShader;
        }
        this.checkState(baseShaderGraphics, 15, baseTransform, (Shader)object);
        this.setTexture(0, texture);
        this.setTexture(1, texture2);
        this.updatePerVertexColor(null, baseShaderGraphics.getExtraAlpha());
        return object;
    }

    void setExternalShader(BaseShaderGraphics baseShaderGraphics, Shader shader) {
        if (this.checkDisposed()) {
            return;
        }
        this.flushVertexBuffer();
        if (shader != null) {
            shader.enable();
        }
        this.externalShader = shader;
    }

    private void checkState(BaseShaderGraphics baseShaderGraphics, int n2, BaseTransform object, Shader shader) {
        if (this.checkDisposed()) {
            return;
        }
        this.setRenderTarget(baseShaderGraphics);
        if ((n2 & 1) != 0 && shader != this.state.lastShader) {
            this.flushVertexBuffer();
            shader.enable();
            this.state.lastShader = shader;
            this.state.isXformValid = false;
            n2 |= 2;
        }
        if (!((n2 & 2) == 0 || this.state.isXformValid && ((BaseTransform)object).equals(this.state.lastTransform))) {
            this.flushVertexBuffer();
            this.updateShaderTransform(shader, (BaseTransform)object);
            this.state.lastTransform.setTransform((BaseTransform)object);
            this.state.isXformValid = true;
        }
        if ((n2 & 4) != 0 && (object = baseShaderGraphics.getClipRectNoClone()) != this.state.lastClip) {
            this.flushVertexBuffer();
            this.updateClipRect((Rectangle)object);
            this.state.lastClip = object;
        }
        if ((n2 & 8) != 0 && (object = baseShaderGraphics.getCompositeMode()) != this.state.lastComp) {
            this.flushVertexBuffer();
            this.updateCompositeMode((CompositeMode)((Object)object));
            this.state.lastComp = object;
        }
    }

    private void setTexture(int n2, Texture texture) {
        if (this.checkDisposed()) {
            return;
        }
        if (texture != null) {
            texture.assertLocked();
        }
        if (texture != this.state.lastTextures[n2]) {
            this.flushVertexBuffer();
            this.updateTexture(n2, texture);
            this.state.lastTextures[n2] = texture;
        }
    }

    public void initLCDBuffer(int n2, int n3) {
        if (this.checkDisposed()) {
            return;
        }
        this.lcdBuffer = this.factory.createRTTexture(n2, n3, Texture$WrapMode.CLAMP_NOT_NEEDED);
        this.lcdBuffer.makePermanent();
    }

    public void disposeLCDBuffer() {
        if (this.lcdBuffer != null) {
            this.lcdBuffer.dispose();
            this.lcdBuffer = null;
        }
    }

    @Override
    public RTTexture getLCDBuffer() {
        return this.lcdBuffer;
    }

    public void validateLCDBuffer(RenderTarget renderTarget) {
        if (this.checkDisposed()) {
            return;
        }
        if (this.lcdBuffer == null || this.lcdBuffer.getPhysicalWidth() < renderTarget.getPhysicalWidth() || this.lcdBuffer.getPhysicalHeight() < renderTarget.getPhysicalHeight()) {
            this.disposeLCDBuffer();
            this.initLCDBuffer(renderTarget.getPhysicalWidth(), renderTarget.getPhysicalHeight());
        }
    }

    public abstract void blit(RTTexture var1, RTTexture var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    @Override
    protected void setRenderTarget(RenderTarget renderTarget, NGCamera nGCamera, boolean bl2, boolean bl3) {
        if (this.checkDisposed()) {
            return;
        }
        if (renderTarget instanceof Texture) {
            ((Texture)((Object)renderTarget)).assertLocked();
        }
        if (this.state == null || bl3 != this.state.lastState3D || renderTarget != this.state.lastRenderTarget || nGCamera != this.state.lastCamera || bl2 != this.state.lastDepthTest) {
            this.flushVertexBuffer();
            this.state = this.updateRenderTarget(renderTarget, nGCamera, bl2);
            this.state.lastRenderTarget = renderTarget;
            this.state.lastCamera = nGCamera;
            this.state.lastDepthTest = bl2;
            this.state.isXformValid = false;
            if (bl3 != this.state.lastState3D) {
                this.state.lastState3D = bl3;
                this.state.lastShader = null;
                this.state.lastConst1 = Float.NaN;
                this.state.lastConst2 = Float.NaN;
                this.state.lastConst3 = Float.NaN;
                this.state.lastConst4 = Float.NaN;
                this.state.lastConst5 = Float.NaN;
                this.state.lastConst6 = Float.NaN;
                this.state.lastComp = null;
                this.state.lastClip = null;
                for (int i2 = 0; i2 != this.state.lastTextures.length; ++i2) {
                    this.state.lastTextures[i2] = null;
                }
                if (bl3) {
                    this.setDeviceParametersFor3D();
                    return;
                }
                this.setDeviceParametersFor2D();
            }
        }
    }

    @Override
    protected void releaseRenderTarget() {
        if (this.state != null) {
            this.state.lastRenderTarget = null;
            for (int i2 = 0; i2 < this.state.lastTextures.length; ++i2) {
                this.state.lastTextures[i2] = null;
            }
        }
    }

    private void disposeShaders(Shader[] shaderArray) {
        for (int i2 = 0; i2 < shaderArray.length; ++i2) {
            if (shaderArray[i2] == null) continue;
            shaderArray[i2].dispose();
            shaderArray[i2] = null;
        }
    }

    @Override
    public void dispose() {
        BaseShaderContext baseShaderContext = this;
        baseShaderContext.disposeShaders(baseShaderContext.stockShaders);
        BaseShaderContext baseShaderContext2 = this;
        baseShaderContext2.disposeShaders(baseShaderContext2.stockATShaders);
        BaseShaderContext baseShaderContext3 = this;
        baseShaderContext3.disposeShaders(baseShaderContext3.specialShaders);
        BaseShaderContext baseShaderContext4 = this;
        baseShaderContext4.disposeShaders(baseShaderContext4.specialATShaders);
        if (this.externalShader != null) {
            this.externalShader.dispose();
            this.externalShader = null;
        }
        this.disposeLCDBuffer();
        this.releaseRenderTarget();
        this.state = null;
        super.dispose();
    }
}

