/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.Disposer$Record;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.impl.ps.BaseShaderContext$MaskType;
import com.sun.prism.impl.ps.BaseShaderGraphics;
import com.sun.prism.impl.ps.CachingShapeRepState$CSRDisposerRecord;
import com.sun.prism.impl.ps.CachingShapeRepState$MaskCache;
import com.sun.prism.impl.ps.CachingShapeRepState$MaskTexData;
import com.sun.prism.paint.Paint;
import com.sun.prism.ps.Shader;

class CachingShapeRepState {
    private static final BaseTransform IDENT = BaseTransform.IDENTITY_TRANSFORM;
    private static final CachingShapeRepState$MaskCache maskCache = new CachingShapeRepState$MaskCache();
    private static final int CACHE_THRESHOLD = 2;
    private int renderCount;
    private Boolean tryCache;
    private BaseTransform lastXform;
    private final CachingShapeRepState$MaskTexData texData;
    private float[] bbox;
    private final Object disposerReferent = new Object();
    private final Disposer$Record disposerRecord;

    private static boolean equalsIgnoreTranslation(BaseTransform baseTransform, BaseTransform baseTransform2) {
        if (baseTransform == baseTransform2) {
            return true;
        }
        return baseTransform.getMxx() == baseTransform2.getMxx() && baseTransform.getMxy() == baseTransform2.getMxy() && baseTransform.getMyx() == baseTransform2.getMyx() && baseTransform.getMyy() == baseTransform2.getMyy();
    }

    CachingShapeRepState() {
        this.texData = new CachingShapeRepState$MaskTexData();
        this.disposerRecord = new CachingShapeRepState$CSRDisposerRecord(this.texData);
        Disposer.addRecord(this.disposerReferent, this.disposerRecord);
    }

    void fillNoCache(Graphics graphics, Shape shape) {
        graphics.fill(shape);
    }

    void drawNoCache(Graphics graphics, Shape shape) {
        graphics.draw(shape);
    }

    void invalidate() {
        this.renderCount = 0;
        this.tryCache = null;
        this.lastXform = null;
        this.bbox = null;
    }

    private void invalidateMaskTexData() {
        this.tryCache = null;
        this.lastXform = null;
        maskCache.unref(this.texData);
    }

    void render(Graphics object, Shape shape, RectBounds rectBounds, BasicStroke basicStroke) {
        boolean bl2;
        boolean bl3;
        BaseTransform baseTransform = object.getTransformNoClone();
        if (this.lastXform != null && CachingShapeRepState.equalsIgnoreTranslation(baseTransform, this.lastXform)) {
            bl3 = false;
            bl2 = baseTransform.getMxt() != this.lastXform.getMxt() || baseTransform.getMyt() != this.lastXform.getMyt();
        } else {
            bl2 = true;
            bl3 = true;
        }
        if (bl3) {
            this.invalidateMaskTexData();
            this.renderCount = 0;
        }
        if (bl3 || bl2) {
            if (this.lastXform == null) {
                this.lastXform = baseTransform.copy();
            } else {
                this.lastXform.setTransform(baseTransform);
            }
        }
        if (this.texData.cacheEntry != null) {
            this.texData.maskTex.lock();
            if (this.texData.maskTex.isSurfaceLost()) {
                this.texData.maskTex.unlock();
                this.invalidateMaskTexData();
            }
        }
        RectBounds rectBounds2 = null;
        boolean bl4 = false;
        if (this.tryCache == null) {
            if (baseTransform.isIdentity()) {
                rectBounds2 = rectBounds;
            } else {
                rectBounds2 = new RectBounds();
                bl4 = true;
                rectBounds2 = (RectBounds)baseTransform.transform(rectBounds, rectBounds2);
            }
            this.tryCache = !((BaseBounds)rectBounds2).isEmpty() && maskCache.hasRoom(rectBounds2);
        }
        ++this.renderCount;
        if (this.tryCache == Boolean.FALSE || this.renderCount < 2 || !(object instanceof BaseShaderGraphics) || ((BaseShaderGraphics)object).isComplexPaint()) {
            if (basicStroke == null) {
                this.fillNoCache((Graphics)object, shape);
                return;
            }
            this.drawNoCache((Graphics)object, shape);
            return;
        }
        BaseShaderGraphics baseShaderGraphics = (BaseShaderGraphics)object;
        Object object2 = baseShaderGraphics.getContext();
        if (bl2 || this.texData.cacheEntry == null) {
            if (rectBounds2 == null) {
                if (baseTransform.isIdentity()) {
                    rectBounds2 = rectBounds;
                } else {
                    rectBounds2 = new RectBounds();
                    bl4 = true;
                    rectBounds2 = (RectBounds)baseTransform.transform(rectBounds, rectBounds2);
                }
            }
            if (this.texData.cacheEntry != null) {
                this.texData.adjustOrigin(baseTransform);
            } else {
                maskCache.get((BaseShaderContext)object2, this.texData, shape, basicStroke, baseTransform, rectBounds2, bl4, object.isAntialiasedShape());
            }
        }
        object = baseShaderGraphics.getPaint();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (((Paint)object).isProportional()) {
            if (this.bbox == null) {
                this.bbox = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
                Shape.accumulate(this.bbox, shape, BaseTransform.IDENTITY_TRANSFORM);
            }
            f2 = this.bbox[0];
            f3 = this.bbox[1];
            f4 = this.bbox[2] - f2;
            f5 = this.bbox[3] - f3;
        }
        int n2 = this.texData.maskW;
        int n3 = this.texData.maskH;
        Texture texture = this.texData.maskTex;
        float f6 = texture.getPhysicalWidth();
        float f7 = texture.getPhysicalHeight();
        float f8 = this.texData.maskX;
        float f9 = this.texData.maskY;
        float f10 = f8 + (float)n2;
        float f11 = f9 + (float)n3;
        float f12 = (float)texture.getContentX() / f6;
        float f13 = (float)texture.getContentY() / f7;
        float f14 = f12 + (float)n2 / f6;
        float f15 = f13 + (float)n3 / f7;
        if (PrismSettings.primTextureSize != 0) {
            Shader shader = ((BaseShaderContext)object2).validatePaintOp(baseShaderGraphics, IDENT, BaseShaderContext$MaskType.ALPHA_TEXTURE, this.texData.maskTex, f2, f3, f4, f5);
            object2 = ((BaseContext)object2).getVertexBuffer();
            ((VertexBuffer)object2).addQuad(f8, f9, f10, f11, f12, f13, f14, f15, baseShaderGraphics.getPaintTextureTx(baseTransform, shader, f2, f3, f4, f5));
        } else {
            ((BaseShaderContext)object2).validatePaintOp(baseShaderGraphics, IDENT, this.texData.maskTex, f2, f3, f4, f5);
            VertexBuffer vertexBuffer = ((BaseContext)object2).getVertexBuffer();
            vertexBuffer.addQuad(f8, f9, f10, f11, f12, f13, f14, f15);
        }
        texture.unlock();
    }

    void dispose() {
        this.invalidate();
    }
}

