/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.AffineBase;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGPerspectiveCamera;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.Texture$Usage;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.paint.Stop;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderGraphics;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.WeakHashMap;

class PaintHelper {
    static final int MULTI_MAX_FRACTIONS = 12;
    private static final int MULTI_TEXTURE_SIZE = 16;
    private static final int MULTI_CACHE_SIZE = 256;
    private static final int GTEX_CLR_TABLE_SIZE = 101;
    private static final int GTEX_CLR_TABLE_MIRRORED_SIZE = 201;
    private static final float FULL_TEXEL_Y = 0.00390625f;
    private static final float HALF_TEXEL_Y = 0.001953125f;
    private static final FloatBuffer stopVals = BufferUtil.newFloatBuffer(48);
    private static final ByteBuffer bgraColors = BufferUtil.newByteBuffer(64);
    private static final Image colorsImg = Image.fromByteBgraPreData(bgraColors, 16, 1);
    private static final int[] previousColors = new int[16];
    private static final byte[] gtexColors = new byte[804];
    private static final Image gtexImg = Image.fromByteBgraPreData(ByteBuffer.wrap(gtexColors), 201, 1);
    private static long cacheOffset = -1L;
    private static Texture gradientCacheTexture = null;
    private static Texture gtexCacheTexture = null;
    private static final WeakHashMap<Gradient, Void> gradientMap = new WeakHashMap();
    private static final Affine2D scratchXform2D = new Affine2D();
    private static final Affine3D scratchXform3D = new Affine3D();
    private static Color PINK = new Color(1.0f, 0.078431375f, 0.5764706f, 1.0f);

    PaintHelper() {
    }

    private static float len(float f2, float f3) {
        if (f2 == 0.0f) {
            return Math.abs(f3);
        }
        if (f3 == 0.0f) {
            return Math.abs(f2);
        }
        float f4 = f2;
        float f5 = f3;
        return (float)Math.sqrt(f4 * f4 + f5 * f5);
    }

    static void initGradientTextures(ShaderGraphics shaderGraphics) {
        cacheOffset = -1L;
        gradientMap.clear();
        gradientCacheTexture = shaderGraphics.getResourceFactory().createTexture(PixelFormat.BYTE_BGRA_PRE, Texture$Usage.DEFAULT, Texture$WrapMode.CLAMP_TO_EDGE, 16, 256);
        gradientCacheTexture.setLinearFiltering(true);
        gradientCacheTexture.contentsUseful();
        gradientCacheTexture.makePermanent();
        gtexCacheTexture = shaderGraphics.getResourceFactory().createTexture(PixelFormat.BYTE_BGRA_PRE, Texture$Usage.DEFAULT, Texture$WrapMode.CLAMP_NOT_NEEDED, 201, 256);
        gtexCacheTexture.setLinearFiltering(true);
        gtexCacheTexture.contentsUseful();
        gtexCacheTexture.makePermanent();
    }

    static Texture getGradientTexture(ShaderGraphics shaderGraphics, Gradient gradient) {
        if (gradientCacheTexture == null || gradientCacheTexture.isSurfaceLost()) {
            PaintHelper.initGradientTextures(shaderGraphics);
        }
        gradientCacheTexture.lock();
        return gradientCacheTexture;
    }

    static Texture getWrapGradientTexture(ShaderGraphics shaderGraphics) {
        if (gtexCacheTexture == null || gtexCacheTexture.isSurfaceLost()) {
            PaintHelper.initGradientTextures(shaderGraphics);
        }
        gtexCacheTexture.lock();
        return gtexCacheTexture;
    }

    private static void stopsToImage(List<Stop> list, int n2) {
        if (n2 > 12) {
            throw new RuntimeException("Maximum number of gradient stops exceeded (paint uses " + n2 + " stops, but max is 12)");
        }
        bgraColors.clear();
        Color color = null;
        for (int i2 = 0; i2 < 16; ++i2) {
            Color color2;
            if (i2 < n2) {
                color = color2 = list.get(i2).getColor();
            } else {
                color2 = color;
            }
            color2.putBgraPreBytes(bgraColors);
            int n3 = color2.getIntArgbPre();
            if (n3 == previousColors[i2]) continue;
            PaintHelper.previousColors[i2] = n3;
        }
        bgraColors.rewind();
    }

    private static void insertInterpColor(byte[] byArray, int n2, Color color, Color color2, float f2) {
        float f3 = 255.0f - (f2 *= 255.0f);
        byArray[n2 <<= 2] = (byte)(color.getBluePremult() * f3 + color2.getBluePremult() * f2 + 0.5f);
        byArray[n2 + 1] = (byte)(color.getGreenPremult() * f3 + color2.getGreenPremult() * f2 + 0.5f);
        byArray[n2 + 2] = (byte)(color.getRedPremult() * f3 + color2.getRedPremult() * f2 + 0.5f);
        byArray[n2 + 3] = (byte)(color.getAlpha() * f3 + color2.getAlpha() * f2 + 0.5f);
    }

    private static void stopsToGtexImage(List<Stop> list, int n2) {
        int n3;
        Color color = list.get(0).getColor();
        float f2 = list.get(0).getOffset();
        int n4 = (int)(f2 * 100.0f + 0.5f);
        Color color2 = color;
        PaintHelper.insertInterpColor(gtexColors, 0, color2, color2, 0.0f);
        for (n3 = 1; n3 < n2; ++n3) {
            Color color3 = list.get(n3).getColor();
            f2 = list.get(n3).getOffset();
            int n5 = (int)(f2 * 100.0f + 0.5f);
            if (n5 == n4) {
                PaintHelper.insertInterpColor(gtexColors, n5, color, color3, 0.5f);
            } else {
                for (int i2 = n4 + 1; i2 <= n5; ++i2) {
                    float f3 = i2 - n4;
                    PaintHelper.insertInterpColor(gtexColors, i2, color, color3, f3 /= (float)(n5 - n4));
                }
            }
            n4 = n5;
            color = color3;
        }
        for (n3 = 1; n3 < 101; ++n3) {
            int n6 = n3 + 100 << 2;
            int n7 = 100 - n3 << 2;
            PaintHelper.gtexColors[n6] = gtexColors[n7];
            PaintHelper.gtexColors[n6 + 1] = gtexColors[n7 + 1];
            PaintHelper.gtexColors[n6 + 2] = gtexColors[n7 + 2];
            PaintHelper.gtexColors[n6 + 3] = gtexColors[n7 + 3];
        }
    }

    public static int initGradient(Gradient gradient) {
        long l2 = gradient.getGradientOffset();
        if (gradientMap.containsKey(gradient) && l2 >= 0L && l2 > cacheOffset - 256L) {
            return (int)(l2 % 256L);
        }
        List<Stop> list = gradient.getStops();
        int n2 = gradient.getNumStops();
        PaintHelper.stopsToImage(list, n2);
        PaintHelper.stopsToGtexImage(list, n2);
        long l3 = ++cacheOffset;
        gradient.setGradientOffset(l3);
        int n3 = (int)(l3 % 256L);
        gradientCacheTexture.update(colorsImg, 0, n3);
        gtexCacheTexture.update(gtexImg, 0, n3);
        gradientMap.put(gradient, null);
        return n3;
    }

    private static void setMultiGradient(Shader shader, Gradient gradient) {
        List<Stop> list = gradient.getStops();
        int n2 = gradient.getNumStops();
        stopVals.clear();
        for (int i2 = 0; i2 < 12; ++i2) {
            stopVals.put(i2 < n2 ? list.get(i2).getOffset() : 0.0f);
            stopVals.put(i2 < n2 - 1 ? 1.0f / (list.get(i2 + 1).getOffset() - list.get(i2).getOffset()) : 0.0f);
            stopVals.put(0.0f);
            stopVals.put(0.0f);
        }
        stopVals.rewind();
        shader.setConstants("fractions", stopVals, 0, 12);
        float f2 = PaintHelper.initGradient(gradient);
        shader.setConstant("offset", f2 / 256.0f + 0.001953125f);
    }

    private static void setTextureGradient(Shader shader, Gradient gradient) {
        float f2 = (float)PaintHelper.initGradient(gradient) + 0.5f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (gradient.getSpreadMethod()) {
            case 0: {
                f4 = 100.0f;
                break;
            }
            case 2: {
                f3 = 100.0f;
                break;
            }
            case 1: {
                f3 = 200.0f;
            }
        }
        float f5 = 1.0f / (float)gtexCacheTexture.getPhysicalWidth();
        float f6 = 1.0f / (float)gtexCacheTexture.getPhysicalHeight();
        float f7 = 0.5f * f5;
        shader.setConstant("content", f7, f2 *= f6, f3 *= f5, f4 *= f5);
    }

    static void setLinearGradient(ShaderGraphics object, Shader shader, LinearGradient linearGradient, float f2, float f3, float f4, float f5) {
        BaseTransform baseTransform = linearGradient.getGradientTransformNoClone();
        Affine3D affine3D = scratchXform3D;
        object.getPaintShaderTransform(affine3D);
        if (baseTransform != null) {
            ((AffineBase)affine3D).concatenate(baseTransform);
        }
        float f6 = f2 + linearGradient.getX1() * f4;
        float f7 = f3 + linearGradient.getY1() * f5;
        f2 += linearGradient.getX2() * f4;
        f3 += linearGradient.getY2() * f5;
        f4 = f6;
        f5 = f7;
        ((AffineBase)affine3D).translate(f4, f5);
        f4 = f2 - f4;
        f5 = f3 - f5;
        double d2 = PaintHelper.len(f4, f5);
        ((AffineBase)affine3D).rotate(Math.atan2(f5, f4));
        ((AffineBase)affine3D).scale(d2, 1.0);
        if (!((BaseTransform)affine3D).is2D()) {
            BaseTransform baseTransform2;
            try {
                baseTransform2 = ((BaseTransform)affine3D).createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                affine3D.setToScale(0.0, 0.0, 0.0);
                baseTransform2 = affine3D;
            }
            object = object.getCameraNoClone();
            Vec3d vec3d = new Vec3d();
            PickRay pickRay = new PickRay();
            PickRay pickRay2 = PaintHelper.project(0.0f, 0.0f, (NGCamera)object, baseTransform2, pickRay, vec3d, null);
            PickRay pickRay3 = PaintHelper.project(1.0f, 0.0f, (NGCamera)object, baseTransform2, pickRay, vec3d, null);
            object = PaintHelper.project(0.0f, 1.0f, (NGCamera)object, baseTransform2, pickRay, vec3d, null);
            double d3 = pickRay3.getDirectionNoClone().x - pickRay2.getDirectionNoClone().x;
            double d4 = ((PickRay)object).getDirectionNoClone().x - pickRay2.getDirectionNoClone().x;
            double d5 = pickRay2.getDirectionNoClone().x;
            double d6 = pickRay3.getDirectionNoClone().z - pickRay2.getDirectionNoClone().z;
            double d7 = ((PickRay)object).getDirectionNoClone().z - pickRay2.getDirectionNoClone().z;
            double d8 = pickRay2.getDirectionNoClone().z;
            shader.setConstant("gradParams", (float)(d3 *= -pickRay2.getOriginNoClone().z), (float)(d4 *= -pickRay2.getOriginNoClone().z), (float)(d5 *= -pickRay2.getOriginNoClone().z), (float)pickRay2.getOriginNoClone().x);
            shader.setConstant("perspVec", (float)d6, (float)d7, (float)d8);
        } else {
            try {
                ((BaseTransform)affine3D).invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                affine3D.setToScale(0.0, 0.0, 0.0);
            }
            double d9 = (float)((BaseTransform)affine3D).getMxx();
            double d10 = (float)((BaseTransform)affine3D).getMxy();
            double d11 = (float)((BaseTransform)affine3D).getMxt();
            shader.setConstant("gradParams", (float)d9, (float)d10, (float)d11, 0.0f);
            shader.setConstant("perspVec", 0.0f, 0.0f, 1.0f);
        }
        PaintHelper.setMultiGradient(shader, linearGradient);
    }

    static AffineBase getLinearGradientTx(LinearGradient linearGradient, Shader shader, BaseTransform baseTransform, float f2, float f3, float f4, float f5) {
        BaseTransform baseTransform2;
        float f6 = linearGradient.getX1();
        float f7 = linearGradient.getY1();
        float f8 = linearGradient.getX2();
        float f9 = linearGradient.getY2();
        if (linearGradient.isProportional()) {
            f6 = f2 + f6 * f4;
            f7 = f3 + f7 * f5;
            f8 = f2 + f8 * f4;
            f9 = f3 + f9 * f5;
        }
        f2 = f8 - f6;
        f3 = f9 - f7;
        f4 = PaintHelper.len(f2, f3);
        if (linearGradient.getSpreadMethod() == 1) {
            f4 *= 2.0f;
        }
        if ((baseTransform2 = linearGradient.getGradientTransformNoClone()).isIdentity() && baseTransform.isIdentity()) {
            Affine2D affine2D = scratchXform2D;
            affine2D.setToTranslation(f6, f7);
            affine2D.rotate(f2, f3);
            affine2D.scale(f4, 1.0);
            baseTransform = affine2D;
        } else {
            Affine3D affine3D = scratchXform3D;
            ((BaseTransform)affine3D).setTransform(baseTransform);
            ((AffineBase)affine3D).concatenate(baseTransform2);
            ((AffineBase)affine3D).translate(f6, f7);
            ((AffineBase)affine3D).rotate(Math.atan2(f3, f2));
            ((AffineBase)affine3D).scale(f4, 1.0);
            baseTransform = affine3D;
        }
        try {
            baseTransform.invert();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            scratchXform2D.setToScale(0.0, 0.0);
            baseTransform = scratchXform2D;
        }
        PaintHelper.setTextureGradient(shader, linearGradient);
        return baseTransform;
    }

    static void setRadialGradient(ShaderGraphics object, Shader shader, RadialGradient radialGradient, float f2, float f3, float f4, float f5) {
        Object object2;
        float f6;
        float f7;
        Affine3D affine3D = scratchXform3D;
        object.getPaintShaderTransform(affine3D);
        float f8 = radialGradient.getRadius();
        float f9 = radialGradient.getCenterX();
        float f10 = radialGradient.getCenterY();
        float f11 = radialGradient.getFocusAngle();
        float f12 = radialGradient.getFocusDistance();
        if (f7 < 0.0f) {
            f12 = -f12;
            f11 += 180.0f;
        }
        f11 = (float)Math.toRadians(f11);
        if (radialGradient.isProportional()) {
            f6 = Math.min(f4, f5);
            f9 = (f9 - 0.5f) * f6 + (f2 += f4 / 2.0f);
            f10 = (f10 - 0.5f) * f6 + (f3 += f5 / 2.0f);
            if (f4 != f5 && f4 != 0.0f && f5 != 0.0f) {
                ((AffineBase)affine3D).translate(f2, f3);
                ((AffineBase)affine3D).scale(f4 / f6, f5 / f6);
                ((AffineBase)affine3D).translate(-f2, -f3);
            }
            f8 *= f6;
        }
        if ((object2 = radialGradient.getGradientTransformNoClone()) != null) {
            ((AffineBase)affine3D).concatenate((BaseTransform)object2);
        }
        ((AffineBase)affine3D).translate(f9, f10);
        ((AffineBase)affine3D).rotate(f11);
        ((AffineBase)affine3D).scale(f8, f8);
        try {
            ((BaseTransform)affine3D).invert();
        }
        catch (Exception exception) {
            affine3D.setToScale(0.0, 0.0, 0.0);
        }
        if (!((BaseTransform)affine3D).is2D()) {
            NGCamera nGCamera = object.getCameraNoClone();
            Vec3d vec3d = new Vec3d();
            object = new PickRay();
            object2 = PaintHelper.project(0.0f, 0.0f, nGCamera, affine3D, (PickRay)object, vec3d, null);
            PickRay pickRay = PaintHelper.project(1.0f, 0.0f, nGCamera, affine3D, (PickRay)object, vec3d, null);
            object = PaintHelper.project(0.0f, 1.0f, nGCamera, affine3D, (PickRay)object, vec3d, null);
            double d2 = pickRay.getDirectionNoClone().x - ((PickRay)object2).getDirectionNoClone().x;
            double d3 = ((PickRay)object).getDirectionNoClone().x - ((PickRay)object2).getDirectionNoClone().x;
            double d4 = ((PickRay)object2).getDirectionNoClone().x;
            double d5 = pickRay.getDirectionNoClone().y - ((PickRay)object2).getDirectionNoClone().y;
            double d6 = ((PickRay)object).getDirectionNoClone().y - ((PickRay)object2).getDirectionNoClone().y;
            double d7 = ((PickRay)object2).getDirectionNoClone().y;
            d2 *= -((PickRay)object2).getOriginNoClone().z;
            d3 *= -((PickRay)object2).getOriginNoClone().z;
            d4 *= -((PickRay)object2).getOriginNoClone().z;
            d5 *= -((PickRay)object2).getOriginNoClone().z;
            d6 *= -((PickRay)object2).getOriginNoClone().z;
            d7 *= -((PickRay)object2).getOriginNoClone().z;
            double d8 = pickRay.getDirectionNoClone().z - ((PickRay)object2).getDirectionNoClone().z;
            double d9 = ((PickRay)object).getDirectionNoClone().z - ((PickRay)object2).getDirectionNoClone().z;
            double d10 = ((PickRay)object2).getDirectionNoClone().z;
            shader.setConstant("perspVec", (float)d8, (float)d9, (float)d10);
            shader.setConstant("m0", (float)d2, (float)d3, (float)d4, (float)((PickRay)object2).getOriginNoClone().x);
            shader.setConstant("m1", (float)d5, (float)d6, (float)d7, (float)((PickRay)object2).getOriginNoClone().y);
        } else {
            f3 = (float)((BaseTransform)affine3D).getMxx();
            f6 = (float)((BaseTransform)affine3D).getMxy();
            float f13 = (float)((BaseTransform)affine3D).getMxt();
            shader.setConstant("m0", f3, f6, f13, 0.0f);
            float f14 = (float)((BaseTransform)affine3D).getMyx();
            f4 = (float)((BaseTransform)affine3D).getMyy();
            f13 = (float)((BaseTransform)affine3D).getMyt();
            shader.setConstant("m1", f14, f4, f13, 0.0f);
            shader.setConstant("perspVec", 0.0f, 0.0f, 1.0f);
        }
        float f15 = f12 = Math.min(f12, 0.99f);
        float f16 = 1.0f - f15 * f15;
        float f17 = 1.0f / f16;
        shader.setConstant("precalc", f12, f16, f17);
        PaintHelper.setMultiGradient(shader, radialGradient);
    }

    static AffineBase getRadialGradientTx(RadialGradient radialGradient, Shader shader, BaseTransform baseTransform, float f2, float f3, float f4, float f5) {
        BaseTransform baseTransform2;
        float f6;
        float f7;
        Affine3D affine3D = scratchXform3D;
        ((BaseTransform)affine3D).setTransform(baseTransform);
        float f8 = radialGradient.getRadius();
        float f9 = radialGradient.getCenterX();
        float f10 = radialGradient.getCenterY();
        float f11 = radialGradient.getFocusAngle();
        float f12 = radialGradient.getFocusDistance();
        if (f7 < 0.0f) {
            f12 = -f12;
            f11 += 180.0f;
        }
        f11 = (float)Math.toRadians(f11);
        if (radialGradient.isProportional()) {
            f6 = Math.min(f4, f5);
            f9 = (f9 - 0.5f) * f6 + (f2 += f4 / 2.0f);
            f10 = (f10 - 0.5f) * f6 + (f3 += f5 / 2.0f);
            if (f4 != f5 && f4 != 0.0f && f5 != 0.0f) {
                ((AffineBase)affine3D).translate(f2, f3);
                ((AffineBase)affine3D).scale(f4 / f6, f5 / f6);
                ((AffineBase)affine3D).translate(-f2, -f3);
            }
            f8 *= f6;
        }
        if (radialGradient.getSpreadMethod() == 1) {
            f8 *= 2.0f;
        }
        if ((baseTransform2 = radialGradient.getGradientTransformNoClone()) != null) {
            ((AffineBase)affine3D).concatenate(baseTransform2);
        }
        ((AffineBase)affine3D).translate(f9, f10);
        ((AffineBase)affine3D).rotate(f11);
        ((AffineBase)affine3D).scale(f8, f8);
        try {
            ((BaseTransform)affine3D).invert();
        }
        catch (Exception exception) {
            affine3D.setToScale(0.0, 0.0, 0.0);
        }
        float f13 = f12 = Math.min(f12, 0.99f);
        f3 = 1.0f - f13 * f13;
        f6 = 1.0f / f3;
        shader.setConstant("precalc", f12, f3, f6);
        PaintHelper.setTextureGradient(shader, radialGradient);
        return affine3D;
    }

    static void setImagePattern(ShaderGraphics object, Shader shader, ImagePattern object2, float f2, float f3, float f4, float f5) {
        f2 += ((ImagePattern)object2).getX() * f4;
        f3 += ((ImagePattern)object2).getY() * f5;
        f4 = f2 + ((ImagePattern)object2).getWidth() * f4;
        f5 = f3 + ((ImagePattern)object2).getHeight() * f5;
        Object object3 = object.getResourceFactory();
        Image image = ((ImagePattern)object2).getImage();
        object3 = object3.getCachedTexture(image, Texture$WrapMode.REPEAT);
        float f6 = object3.getContentX();
        float f7 = object3.getContentY();
        float f8 = object3.getContentWidth();
        float f9 = object3.getContentHeight();
        float f10 = object3.getPhysicalWidth();
        float f11 = object3.getPhysicalHeight();
        object3.unlock();
        object3 = scratchXform3D;
        object.getPaintShaderTransform((Affine3D)object3);
        object2 = ((ImagePattern)object2).getPatternTransformNoClone();
        if (object2 != null) {
            ((AffineBase)object3).concatenate((BaseTransform)object2);
        }
        ((AffineBase)object3).translate(f2, f3);
        ((AffineBase)object3).scale(f4 - f2, f5 - f3);
        if (f8 < f10) {
            ((AffineBase)object3).translate(0.5 / (double)f8, 0.0);
            f6 += 0.5f;
        }
        if (f9 < f11) {
            ((AffineBase)object3).translate(0.0, 0.5 / (double)f9);
            f7 += 0.5f;
        }
        try {
            ((BaseTransform)object3).invert();
        }
        catch (Exception exception) {
            ((Affine3D)object3).setToScale(0.0, 0.0, 0.0);
        }
        if (!((BaseTransform)object3).is2D()) {
            object = object.getCameraNoClone();
            object2 = new Vec3d();
            PickRay pickRay = new PickRay();
            PickRay pickRay2 = PaintHelper.project(0.0f, 0.0f, (NGCamera)object, (BaseTransform)object3, pickRay, (Vec3d)object2, null);
            PickRay pickRay3 = PaintHelper.project(1.0f, 0.0f, (NGCamera)object, (BaseTransform)object3, pickRay, (Vec3d)object2, null);
            object = PaintHelper.project(0.0f, 1.0f, (NGCamera)object, (BaseTransform)object3, pickRay, (Vec3d)object2, null);
            double d2 = pickRay3.getDirectionNoClone().x - pickRay2.getDirectionNoClone().x;
            double d3 = ((PickRay)object).getDirectionNoClone().x - pickRay2.getDirectionNoClone().x;
            double d4 = pickRay2.getDirectionNoClone().x;
            double d5 = pickRay3.getDirectionNoClone().y - pickRay2.getDirectionNoClone().y;
            double d6 = ((PickRay)object).getDirectionNoClone().y - pickRay2.getDirectionNoClone().y;
            double d7 = pickRay2.getDirectionNoClone().y;
            d2 *= -pickRay2.getOriginNoClone().z;
            d3 *= -pickRay2.getOriginNoClone().z;
            d4 *= -pickRay2.getOriginNoClone().z;
            d5 *= -pickRay2.getOriginNoClone().z;
            d6 *= -pickRay2.getOriginNoClone().z;
            d7 *= -pickRay2.getOriginNoClone().z;
            double d8 = pickRay3.getDirectionNoClone().z - pickRay2.getDirectionNoClone().z;
            double d9 = ((PickRay)object).getDirectionNoClone().z - pickRay2.getDirectionNoClone().z;
            double d10 = pickRay2.getDirectionNoClone().z;
            shader.setConstant("perspVec", (float)d8, (float)d9, (float)d10);
            shader.setConstant("xParams", (float)d2, (float)d3, (float)d4, (float)pickRay2.getOriginNoClone().x);
            shader.setConstant("yParams", (float)d5, (float)d6, (float)d7, (float)pickRay2.getOriginNoClone().y);
        } else {
            float f12 = (float)((BaseTransform)object3).getMxx();
            float f13 = (float)((BaseTransform)object3).getMxy();
            f2 = (float)((BaseTransform)object3).getMxt();
            shader.setConstant("xParams", f12, f13, f2, 0.0f);
            f3 = (float)((BaseTransform)object3).getMyx();
            f4 = (float)((BaseTransform)object3).getMyy();
            f12 = (float)((BaseTransform)object3).getMyt();
            shader.setConstant("yParams", f3, f4, f12, 0.0f);
            shader.setConstant("perspVec", 0.0f, 0.0f, 1.0f);
        }
        shader.setConstant("content", f6 /= f10, f7 /= f11, f8 /= f10, f9 /= f11);
    }

    static AffineBase getImagePatternTx(ShaderGraphics object, ImagePattern object2, Shader shader, BaseTransform baseTransform, float f2, float f3, float f4, float f5) {
        float f6 = ((ImagePattern)object2).getX();
        float f7 = ((ImagePattern)object2).getY();
        float f8 = ((ImagePattern)object2).getWidth();
        float f9 = ((ImagePattern)object2).getHeight();
        if (((Paint)object2).isProportional()) {
            f6 = f2 + f6 * f4;
            f7 = f3 + f7 * f5;
            f8 *= f4;
            f9 *= f5;
        }
        object = object.getResourceFactory();
        Image image = ((ImagePattern)object2).getImage();
        object = object.getCachedTexture(image, Texture$WrapMode.REPEAT);
        float f10 = object.getContentX();
        f3 = object.getContentY();
        f4 = object.getContentWidth();
        f5 = object.getContentHeight();
        float f11 = object.getPhysicalWidth();
        float f12 = object.getPhysicalHeight();
        object.unlock();
        object = ((ImagePattern)object2).getPatternTransformNoClone();
        if (((BaseTransform)object).isIdentity() && baseTransform.isIdentity()) {
            object2 = scratchXform2D;
            ((Affine2D)object2).setToTranslation(f6, f7);
            ((AffineBase)object2).scale(f8, f9);
            object = object2;
        } else {
            object2 = scratchXform3D;
            ((BaseTransform)object2).setTransform(baseTransform);
            ((AffineBase)object2).concatenate((BaseTransform)object);
            ((AffineBase)object2).translate(f6, f7);
            ((AffineBase)object2).scale(f8, f9);
            object = object2;
        }
        if (f4 < f11) {
            ((AffineBase)object).translate(0.5 / (double)f4, 0.0);
            f10 += 0.5f;
        }
        if (f5 < f12) {
            ((AffineBase)object).translate(0.0, 0.5 / (double)f5);
            f3 += 0.5f;
        }
        try {
            ((BaseTransform)object).invert();
        }
        catch (Exception exception) {
            object = scratchXform2D;
            scratchXform2D.setToScale(0.0, 0.0);
        }
        shader.setConstant("content", f10 /= f11, f3 /= f12, f4 /= f11, f5 /= f12);
        return object;
    }

    static PickRay project(float f2, float f3, NGCamera nGCamera, BaseTransform baseTransform, PickRay pickRay, Vec3d vec3d, Point2D point2D) {
        pickRay = nGCamera.computePickRay(f2, f3, pickRay);
        return pickRay.project(baseTransform, nGCamera instanceof NGPerspectiveCamera, vec3d, point2D);
    }
}

