/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.marlin.DMarlinRenderingEngine;
import com.sun.marlin.MarlinProperties;
import com.sun.marlin.MarlinRenderer;
import com.sun.marlin.MaskMarlinAlphaConsumer;
import com.sun.marlin.RendererContext;
import com.sun.prism.BasicStroke;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.shape.DMarlinPrismUtils;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeRasterizer;

public final class DMarlinRasterizer
implements ShapeRasterizer {
    private static final MaskData EMPTY_MASK = MaskData.create(new byte[1], 0, 0, 1, 1);
    private static final boolean DO_RENDER = !MarlinProperties.isSkipRenderTiles();

    @Override
    public final MaskData getMaskData(Shape shape, BasicStroke basicStroke, RectBounds rectBounds, BaseTransform baseTransform, boolean bl2, boolean bl3) {
        if (basicStroke != null && basicStroke.getType() != 0) {
            shape = basicStroke.createStrokedShape(shape);
            basicStroke = null;
        }
        if (rectBounds == null) {
            if (basicStroke != null) {
                shape = basicStroke.createStrokedShape(shape);
                basicStroke = null;
            }
            rectBounds = new RectBounds();
            rectBounds = (RectBounds)baseTransform.transform(shape.getBounds(), rectBounds);
        }
        if (((BaseBounds)rectBounds).isEmpty()) {
            return EMPTY_MASK;
        }
        RendererContext rendererContext = DMarlinRenderingEngine.getRendererContext();
        MarlinRenderer marlinRenderer = null;
        try {
            Rectangle rectangle = rendererContext.clip;
            rectangle.setBounds(rectBounds);
            marlinRenderer = DMarlinPrismUtils.setupRenderer(rendererContext, shape, basicStroke, baseTransform, rectangle, bl3);
            int n2 = marlinRenderer.getOutpixMinX();
            int n3 = marlinRenderer.getOutpixMaxX();
            int n4 = marlinRenderer.getOutpixMinY();
            int n5 = marlinRenderer.getOutpixMaxY();
            if ((n3 -= n2) <= 0 || (n5 -= n4) <= 0) {
                MaskData maskData = EMPTY_MASK;
                return maskData;
            }
            MaskMarlinAlphaConsumer maskMarlinAlphaConsumer = rendererContext.consumer;
            if (maskMarlinAlphaConsumer == null || n3 * n5 > maskMarlinAlphaConsumer.getAlphaLength()) {
                int n6 = n3 * n5 + 4095 & 0xFFFFF000;
                rendererContext.consumer = maskMarlinAlphaConsumer = new MaskMarlinAlphaConsumer(n6);
                if (PrismSettings.verbose) {
                    System.out.println("new alphas with length = " + n6);
                }
            }
            maskMarlinAlphaConsumer.setBoundsNoClone(n2, n4, n3, n5);
            marlinRenderer.produceAlphas(maskMarlinAlphaConsumer);
            if (!DO_RENDER) {
                MaskData maskData = EMPTY_MASK;
                return maskData;
            }
            MaskData maskData = maskMarlinAlphaConsumer.getMaskData();
            return maskData;
        }
        finally {
            if (marlinRenderer != null) {
                marlinRenderer.dispose();
            }
            DMarlinRenderingEngine.returnRendererContext(rendererContext);
        }
    }

    static Shape createCenteredStrokedShape(Shape shape, BasicStroke basicStroke) {
        float f2 = basicStroke.getType() == 0 ? basicStroke.getLineWidth() : basicStroke.getLineWidth() * 2.0f;
        RendererContext rendererContext = DMarlinRenderingEngine.getRendererContext();
        try {
            Path2D path2D = rendererContext.getPath2D();
            DMarlinPrismUtils.strokeTo(rendererContext, shape, basicStroke, f2, rendererContext.transformerPC2D.wrapPath2D(path2D));
            shape = new Path2D(path2D);
            return shape;
        }
        finally {
            DMarlinRenderingEngine.returnRendererContext(rendererContext);
        }
    }
}

