/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.glass.ui.Screen;
import com.sun.prism.Graphics;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.j2d.J2DPresentable$Bimg;
import com.sun.prism.j2d.J2DPresentable$Glass;
import com.sun.prism.j2d.J2DRTTexture;
import com.sun.prism.j2d.J2DResourceFactory;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.nio.IntBuffer;

public abstract class J2DPresentable
implements Presentable {
    J2DResourceFactory factory;
    boolean needsResize;
    BufferedImage buffer;
    IntBuffer ib;
    J2DRTTexture readbackBuffer;

    static J2DPresentable create(PresentableState presentableState, J2DResourceFactory j2DResourceFactory) {
        return new J2DPresentable$Glass(presentableState, j2DResourceFactory);
    }

    static J2DPresentable create(BufferedImage bufferedImage, J2DResourceFactory j2DResourceFactory) {
        return new J2DPresentable$Bimg(bufferedImage, j2DResourceFactory);
    }

    J2DPresentable(BufferedImage bufferedImage, J2DResourceFactory j2DResourceFactory) {
        this.buffer = bufferedImage;
        this.factory = j2DResourceFactory;
    }

    ResourceFactory getResourceFactory() {
        return this.factory;
    }

    public abstract BufferedImage createBuffer(int var1, int var2);

    @Override
    public Graphics createGraphics() {
        Object object;
        if (this.needsResize) {
            int n2 = this.getContentWidth();
            int n3 = this.getContentHeight();
            this.buffer = null;
            this.readbackBuffer = null;
            this.buffer = this.createBuffer(n2, n3);
            object = this.buffer.getRaster();
            DataBuffer dataBuffer = ((Raster)object).getDataBuffer();
            SinglePixelPackedSampleModel cfr_ignored_0 = (SinglePixelPackedSampleModel)((Raster)object).getSampleModel();
            object = ((DataBufferInt)dataBuffer).getData();
            this.ib = IntBuffer.wrap((int[])object, dataBuffer.getOffset(), dataBuffer.getSize());
            this.needsResize = false;
        }
        object = this.buffer.createGraphics();
        return this.factory.createJ2DPrismGraphics(this, (Graphics2D)object);
    }

    J2DRTTexture getReadbackBuffer() {
        if (this.readbackBuffer == null) {
            this.readbackBuffer = (J2DRTTexture)this.factory.createRTTexture(this.getContentWidth(), this.getContentHeight(), Texture$WrapMode.CLAMP_NOT_NEEDED);
            this.readbackBuffer.makePermanent();
        }
        return this.readbackBuffer;
    }

    BufferedImage getBackBuffer() {
        return this.buffer;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.factory.getScreen();
    }

    @Override
    public int getContentX() {
        return 0;
    }

    @Override
    public int getContentY() {
        return 0;
    }

    @Override
    public float getPixelScaleFactorX() {
        return 1.0f;
    }

    @Override
    public float getPixelScaleFactorY() {
        return 1.0f;
    }

    @Override
    public int getPhysicalWidth() {
        if (this.buffer == null) {
            return this.getContentWidth();
        }
        return this.buffer.getWidth();
    }

    @Override
    public int getPhysicalHeight() {
        if (this.buffer == null) {
            return this.getContentHeight();
        }
        return this.buffer.getHeight();
    }

    @Override
    public boolean isMSAA() {
        return false;
    }
}

