/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.glass.ui.Screen;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.font.CompositeStrike;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NodePath;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.MaskTextureGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.RenderTarget;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.j2d.J2DFontFactory;
import com.sun.prism.j2d.J2DPresentable;
import com.sun.prism.j2d.J2DPrismGraphics$AdaptorShape;
import com.sun.prism.j2d.J2DPrismGraphics$InnerStroke;
import com.sun.prism.j2d.J2DPrismGraphics$OuterStroke;
import com.sun.prism.j2d.J2DRTTexture;
import com.sun.prism.j2d.J2DTexture;
import com.sun.prism.j2d.paint.MultipleGradientPaint$ColorSpaceType;
import com.sun.prism.j2d.paint.MultipleGradientPaint$CycleMethod;
import com.sun.prism.j2d.paint.RadialGradientPaint;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.Paint$Type;
import com.sun.prism.paint.RadialGradient;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;

public class J2DPrismGraphics
implements MaskTextureGraphics,
ReadbackGraphics {
    static final MultipleGradientPaint.CycleMethod[] LGP_CYCLE_METHODS = new MultipleGradientPaint.CycleMethod[]{MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.CycleMethod.REFLECT, MultipleGradientPaint.CycleMethod.REPEAT};
    static final MultipleGradientPaint$CycleMethod[] RGP_CYCLE_METHODS = new MultipleGradientPaint$CycleMethod[]{MultipleGradientPaint$CycleMethod.NO_CYCLE, MultipleGradientPaint$CycleMethod.REFLECT, MultipleGradientPaint$CycleMethod.REPEAT};
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f);
    private static final Paint DEFAULT_PAINT = com.sun.prism.paint.Color.WHITE;
    static AffineTransform J2D_IDENTITY = new AffineTransform();
    private int clipRectIndex;
    private boolean hasPreCullingBits = false;
    private float pixelScaleX = 1.0f;
    private float pixelScaleY = 1.0f;
    private static ConcurrentHashMap<Font, WeakReference<Font>> fontMap = new ConcurrentHashMap();
    private static volatile int cleared = 0;
    private static AffineTransform tmpAT = new AffineTransform();
    private static Path2D tmpQuadShape = new Path2D.Float();
    private static Rectangle2D.Float tmpRect = new Rectangle2D.Float();
    private static Ellipse2D tmpEllipse = new Ellipse2D.Float();
    private static RoundRectangle2D tmpRRect = new RoundRectangle2D.Float();
    private static Line2D tmpLine = new Line2D.Float();
    private static J2DPrismGraphics$AdaptorShape tmpAdaptor = new J2DPrismGraphics$AdaptorShape();
    private boolean antialiasedShape = true;
    J2DPresentable target;
    Graphics2D g2d;
    Affine2D transform;
    Rectangle clipRect;
    RectBounds devClipRect;
    RectBounds finalClipRect;
    Paint paint;
    boolean paintWasProportional;
    BasicStroke stroke;
    boolean cull;
    Rectangle2D nodeBounds = null;
    private NodePath renderRoot;

    static Color toJ2DColor(com.sun.prism.paint.Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    static int fixFractions(float[] fArray, Color[] colorArray) {
        float f2 = fArray[0];
        int n2 = 1;
        int n3 = 1;
        while (n2 < fArray.length) {
            float f3 = fArray[n2];
            Color color = colorArray[n2++];
            if (f3 <= f2) {
                if (f3 >= 1.0f) break;
                float f4 = f2;
                f3 = f4 + Math.ulp(f4);
                while (n2 < fArray.length && !(fArray[n2] > f3)) {
                    color = colorArray[n2++];
                }
            }
            fArray[n3] = f2 = f3;
            colorArray[n3++] = color;
        }
        return n3;
    }

    java.awt.Paint toJ2DPaint(Paint paint, Rectangle2D cloneable) {
        if (paint instanceof com.sun.prism.paint.Color) {
            return J2DPrismGraphics.toJ2DColor((com.sun.prism.paint.Color)paint);
        }
        if (paint instanceof Gradient) {
            float f2;
            Color[] colorArray;
            Gradient gradient = (Gradient)paint;
            if (gradient.isProportional() && cloneable == null) {
                return null;
            }
            Object object = gradient.getStops();
            int n2 = object.size();
            float[] fArray = new float[n2];
            Color[] colorArray2 = new Color[n2];
            float f3 = -1.0f;
            boolean bl2 = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                colorArray = object.get(i2);
                f2 = colorArray.getOffset();
                bl2 = bl2 || f2 <= f3;
                fArray[i2] = f3 = f2;
                colorArray2[i2] = J2DPrismGraphics.toJ2DColor(colorArray.getColor());
            }
            if (bl2 && (n2 = J2DPrismGraphics.fixFractions(fArray, colorArray2)) < fArray.length) {
                float[] fArray2 = new float[n2];
                System.arraycopy(fArray, 0, fArray2, 0, n2);
                fArray = fArray2;
                colorArray = new Color[n2];
                System.arraycopy(colorArray2, 0, colorArray, 0, n2);
                colorArray2 = colorArray;
            }
            if (gradient instanceof LinearGradient) {
                LinearGradient linearGradient = (LinearGradient)paint;
                float f4 = linearGradient.getX1();
                f2 = linearGradient.getY1();
                float f5 = linearGradient.getX2();
                float f6 = linearGradient.getY2();
                if (gradient.isProportional()) {
                    float f7 = (float)cloneable.getX();
                    float f8 = (float)cloneable.getY();
                    float f9 = (float)cloneable.getWidth();
                    f3 = (float)cloneable.getHeight();
                    f4 = f7 + f9 * f4;
                    f2 = f8 + f3 * f2;
                    f5 = f7 + f9 * f5;
                    f6 = f8 + f3 * f6;
                }
                if (f4 == f5 && f2 == f6) {
                    return colorArray2[0];
                }
                Point2D.Float float_ = new Point2D.Float(f4, f2);
                object = new Point2D.Float(f5, f6);
                MultipleGradientPaint.CycleMethod cycleMethod = LGP_CYCLE_METHODS[gradient.getSpreadMethod()];
                return new LinearGradientPaint(float_, (Point2D)object, fArray, colorArray2, cycleMethod);
            }
            if (gradient instanceof RadialGradient) {
                RadialGradient radialGradient = (RadialGradient)gradient;
                float f10 = radialGradient.getCenterX();
                f2 = radialGradient.getCenterY();
                float f11 = radialGradient.getRadius();
                double d2 = Math.toRadians(radialGradient.getFocusAngle());
                float f12 = radialGradient.getFocusDistance();
                AffineTransform affineTransform = J2D_IDENTITY;
                if (gradient.isProportional()) {
                    f3 = (float)cloneable.getX();
                    float f13 = (float)cloneable.getY();
                    float f14 = (float)cloneable.getWidth();
                    float f15 = (float)cloneable.getHeight();
                    float f16 = Math.min(f14, f15);
                    f10 = (f3 += f14 * 0.5f) + (f10 - 0.5f) * f16;
                    f2 = (f13 += f15 * 0.5f) + (f2 - 0.5f) * f16;
                    f11 *= f16;
                    if (f14 != f15 && (double)f14 != 0.0 && (double)f15 != 0.0) {
                        affineTransform = AffineTransform.getTranslateInstance(f3, f13);
                        affineTransform.scale(f14 / f16, f15 / f16);
                        affineTransform.translate(-f3, -f13);
                    }
                }
                Point2D.Float float_ = new Point2D.Float(f10, f2);
                float f17 = (float)((double)f10 + (double)(f12 * f11) * Math.cos(d2));
                float f18 = (float)((double)f2 + (double)(f12 * f11) * Math.sin(d2));
                cloneable = new Point2D.Float(f17, f18);
                MultipleGradientPaint$CycleMethod cycleMethod = RGP_CYCLE_METHODS[gradient.getSpreadMethod()];
                return new RadialGradientPaint(float_, f11, (Point2D)cloneable, fArray, colorArray2, cycleMethod, MultipleGradientPaint$ColorSpaceType.SRGB, affineTransform);
            }
        } else if (paint instanceof ImagePattern) {
            ImagePattern imagePattern = (ImagePattern)paint;
            float f19 = imagePattern.getX();
            float f20 = imagePattern.getY();
            float f21 = imagePattern.getWidth();
            float f22 = imagePattern.getHeight();
            if (paint.isProportional()) {
                if (cloneable == null) {
                    return null;
                }
                float f23 = (float)cloneable.getX();
                float f24 = (float)cloneable.getY();
                float f25 = (float)cloneable.getWidth();
                float f26 = (float)cloneable.getHeight();
                f21 += f19;
                f22 += f20;
                f19 = f23 + f19 * f25;
                f20 = f24 + f20 * f26;
                f21 = f23 + f21 * f25;
                f22 = f24 + f22 * f26;
                f21 -= f19;
                f22 -= f20;
            }
            Texture texture = this.getResourceFactory().getCachedTexture(imagePattern.getImage(), Texture$WrapMode.REPEAT);
            BufferedImage bufferedImage = ((J2DTexture)texture).getBufferedImage();
            texture.unlock();
            return new TexturePaint(bufferedImage, J2DPrismGraphics.tmpRect(f19, f20, f21, f22));
        }
        throw new UnsupportedOperationException("Paint " + String.valueOf(paint) + " not supported yet.");
    }

    static Stroke toJ2DStroke(BasicStroke object) {
        float f2 = ((BasicStroke)object).getLineWidth();
        int n2 = ((BasicStroke)object).getType();
        if (n2 != 0) {
            f2 *= 2.0f;
        }
        object = new java.awt.BasicStroke(f2, ((BasicStroke)object).getEndCap(), ((BasicStroke)object).getLineJoin(), ((BasicStroke)object).getMiterLimit(), ((BasicStroke)object).getDashArray(), ((BasicStroke)object).getDashPhase());
        if (n2 == 1) {
            return new J2DPrismGraphics$InnerStroke((java.awt.BasicStroke)object);
        }
        if (n2 == 2) {
            return new J2DPrismGraphics$OuterStroke((java.awt.BasicStroke)object);
        }
        return object;
    }

    private static Font toJ2DFont(FontStrike fontStrike) {
        Object object;
        FontResource fontResource = fontStrike.getFontResource();
        Object object2 = fontResource.getPeer();
        if (object2 == null && fontResource.isEmbeddedFont()) {
            J2DFontFactory.registerFont(fontResource);
            object2 = fontResource.getPeer();
        }
        if (object2 != null && object2 instanceof Font) {
            object2 = (Font)object2;
        } else {
            if (PlatformUtil.isMac()) {
                object = fontResource.getPSName();
                object2 = new Font((String)object, 0, 12);
                if (!((Font)object2).getPSName().equals(object)) {
                    int n2 = fontResource.isBold() ? 1 : 0;
                    n2 = n2 | (fontResource.isItalic() ? 2 : 0);
                    object2 = new Font(fontResource.getFamilyName(), n2, 12);
                    if (!((Font)object2).getPSName().equals(object)) {
                        Font[] fontArray;
                        Font[] fontArray2 = fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                        n2 = fontArray.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            Font font = fontArray2[i2];
                            if (!font.getPSName().equals(object)) continue;
                            object2 = font;
                            break;
                        }
                    }
                }
            } else {
                object2 = new Font(fontResource.getFullName(), 0, 12);
            }
            fontResource.setPeer(object2);
        }
        object2 = ((Font)object2).deriveFont(fontStrike.getSize());
        object = null;
        WeakReference<Object> weakReference = fontMap.get(object2);
        if (weakReference != null && (object = (Font)weakReference.get()) == null) {
            ++cleared;
        }
        if (object == null) {
            if (fontMap.size() > 100 && cleared > 10) {
                for (Font[] fontArray2 : fontMap.keySet()) {
                    weakReference = fontMap.get(fontArray2);
                    if (weakReference != null && weakReference.get() != null) continue;
                    fontMap.remove(fontArray2);
                }
                cleared = 0;
            }
            object = J2DFontFactory.getCompositeFont((Font)object2);
            weakReference = new WeakReference<Object>(object);
            fontMap.put((Font)object2, weakReference);
        }
        return object;
    }

    public static AffineTransform toJ2DTransform(BaseTransform baseTransform) {
        return new AffineTransform(baseTransform.getMxx(), baseTransform.getMyx(), baseTransform.getMxy(), baseTransform.getMyy(), baseTransform.getMxt(), baseTransform.getMyt());
    }

    static AffineTransform tmpJ2DTransform(BaseTransform baseTransform) {
        tmpAT.setTransform(baseTransform.getMxx(), baseTransform.getMyx(), baseTransform.getMxy(), baseTransform.getMyy(), baseTransform.getMxt(), baseTransform.getMyt());
        return tmpAT;
    }

    static BaseTransform toPrTransform(AffineTransform affineTransform) {
        return BaseTransform.getInstance(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    static Rectangle toPrRect(java.awt.Rectangle rectangle) {
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private static Shape tmpQuad(float f2, float f3, float f4, float f5) {
        tmpQuadShape.reset();
        tmpQuadShape.moveTo(f2, f3);
        tmpQuadShape.lineTo(f4, f3);
        tmpQuadShape.lineTo(f4, f5);
        tmpQuadShape.lineTo(f2, f5);
        tmpQuadShape.closePath();
        return tmpQuadShape;
    }

    private static Rectangle2D tmpRect(float f2, float f3, float f4, float f5) {
        tmpRect.setRect(f2, f3, f4, f5);
        return tmpRect;
    }

    private static Shape tmpEllipse(float f2, float f3, float f4, float f5) {
        tmpEllipse.setFrame(f2, f3, f4, f5);
        return tmpEllipse;
    }

    private static Shape tmpRRect(float f2, float f3, float f4, float f5, float f6, float f7) {
        tmpRRect.setRoundRect(f2, f3, f4, f5, f6, f7);
        return tmpRRect;
    }

    private static Shape tmpLine(float f2, float f3, float f4, float f5) {
        tmpLine.setLine(f2, f3, f4, f5);
        return tmpLine;
    }

    private static Shape tmpShape(com.sun.javafx.geom.Shape shape) {
        tmpAdaptor.setShape(shape);
        return tmpAdaptor;
    }

    J2DPrismGraphics(J2DPresentable j2DPresentable, Graphics2D graphics2D) {
        this(graphics2D, j2DPresentable.getContentWidth(), j2DPresentable.getContentHeight());
        this.target = j2DPresentable;
    }

    J2DPrismGraphics(Graphics2D graphics2D, int n2, int n3) {
        this.g2d = graphics2D;
        this.captureTransform(graphics2D);
        this.transform = new Affine2D();
        this.devClipRect = new RectBounds(0.0f, 0.0f, n2, n3);
        this.finalClipRect = new RectBounds(0.0f, 0.0f, n2, n3);
        this.cull = true;
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        this.setPaint(DEFAULT_PAINT);
        this.setStroke(DEFAULT_STROKE);
    }

    @Override
    public RenderTarget getRenderTarget() {
        return this.target;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.target.getAssociatedScreen();
    }

    @Override
    public ResourceFactory getResourceFactory() {
        return this.target.getResourceFactory();
    }

    public void reset() {
    }

    @Override
    public Rectangle getClipRect() {
        if (this.clipRect == null) {
            return null;
        }
        return new Rectangle(this.clipRect);
    }

    @Override
    public Rectangle getClipRectNoClone() {
        return this.clipRect;
    }

    @Override
    public RectBounds getFinalClipNoClone() {
        return this.finalClipRect;
    }

    @Override
    public void setClipRect(Rectangle rectangle) {
        this.finalClipRect.setBounds(this.devClipRect);
        if (rectangle == null) {
            this.clipRect = null;
            this.g2d.setClip(null);
            return;
        }
        this.clipRect = new Rectangle(rectangle);
        ((BaseBounds)this.finalClipRect).intersectWith(rectangle);
        this.setTransformG2D(J2D_IDENTITY);
        this.g2d.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        J2DPrismGraphics j2DPrismGraphics = this;
        j2DPrismGraphics.setTransformG2D(J2DPrismGraphics.tmpJ2DTransform(j2DPrismGraphics.transform));
    }

    private AlphaComposite getAWTComposite() {
        return (AlphaComposite)this.g2d.getComposite();
    }

    @Override
    public float getExtraAlpha() {
        return this.getAWTComposite().getAlpha();
    }

    @Override
    public void setExtraAlpha(float f2) {
        this.g2d.setComposite(this.getAWTComposite().derive(f2));
    }

    @Override
    public CompositeMode getCompositeMode() {
        int n2 = this.getAWTComposite().getRule();
        switch (n2) {
            case 1: {
                return CompositeMode.CLEAR;
            }
            case 2: {
                return CompositeMode.SRC;
            }
            case 3: {
                return CompositeMode.SRC_OVER;
            }
        }
        throw new InternalError("Unrecognized AlphaCompsite rule: " + n2);
    }

    @Override
    public void setCompositeMode(CompositeMode compositeMode) {
        AlphaComposite alphaComposite = this.getAWTComposite();
        switch (compositeMode) {
            case CLEAR: {
                alphaComposite = alphaComposite.derive(1);
                break;
            }
            case SRC: {
                alphaComposite = alphaComposite.derive(2);
                break;
            }
            case SRC_OVER: {
                alphaComposite = alphaComposite.derive(3);
                break;
            }
            default: {
                throw new InternalError("Unrecognized composite mode: " + String.valueOf((Object)compositeMode));
            }
        }
        this.g2d.setComposite(alphaComposite);
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint object) {
        this.paint = object;
        if ((object = this.toJ2DPaint((Paint)object, null)) == null) {
            this.paintWasProportional = true;
            return;
        }
        this.paintWasProportional = false;
        this.g2d.setPaint((java.awt.Paint)object);
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        this.stroke = basicStroke;
        this.g2d.setStroke(J2DPrismGraphics.toJ2DStroke(basicStroke));
    }

    @Override
    public BaseTransform getTransformNoClone() {
        return this.transform;
    }

    @Override
    public void translate(float f2, float f3) {
        this.transform.translate(f2, f3);
        this.g2d.translate(f2, f3);
    }

    @Override
    public void scale(float f2, float f3) {
        this.transform.scale(f2, f3);
        this.g2d.scale(f2, f3);
    }

    @Override
    public void transform(BaseTransform baseTransform) {
        if (!baseTransform.is2D()) {
            return;
        }
        this.transform.concatenate(baseTransform);
        J2DPrismGraphics j2DPrismGraphics = this;
        j2DPrismGraphics.setTransformG2D(J2DPrismGraphics.tmpJ2DTransform(j2DPrismGraphics.transform));
    }

    @Override
    public void setTransform(BaseTransform baseTransform) {
        if (baseTransform == null) {
            baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        }
        ((BaseTransform)this.transform).setTransform(baseTransform);
        J2DPrismGraphics j2DPrismGraphics = this;
        j2DPrismGraphics.setTransformG2D(J2DPrismGraphics.tmpJ2DTransform(j2DPrismGraphics.transform));
    }

    @Override
    public void setTransform(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.transform.setTransform(d2, d3, d4, d5, d6, d7);
        J2DPrismGraphics j2DPrismGraphics = this;
        j2DPrismGraphics.setTransformG2D(J2DPrismGraphics.tmpJ2DTransform(j2DPrismGraphics.transform));
    }

    @Override
    public void clear() {
        this.clear(com.sun.prism.paint.Color.TRANSPARENT);
    }

    @Override
    public void clear(com.sun.prism.paint.Color color) {
        this.getRenderTarget().setOpaque(((Paint)color).isOpaque());
        this.clear(J2DPrismGraphics.toJ2DColor(color));
    }

    void clear(Color color) {
        Graphics2D graphics2D = (Graphics2D)this.g2d.create();
        graphics2D.setTransform(J2D_IDENTITY);
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, this.target.getContentWidth(), this.target.getContentHeight());
        graphics2D.dispose();
    }

    @Override
    public void clearQuad(float f2, float f3, float f4, float f5) {
        this.g2d.setComposite(AlphaComposite.Clear);
        this.g2d.fill(J2DPrismGraphics.tmpQuad(f2, f3, f4, f5));
    }

    void fill(Shape shape) {
        if (this.paintWasProportional) {
            if (this.nodeBounds != null) {
                J2DPrismGraphics j2DPrismGraphics = this;
                this.g2d.setPaint(j2DPrismGraphics.toJ2DPaint(j2DPrismGraphics.paint, this.nodeBounds));
            } else {
                J2DPrismGraphics j2DPrismGraphics = this;
                this.g2d.setPaint(j2DPrismGraphics.toJ2DPaint(j2DPrismGraphics.paint, shape.getBounds2D()));
            }
        }
        if (this.paint.getType() == Paint$Type.IMAGE_PATTERN) {
            Object object = (ImagePattern)this.paint;
            if (!((AffineTransform)(object = J2DPrismGraphics.toJ2DTransform(((ImagePattern)object).getPatternTransformNoClone()))).isIdentity()) {
                this.g2d.setClip(shape);
                this.g2d.transform((AffineTransform)object);
                tmpAT.setTransform((AffineTransform)object);
                try {
                    tmpAT.invert();
                    this.g2d.fill(tmpAT.createTransformedShape(shape));
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {}
                J2DPrismGraphics j2DPrismGraphics = this;
                j2DPrismGraphics.setTransform(j2DPrismGraphics.transform);
                J2DPrismGraphics j2DPrismGraphics2 = this;
                j2DPrismGraphics2.setClipRect(j2DPrismGraphics2.clipRect);
                return;
            }
        }
        this.g2d.fill(shape);
    }

    @Override
    public void fill(com.sun.javafx.geom.Shape shape) {
        this.fill(J2DPrismGraphics.tmpShape(shape));
    }

    @Override
    public void fillRect(float f2, float f3, float f4, float f5) {
        this.fill(J2DPrismGraphics.tmpRect(f2, f3, f4, f5));
    }

    @Override
    public void fillRoundRect(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.fill(J2DPrismGraphics.tmpRRect(f2, f3, f4, f5, f6, f7));
    }

    @Override
    public void fillEllipse(float f2, float f3, float f4, float f5) {
        this.fill(J2DPrismGraphics.tmpEllipse(f2, f3, f4, f5));
    }

    @Override
    public void fillQuad(float f2, float f3, float f4, float f5) {
        this.fill(J2DPrismGraphics.tmpQuad(f2, f3, f4, f5));
    }

    void draw(Shape shape) {
        if (this.paintWasProportional) {
            if (this.nodeBounds != null) {
                J2DPrismGraphics j2DPrismGraphics = this;
                this.g2d.setPaint(j2DPrismGraphics.toJ2DPaint(j2DPrismGraphics.paint, this.nodeBounds));
            } else {
                J2DPrismGraphics j2DPrismGraphics = this;
                this.g2d.setPaint(j2DPrismGraphics.toJ2DPaint(j2DPrismGraphics.paint, shape.getBounds2D()));
            }
        }
        try {
            this.g2d.draw(shape);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    @Override
    public void draw(com.sun.javafx.geom.Shape shape) {
        this.draw(J2DPrismGraphics.tmpShape(shape));
    }

    @Override
    public void drawLine(float f2, float f3, float f4, float f5) {
        this.draw(J2DPrismGraphics.tmpLine(f2, f3, f4, f5));
    }

    @Override
    public void drawRect(float f2, float f3, float f4, float f5) {
        this.draw(J2DPrismGraphics.tmpRect(f2, f3, f4, f5));
    }

    @Override
    public void drawRoundRect(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.draw(J2DPrismGraphics.tmpRRect(f2, f3, f4, f5, f6, f7));
    }

    @Override
    public void drawEllipse(float f2, float f3, float f4, float f5) {
        this.draw(J2DPrismGraphics.tmpEllipse(f2, f3, f4, f5));
    }

    @Override
    public void setNodeBounds(RectBounds rectBounds) {
        this.nodeBounds = rectBounds != null ? new Rectangle2D.Float(((BaseBounds)rectBounds).getMinX(), ((BaseBounds)rectBounds).getMinY(), ((BaseBounds)rectBounds).getWidth(), ((BaseBounds)rectBounds).getHeight()) : null;
    }

    private void drawString(GlyphList glyphList, int n2, int n3, FontStrike object, float f2, float f3) {
        if (n2 == n3) {
            return;
        }
        Object object2 = new int[n3 -= n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            object2[i2] = glyphList.getGlyphCode(n2 + i2) & 0xFFFFFF;
        }
        Font font = J2DPrismGraphics.toJ2DFont((FontStrike)object);
        object = font.createGlyphVector(this.g2d.getFontRenderContext(), (int[])object2);
        object2 = new Point2D.Float();
        for (int i3 = 0; i3 < n3; ++i3) {
            ((Point2D)object2).setLocation(glyphList.getPosX(n2 + i3), glyphList.getPosY(n2 + i3));
            ((GlyphVector)object).setGlyphPosition(i3, (Point2D)object2);
        }
        this.g2d.drawGlyphVector((GlyphVector)object, f2, f3);
    }

    @Override
    public void drawString(GlyphList glyphList, FontStrike fontStrike, float f2, float f3, com.sun.prism.paint.Color color, int n2, int n3) {
        int n4;
        Object object;
        int n5 = glyphList.getGlyphCount();
        if (n5 == 0) {
            return;
        }
        if (fontStrike.getFontResource().isColorGlyph(glyphList.getGlyphCode(0))) {
            this.drawColorGlyph(glyphList, fontStrike, f2, f3, color, n2, n3);
            return;
        }
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (fontStrike.getAAMode() == 1) {
            this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        }
        if (this.paintWasProportional) {
            object = this.nodeBounds;
            if (object == null) {
                Metrics metrics = fontStrike.getMetrics();
                object = new Rectangle2D.Float(0.0f, metrics.getAscent(), glyphList.getWidth(), metrics.getLineHeight());
            }
            J2DPrismGraphics j2DPrismGraphics = this;
            this.g2d.setPaint(j2DPrismGraphics.toJ2DPaint(j2DPrismGraphics.paint, (Rectangle2D)object));
        }
        object = null;
        int n6 = 0;
        if (fontStrike instanceof CompositeStrike) {
            object = (CompositeStrike)fontStrike;
            int n7 = glyphList.getGlyphCode(0);
            n6 = ((CompositeStrike)object).getStrikeSlotForGlyph(n7);
        }
        Color color2 = null;
        Color color3 = null;
        int n8 = 0;
        if (color != null) {
            color2 = J2DPrismGraphics.toJ2DColor(color);
            color3 = this.g2d.getColor();
            n4 = glyphList.getCharOffset(0);
            n8 = n2 <= n4 && n4 < n3 ? 1 : 0;
        }
        n4 = 0;
        if (color2 != null || object != null) {
            for (int i2 = 1; i2 < n5; ++i2) {
                int n9;
                if (color2 != null) {
                    n9 = glyphList.getCharOffset(i2);
                    int n10 = n9 = n2 <= n9 && n9 < n3 ? 1 : 0;
                    if (n8 != n9) {
                        if (object != null) {
                            fontStrike = ((CompositeStrike)object).getStrikeSlot(n6);
                        }
                        this.g2d.setColor(n8 != 0 ? color2 : color3);
                        this.drawString(glyphList, n4, i2, fontStrike, f2, f3);
                        n4 = i2;
                        n8 = n9;
                    }
                }
                if (object == null) continue;
                n9 = glyphList.getGlyphCode(i2);
                if (n6 == (n9 = ((CompositeStrike)object).getStrikeSlotForGlyph(n9))) continue;
                fontStrike = ((CompositeStrike)object).getStrikeSlot(n6);
                if (color2 != null) {
                    this.g2d.setColor(n8 != 0 ? color2 : color3);
                }
                this.drawString(glyphList, n4, i2, fontStrike, f2, f3);
                n4 = i2;
                n6 = n9;
            }
            if (object != null) {
                fontStrike = ((CompositeStrike)object).getStrikeSlot(n6);
            }
            if (color2 != null) {
                this.g2d.setColor(n8 != 0 ? color2 : color3);
            }
        }
        this.drawString(glyphList, n4, n5, fontStrike, f2, f3);
        if (color != null) {
            this.g2d.setColor(color3);
        }
        this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected void setTransformG2D(AffineTransform affineTransform) {
        this.g2d.setTransform(affineTransform);
    }

    protected void captureTransform(Graphics2D graphics2D) {
    }

    @Override
    public void drawMappedTextureRaw(Texture object, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        object = ((J2DTexture)object).getBufferedImage();
        this.setTransformG2D(J2D_IDENTITY);
        tmpAT.setTransform(f8 -= f6, f9 -= f7, f10 -= f6, f11 -= f7, f6, f7);
        try {
            tmpAT.invert();
            this.g2d.translate(f2, f3);
            this.g2d.scale(f4 - f2, f5 - f3);
            this.g2d.transform(tmpAT);
            this.g2d.drawImage((Image)object, 0, 0, 1, 1, null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
        J2DPrismGraphics j2DPrismGraphics = this;
        j2DPrismGraphics.setTransform(j2DPrismGraphics.transform);
    }

    @Override
    public void drawTexture(Texture object, float f2, float f3, float f4, float f5) {
        object = ((J2DTexture)object).getBufferedImage();
        this.g2d.drawImage((Image)object, (int)f2, (int)f3, (int)(f2 + f4), (int)(f3 + f5), 0, 0, (int)f4, (int)f5, null);
    }

    @Override
    public void drawTexture(Texture object, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        object = ((J2DTexture)object).getBufferedImage();
        this.g2d.drawImage((Image)object, (int)f2, (int)f3, (int)f4, (int)f5, (int)f6, (int)f7, (int)f8, (int)f9, null);
    }

    @Override
    public void drawTexture3SliceH(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        if (f12 + 0.1f > f13) {
            f13 += 1.0f;
        }
        this.drawTexture(texture, f2, f3, f10, f5, f6, f7, f12, f9);
        this.drawTexture(texture, f10, f3, f11, f5, f12, f7, f13, f9);
        this.drawTexture(texture, f11, f3, f4, f5, f13, f7, f8, f9);
    }

    @Override
    public void drawTexture3SliceV(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        if (f12 + 0.1f > f13) {
            f13 += 1.0f;
        }
        this.drawTexture(texture, f2, f3, f4, f10, f6, f7, f8, f12);
        this.drawTexture(texture, f2, f10, f4, f11, f6, f12, f8, f13);
        this.drawTexture(texture, f2, f11, f4, f5, f6, f13, f8, f9);
    }

    @Override
    public void drawTexture9Slice(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17) {
        if (f14 + 0.1f > f16) {
            f16 += 1.0f;
        }
        if (f15 + 0.1f > f17) {
            f17 += 1.0f;
        }
        this.drawTexture(texture, f2, f3, f10, f11, f6, f7, f14, f15);
        this.drawTexture(texture, f10, f3, f12, f11, f14, f7, f16, f15);
        this.drawTexture(texture, f12, f3, f4, f11, f16, f7, f8, f15);
        this.drawTexture(texture, f2, f11, f10, f13, f6, f15, f14, f17);
        this.drawTexture(texture, f10, f11, f12, f13, f14, f15, f16, f17);
        this.drawTexture(texture, f12, f11, f4, f13, f16, f15, f8, f17);
        this.drawTexture(texture, f2, f13, f10, f5, f6, f17, f14, f9);
        this.drawTexture(texture, f10, f13, f12, f5, f14, f17, f16, f9);
        this.drawTexture(texture, f12, f13, f4, f5, f16, f17, f8, f9);
    }

    @Override
    public void drawTextureRaw(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        int n2 = texture.getContentWidth();
        int n3 = texture.getContentHeight();
        this.drawTexture(texture, f2, f3, f4, f5, f6 *= (float)n2, f7 *= (float)n3, f8 *= (float)n2, f9 *= (float)n3);
    }

    @Override
    public void drawTextureVO(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        java.awt.Paint paint = this.g2d.getPaint();
        Composite composite = this.g2d.getComposite();
        Color color = new Color(1.0f, 1.0f, 1.0f, f2);
        Color color2 = new Color(1.0f, 1.0f, 1.0f, f3);
        this.g2d.setPaint(new GradientPaint(0.0f, f5, color, 0.0f, f7, color2, true));
        this.g2d.setComposite(AlphaComposite.Src);
        int n2 = (int)Math.floor(Math.min(f4, f6));
        int n3 = (int)Math.floor(Math.min(f5, f7));
        int n4 = (int)Math.ceil(Math.max(f4, f6)) - n2;
        int n5 = (int)Math.ceil(Math.max(f5, f7)) - n3;
        this.g2d.fillRect(n2, n3, n4, n5);
        this.g2d.setComposite(AlphaComposite.SrcIn);
        this.drawTexture(texture, f4, f5, f6, f7, f8, f9, f10, f11);
        this.g2d.setComposite(composite);
        this.g2d.setPaint(paint);
    }

    @Override
    public void drawPixelsMasked(RTTexture rTTexture, RTTexture rTTexture2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.doDrawMaskTexture((J2DRTTexture)rTTexture, (J2DRTTexture)rTTexture2, n2, n3, n4, n5, n6, n7, n8, n9, true);
    }

    @Override
    public void maskInterpolatePixels(RTTexture rTTexture, RTTexture rTTexture2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.doDrawMaskTexture((J2DRTTexture)rTTexture, (J2DRTTexture)rTTexture2, n2, n3, n4, n5, n6, n7, n8, n9, false);
    }

    private void doDrawMaskTexture(J2DRTTexture j2DRTTexture, J2DRTTexture j2DRTTexture2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean n10) {
        int n11;
        int n12 = this.clipRect.x;
        int n13 = this.clipRect.y;
        int n14 = n12 + this.clipRect.width;
        int n15 = n13 + this.clipRect.height;
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        if (n2 < n12) {
            n11 = n12 - n2;
            if ((n4 -= n11) <= 0) {
                return;
            }
            n6 += n11;
            n8 += n11;
            n2 = n12;
        }
        if (n3 < n13) {
            n11 = n13 - n3;
            if ((n5 -= n11) <= 0) {
                return;
            }
            n7 += n11;
            n9 += n11;
            n3 = n13;
        }
        if (n2 + n4 > n14 && (n4 = n14 - n2) <= 0) {
            return;
        }
        if (n3 + n5 > n15 && (n5 = n15 - n3) <= 0) {
            return;
        }
        n11 = j2DRTTexture.getContentWidth();
        n12 = j2DRTTexture.getContentHeight();
        if (n6 < 0) {
            if ((n4 += n6) <= 0) {
                return;
            }
            n2 -= n6;
            n8 -= n6;
            n6 = 0;
        }
        if (n7 < 0) {
            if ((n5 += n7) <= 0) {
                return;
            }
            n3 -= n7;
            n9 -= n7;
            n7 = 0;
        }
        if (n6 + n4 > n11 && (n4 = n11 - n6) <= 0) {
            return;
        }
        if (n7 + n5 > n12 && (n5 = n12 - n7) <= 0) {
            return;
        }
        n12 = j2DRTTexture2.getContentWidth();
        n13 = j2DRTTexture2.getContentHeight();
        if (n8 < 0) {
            if ((n4 += n8) <= 0) {
                return;
            }
            n2 -= n8;
            n6 -= n8;
            n8 = 0;
        }
        if (n9 < 0) {
            if ((n5 += n9) <= 0) {
                return;
            }
            n3 -= n9;
            n7 -= n9;
            n9 = 0;
        }
        if (n8 + n4 > n12 && (n4 = n12 - n8) <= 0) {
            return;
        }
        if (n9 + n5 > n13 && (n5 = n13 - n9) <= 0) {
            return;
        }
        int[] nArray = j2DRTTexture.getPixels();
        int[] nArray2 = j2DRTTexture2.getPixels();
        Object object = this.target.getBackBuffer().getRaster().getDataBuffer();
        object = ((DataBufferInt)object).getData();
        int n16 = j2DRTTexture.getBufferedImage().getWidth();
        int n17 = j2DRTTexture2.getBufferedImage().getWidth();
        n15 = this.target.getBackBuffer().getWidth();
        n6 = n7 * n16 + n6;
        n7 = n9 * n17 + n8;
        n2 = n3 * n15 + n2;
        if (n10 != false) {
            for (n3 = 0; n3 < n5; ++n3) {
                for (n8 = 0; n8 < n4; ++n8) {
                    int n18;
                    Object object2;
                    int n19 = nArray2[n7 + n8] >>> 24;
                    if (n19 == 0 || (n9 = (object2 = nArray[n6 + n8]) >>> 24) == 0) continue;
                    if (n19 < 255) {
                        int n20 = n19;
                        n19 = n20 + (n20 >> 7);
                        n9 *= n19;
                        n10 = (object2 >> 16 & 0xFF) * n19;
                        n11 = (object2 >> 8 & 0xFF) * n19;
                        n18 = (object2 & 0xFF) * n19;
                    } else if (n9 < 255) {
                        n9 <<= 8;
                        n10 = (object2 >> 16 & 0xFF) << 8;
                        n11 = (object2 >> 8 & 0xFF) << 8;
                        n18 = (object2 & 0xFF) << 8;
                    } else {
                        object[n2 + n8] = object2;
                        continue;
                    }
                    n19 = n9 + 128 >> 8;
                    n19 += n19 >> 7;
                    n19 = 256 - n19;
                    object2 = object[n2 + n8];
                    n9 += (object2 >>> 24) * n19 + 128;
                    n10 += (object2 >> 16 & 0xFF) * n19 + 128;
                    n11 += (object2 >> 8 & 0xFF) * n19 + 128;
                    n18 += (object2 & 0xFF) * n19 + 128;
                    object2 = (n9 >> 8 << 24) + (n10 >> 8 << 16) + (n11 >> 8 << 8) + (n18 >> 8);
                    object[n2 + n8] = object2;
                }
                n6 += n16;
                n7 += n17;
                n2 += n15;
            }
            return;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (n8 = 0; n8 < n4; ++n8) {
                n9 = nArray2[n7 + n8] >>> 24;
                if (n9 == 0) continue;
                n10 = nArray[n6 + n8];
                if (n9 < 255) {
                    int n21 = n9;
                    n9 = n21 + (n21 >> 7);
                    n11 = (n10 >>> 24) * n9;
                    int n22 = (n10 >> 16 & 0xFF) * n9;
                    int n23 = (n10 >> 8 & 0xFF) * n9;
                    int n24 = (n10 & 0xFF) * n9;
                    n9 = 256 - n9;
                    n10 = object[n2 + n8];
                    n11 += (n10 >>> 24) * n9 + 128;
                    n22 += (n10 >> 16 & 0xFF) * n9 + 128;
                    n23 += (n10 >> 8 & 0xFF) * n9 + 128;
                    n24 += (n10 & 0xFF) * n9 + 128;
                    n10 = (n11 >> 8 << 24) + (n22 >> 8 << 16) + (n23 >> 8 << 8) + (n24 >> 8);
                }
                object[n2 + n8] = n10;
            }
            n6 += n16;
            n7 += n17;
            n2 += n15;
        }
    }

    @Override
    public boolean canReadBack() {
        return true;
    }

    @Override
    public RTTexture readBack(Rectangle rectangle) {
        J2DRTTexture j2DRTTexture = this.target.getReadbackBuffer();
        Graphics2D graphics2D = j2DRTTexture.createAWTGraphics2D();
        graphics2D.setComposite(AlphaComposite.Src);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        graphics2D.drawImage(this.target.getBackBuffer(), 0, 0, n4, n5, n2, n3, n6, n7, null);
        graphics2D.dispose();
        return j2DRTTexture;
    }

    @Override
    public void releaseReadBackBuffer(RTTexture rTTexture) {
    }

    @Override
    public NGCamera getCameraNoClone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPerspectiveTransform(GeneralTransform3D generalTransform3D) {
    }

    @Override
    public boolean isDepthBuffer() {
        return false;
    }

    @Override
    public boolean isDepthTest() {
        return false;
    }

    @Override
    public boolean isAlphaTestShader() {
        if (PrismSettings.verbose && PrismSettings.forceAlphaTestShader) {
            System.out.println("J2D pipe doesn't support shader with alpha testing");
        }
        return false;
    }

    @Override
    public void setAntialiasedShape(boolean bl2) {
        this.antialiasedShape = bl2;
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasedShape ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public boolean isAntialiasedShape() {
        return this.antialiasedShape;
    }

    @Override
    public void scale(float f2, float f3, float f4) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTransform3D(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        if (d4 != 0.0 || d8 != 0.0 || d10 != 0.0 || d11 != 0.0 || d12 != 1.0 || d13 != 0.0) {
            throw new UnsupportedOperationException("3D transforms not supported.");
        }
        this.setTransform(d2, d6, d3, d7, d5, d9);
    }

    @Override
    public void setCamera(NGCamera nGCamera) {
    }

    @Override
    public void setDepthBuffer(boolean bl2) {
    }

    @Override
    public void setDepthTest(boolean bl2) {
    }

    @Override
    public void sync() {
    }

    @Override
    public void translate(float f2, float f3, float f4) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCulling(boolean bl2) {
        this.cull = bl2;
    }

    public boolean isCulling() {
        return this.cull;
    }

    @Override
    public void setClipRectIndex(int n2) {
        this.clipRectIndex = n2;
    }

    @Override
    public int getClipRectIndex() {
        return this.clipRectIndex;
    }

    @Override
    public void setHasPreCullingBits(boolean bl2) {
        this.hasPreCullingBits = bl2;
    }

    @Override
    public boolean hasPreCullingBits() {
        return this.hasPreCullingBits;
    }

    @Override
    public void setRenderRoot(NodePath nodePath) {
        this.renderRoot = nodePath;
    }

    @Override
    public NodePath getRenderRoot() {
        return this.renderRoot;
    }

    @Override
    public void setState3D(boolean bl2) {
    }

    @Override
    public boolean isState3D() {
        return false;
    }

    @Override
    public void setup3DRendering() {
    }

    @Override
    public void setPixelScaleFactors(float f2, float f3) {
        this.pixelScaleX = f2;
        this.pixelScaleY = f3;
    }

    @Override
    public float getPixelScaleFactorX() {
        return this.pixelScaleX;
    }

    @Override
    public float getPixelScaleFactorY() {
        return this.pixelScaleY;
    }

    @Override
    public void blit(RTTexture rTTexture, RTTexture rTTexture2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLights(NGLightBase[] nGLightBaseArray) {
    }

    @Override
    public NGLightBase[] getLights() {
        return null;
    }
}

