/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d.print;

import com.sun.glass.ui.Application;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.Graphics;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.j2d.J2DPrismGraphics;
import com.sun.prism.j2d.PrismPrintGraphics;
import com.sun.prism.j2d.print.J2DPrinter;
import com.sun.prism.j2d.print.J2DPrinterJob;
import com.sun.prism.j2d.print.J2DPrinterJob$ClearSceneRunnable;
import com.sun.prism.j2d.print.J2DPrinterJob$ExitLoopRunnable;
import com.sun.prism.j2d.print.J2DPrinterJob$PageInfo;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.scene.Node;

class J2DPrinterJob$J2DPageable
implements Pageable,
Printable {
    private volatile boolean pageDone;
    private int currPageIndex = -1;
    private volatile J2DPrinterJob$PageInfo newPageInfo = null;
    private J2DPrinterJob$PageInfo currPageInfo;
    private PageFormat currPageFormat;
    final /* synthetic */ J2DPrinterJob this$0;

    private J2DPrinterJob$J2DPageable(J2DPrinterJob j2DPrinterJob) {
        this.this$0 = j2DPrinterJob;
    }

    private boolean waitForNextPage(int n2) {
        if (this.this$0.elo != null && this.currPageInfo != null) {
            Application.invokeLater(new J2DPrinterJob$ExitLoopRunnable(this.this$0.elo, null));
        }
        if (this.currPageInfo != null) {
            if (Toolkit.getToolkit().isFxUserThread()) {
                this.currPageInfo.clearScene();
            } else {
                Application.invokeAndWait(new J2DPrinterJob$ClearSceneRunnable(this.currPageInfo));
            }
        }
        this.currPageInfo = null;
        this.pageDone = true;
        Object object = this.this$0.monitor;
        synchronized (object) {
            if (this.newPageInfo == null) {
                this.this$0.monitor.notify();
            }
            while (!(this.newPageInfo != null || this.this$0.jobDone || this.this$0.jobCanceled || this.this$0.jobError)) {
                try {
                    this.this$0.monitor.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.this$0.jobDone && this.newPageInfo == null || this.this$0.jobCanceled || this.this$0.jobError) {
            return false;
        }
        this.currPageInfo = this.newPageInfo;
        this.newPageInfo = null;
        this.currPageIndex = n2;
        this.currPageFormat = this.getPageFormatFromLayout(this.currPageInfo.getPageLayout());
        return true;
    }

    private PageFormat getPageFormatFromLayout(PageLayout object) {
        Paper paper = new Paper();
        double d2 = ((PageLayout)object).getPaper().getWidth();
        double d3 = ((PageLayout)object).getPaper().getHeight();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = d2;
        double d7 = d3;
        PageOrientation pageOrientation = ((PageLayout)object).getPageOrientation();
        switch (pageOrientation) {
            case PORTRAIT: {
                d4 = ((PageLayout)object).getLeftMargin();
                d5 = ((PageLayout)object).getTopMargin();
                d6 = d2 - d4 - ((PageLayout)object).getRightMargin();
                d7 = d3 - d5 - ((PageLayout)object).getBottomMargin();
                break;
            }
            case REVERSE_PORTRAIT: {
                d4 = ((PageLayout)object).getRightMargin();
                d5 = ((PageLayout)object).getBottomMargin();
                d6 = d2 - d4 - ((PageLayout)object).getLeftMargin();
                d7 = d3 - d5 - ((PageLayout)object).getTopMargin();
                break;
            }
            case LANDSCAPE: {
                d4 = ((PageLayout)object).getBottomMargin();
                d5 = ((PageLayout)object).getLeftMargin();
                d6 = d2 - d4 - ((PageLayout)object).getTopMargin();
                d7 = d3 - d5 - ((PageLayout)object).getRightMargin();
                break;
            }
            case REVERSE_LANDSCAPE: {
                d4 = ((PageLayout)object).getTopMargin();
                d5 = ((PageLayout)object).getRightMargin();
                d6 = d2 - d4 - ((PageLayout)object).getBottomMargin();
                d7 = d3 - d5 - ((PageLayout)object).getLeftMargin();
            }
        }
        paper.setSize(d2, d3);
        paper.setImageableArea(d4, d5, d6, d7);
        object = new PageFormat();
        ((PageFormat)object).setOrientation(J2DPrinter.getOrientID(pageOrientation));
        ((PageFormat)object).setPaper(paper);
        return object;
    }

    private boolean getPage(int n2) {
        if (n2 == this.currPageIndex) {
            return true;
        }
        boolean bl2 = false;
        if (n2 > this.currPageIndex) {
            bl2 = this.waitForNextPage(n2);
        }
        return bl2;
    }

    @Override
    public int print(java.awt.Graphics graphics, PageFormat pageFormat, int n2) {
        if (this.this$0.jobError || this.this$0.jobCanceled || this.this$0.jobDone && !this.getPage(n2)) {
            return 1;
        }
        n2 = (int)pageFormat.getImageableX();
        int n3 = (int)pageFormat.getImageableY();
        int n4 = (int)pageFormat.getImageableWidth();
        int n5 = (int)pageFormat.getImageableHeight();
        Node node = this.currPageInfo.getNode();
        graphics.translate(n2, n3);
        this.printNode(node, graphics, n4, n5);
        return 0;
    }

    private void printNode(Node node, java.awt.Graphics object, int n2, int n3) {
        object = new PrismPrintGraphics((Graphics2D)object, n2, n3);
        node = NodeHelper.getPeer(node);
        n2 = 0;
        try {
            ((NGNode)((Object)node)).render((Graphics)object);
        }
        catch (Throwable throwable) {
            if (PrismSettings.debug) {
                System.err.println("printNode caught exception.");
                throwable.printStackTrace();
            }
            n2 = 1;
        }
        ((J2DPrismGraphics)object).getResourceFactory().getTextureResourcePool().freeDisposalRequestedAndCheckResources(n2 != 0);
    }

    @Override
    public Printable getPrintable(int n2) {
        this.getPage(n2);
        return this;
    }

    @Override
    public PageFormat getPageFormat(int n2) {
        this.getPage(n2);
        return this.currPageFormat;
    }

    @Override
    public int getNumberOfPages() {
        return -1;
    }

    private void implPrintPage(PageLayout pageLayout, Node node) {
        this.pageDone = false;
        Object object = this.this$0.monitor;
        synchronized (object) {
            this.newPageInfo = new J2DPrinterJob$PageInfo(pageLayout, node);
            this.this$0.monitor.notify();
        }
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.this$0.elo = new Object();
            Toolkit.getToolkit().enterNestedEventLoop(this.this$0.elo);
            this.this$0.elo = null;
            return;
        }
        while (!(this.pageDone || this.this$0.jobDone || this.this$0.jobCanceled || this.this$0.jobError)) {
            object = this.this$0.monitor;
            synchronized (object) {
                try {
                    if (!this.pageDone) {
                        this.this$0.monitor.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

