/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.pisces.PiscesRenderer;
import com.sun.pisces.Transform6;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.paint.Stop;
import com.sun.prism.sw.SWArgbPreTexture;
import com.sun.prism.sw.SWContext;
import com.sun.prism.sw.SWTexture;
import com.sun.prism.sw.SWUtils;

final class SWPaint {
    private final SWContext context;
    private final PiscesRenderer pr;
    private final BaseTransform paintTx = new Affine2D();
    private final Transform6 piscesTx = new Transform6();
    private float compositeAlpha = 1.0f;
    private float px;
    private float py;
    private float pw;
    private float ph;

    SWPaint(SWContext sWContext, PiscesRenderer piscesRenderer) {
        this.context = sWContext;
        this.pr = piscesRenderer;
    }

    final float getCompositeAlpha() {
        return this.compositeAlpha;
    }

    final void setCompositeAlpha(float f2) {
        this.compositeAlpha = f2;
    }

    final void setColor(Color color, float f2) {
        if (PrismSettings.debug) {
            System.out.println("PR.setColor: " + String.valueOf(color));
        }
        this.pr.setColor((int)(color.getRed() * 255.0f), (int)(255.0f * color.getGreen()), (int)(255.0f * color.getBlue()), (int)(255.0f * color.getAlpha() * f2));
    }

    final void setPaintFromShape(Paint paint, BaseTransform baseTransform, Shape shape, RectBounds rectBounds, float f2, float f3, float f4, float f5) {
        this.computePaintBounds(paint, shape, rectBounds, f2, f3, f4, f5);
        this.setPaintBeforeDraw(paint, baseTransform, this.px, this.py, this.pw, this.ph);
    }

    private void computePaintBounds(Paint object, Shape shape, RectBounds rectBounds, float f2, float f3, float f4, float f5) {
        if (((Paint)object).isProportional()) {
            if (rectBounds != null) {
                this.px = ((BaseBounds)rectBounds).getMinX();
                this.py = ((BaseBounds)rectBounds).getMinY();
                this.pw = ((BaseBounds)rectBounds).getWidth();
                this.ph = ((BaseBounds)rectBounds).getHeight();
                return;
            }
            if (shape != null) {
                object = shape.getBounds();
                this.px = ((BaseBounds)object).getMinX();
                this.py = ((BaseBounds)object).getMinY();
                this.pw = ((BaseBounds)object).getWidth();
                this.ph = ((BaseBounds)object).getHeight();
                return;
            }
            this.px = f2;
            this.py = f3;
            this.pw = f4;
            this.ph = f5;
            return;
        }
        SWPaint sWPaint = this;
        SWPaint sWPaint2 = this;
        sWPaint2.ph = 0.0f;
        sWPaint2.pw = 0.0f;
        sWPaint.py = 0.0f;
        sWPaint.px = 0.0f;
    }

    final void setPaintBeforeDraw(Paint object, BaseTransform baseTransform, float f2, float f3, float f4, float f5) {
        switch (((Paint)object).getType()) {
            case COLOR: {
                this.setColor((Color)object, this.compositeAlpha);
                return;
            }
            case LINEAR_GRADIENT: {
                object = (LinearGradient)object;
                if (PrismSettings.debug) {
                    System.out.println("PR.setLinearGradient: " + ((LinearGradient)object).getX1() + ", " + ((LinearGradient)object).getY1() + ", " + ((LinearGradient)object).getX2() + ", " + ((LinearGradient)object).getY2());
                }
                this.paintTx.setTransform(baseTransform);
                SWUtils.convertToPiscesTransform(this.paintTx, this.piscesTx);
                float f6 = ((LinearGradient)object).getX1();
                float f7 = ((LinearGradient)object).getY1();
                float f8 = ((LinearGradient)object).getX2();
                float f9 = ((LinearGradient)object).getY2();
                if (((Paint)object).isProportional()) {
                    f6 = f2 + f4 * f6;
                    f7 = f3 + f5 * f7;
                    f8 = f2 + f4 * f8;
                    f9 = f3 + f5 * f9;
                }
                this.pr.setLinearGradient((int)(65536.0f * f6), (int)(65536.0f * f7), (int)(65536.0f * f8), (int)(65536.0f * f9), SWPaint.getFractions((Gradient)object), SWPaint.getARGB((Gradient)object, this.compositeAlpha), SWPaint.getPiscesGradientCycleMethod(((Gradient)object).getSpreadMethod()), this.piscesTx);
                return;
            }
            case RADIAL_GRADIENT: {
                float f10;
                object = (RadialGradient)object;
                if (PrismSettings.debug) {
                    System.out.println("PR.setRadialGradient: " + ((RadialGradient)object).getCenterX() + ", " + ((RadialGradient)object).getCenterY() + ", " + ((RadialGradient)object).getFocusAngle() + ", " + ((RadialGradient)object).getFocusDistance() + ", " + ((RadialGradient)object).getRadius());
                }
                this.paintTx.setTransform(baseTransform);
                float f11 = ((RadialGradient)object).getCenterX();
                float f12 = ((RadialGradient)object).getCenterY();
                float f13 = ((RadialGradient)object).getRadius();
                if (((Paint)object).isProportional()) {
                    f10 = Math.min(f4, f5);
                    float f14 = f3 + f5 * 0.5f;
                    f11 = (f2 += f4 * 0.5f) + (f11 - 0.5f) * f10;
                    f12 = f14 + (f12 - 0.5f) * f10;
                    f13 *= f10;
                    if (f4 != f5 && (double)f4 != 0.0 && (double)f5 != 0.0) {
                        this.paintTx.deriveWithTranslation(f2, f14);
                        this.paintTx.deriveWithConcatenation(f4 / f10, 0.0, 0.0, f5 / f10, 0.0, 0.0);
                        this.paintTx.deriveWithTranslation(-f2, -f14);
                    }
                }
                SWUtils.convertToPiscesTransform(this.paintTx, this.piscesTx);
                f10 = (float)((double)f11 + (double)(((RadialGradient)object).getFocusDistance() * f13) * Math.cos(Math.toRadians(((RadialGradient)object).getFocusAngle())));
                f2 = (float)((double)f12 + (double)(((RadialGradient)object).getFocusDistance() * f13) * Math.sin(Math.toRadians(((RadialGradient)object).getFocusAngle())));
                this.pr.setRadialGradient((int)(65536.0f * f11), (int)(65536.0f * f12), (int)(65536.0f * f10), (int)(65536.0f * f2), (int)(65536.0f * f13), SWPaint.getFractions((Gradient)object), SWPaint.getARGB((Gradient)object, this.compositeAlpha), SWPaint.getPiscesGradientCycleMethod(((Gradient)object).getSpreadMethod()), this.piscesTx);
                return;
            }
            case IMAGE_PATTERN: {
                ImagePattern imagePattern = (ImagePattern)object;
                if (imagePattern.getImage().getPixelFormat() == PixelFormat.BYTE_ALPHA) {
                    throw new UnsupportedOperationException("Alpha image is not supported as an image pattern.");
                }
                this.computeImagePatternTransform(imagePattern, baseTransform, f2, f3, f4, f5);
                object = this.context.validateImagePaintTexture(imagePattern.getImage().getWidth(), imagePattern.getImage().getHeight());
                ((SWTexture)object).update(imagePattern.getImage());
                if (this.compositeAlpha < 1.0f) {
                    ((SWArgbPreTexture)object).applyCompositeAlpha(this.compositeAlpha);
                }
                this.pr.setTexture(1, ((SWArgbPreTexture)object).getDataNoClone(), ((SWTexture)object).getContentWidth(), ((SWTexture)object).getContentHeight(), ((SWTexture)object).getPhysicalWidth(), this.piscesTx, ((SWTexture)object).getWrapMode() == Texture$WrapMode.REPEAT, ((SWTexture)object).getLinearFiltering(), ((SWArgbPreTexture)object).hasAlpha());
                return;
            }
        }
        throw new IllegalArgumentException("Unknown paint type: " + String.valueOf((Object)((Paint)object).getType()));
    }

    private static int[] getARGB(Gradient gradient, float f2) {
        int n2 = gradient.getNumStops();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = gradient.getStops().get(i2);
            object = ((Stop)object).getColor();
            float f3 = 255.0f * ((Color)object).getAlpha() * f2;
            nArray[i2] = (((int)f3 & 0xFF) << 24) + (((int)(f3 * ((Color)object).getRed()) & 0xFF) << 16) + (((int)(f3 * ((Color)object).getGreen()) & 0xFF) << 8) + ((int)(f3 * ((Color)object).getBlue()) & 0xFF);
        }
        return nArray;
    }

    private static int[] getFractions(Gradient gradient) {
        int n2 = gradient.getNumStops();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Stop stop = gradient.getStops().get(i2);
            nArray[i2] = (int)(65536.0f * stop.getOffset());
        }
        return nArray;
    }

    private static int getPiscesGradientCycleMethod(int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    final Transform6 computeDrawTexturePaintTransform(BaseTransform baseTransform, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.paintTx.setTransform(baseTransform);
        float f10 = this.computeScale(f2, f4, f6, f8);
        float f11 = this.computeScale(f3, f5, f7, f9);
        if (f10 == 1.0f && f11 == 1.0f) {
            this.paintTx.deriveWithTranslation(-Math.min(f6, f8) + Math.min(f2, f4), -Math.min(f7, f9) + Math.min(f3, f5));
        } else {
            this.paintTx.deriveWithTranslation(Math.min(f2, f4), Math.min(f3, f5));
            this.paintTx.deriveWithTranslation(f10 >= 0.0f ? 0.0 : (double)Math.abs(f4 - f2), f11 >= 0.0f ? 0.0 : (double)Math.abs(f5 - f3));
            this.paintTx.deriveWithConcatenation(f10, 0.0, 0.0, f11, 0.0, 0.0);
            this.paintTx.deriveWithTranslation(-Math.min(f6, f8), -Math.min(f7, f9));
        }
        SWUtils.convertToPiscesTransform(this.paintTx, this.piscesTx);
        return this.piscesTx;
    }

    private float computeScale(float f2, float f3, float f4, float f5) {
        float f6;
        f2 = f3 - f2;
        f2 /= f5 - f4;
        if (Math.abs(f6) > 32767.0f) {
            f2 = Math.signum(f2) * 32767.0f;
        }
        return f2;
    }

    final Transform6 computeSetTexturePaintTransform(Paint paint, BaseTransform baseTransform, RectBounds rectBounds, float f2, float f3, float f4, float f5) {
        this.computePaintBounds(paint, null, rectBounds, f2, f3, f4, f5);
        paint = (ImagePattern)paint;
        this.computeImagePatternTransform((ImagePattern)paint, baseTransform, this.px, this.py, this.pw, this.ph);
        return this.piscesTx;
    }

    private void computeImagePatternTransform(ImagePattern imagePattern, BaseTransform baseTransform, float f2, float f3, float f4, float f5) {
        Image image = imagePattern.getImage();
        if (PrismSettings.debug) {
            System.out.println("PR.setTexturePaint: " + String.valueOf(image));
            System.out.println("imagePattern: x: " + imagePattern.getX() + ", y: " + imagePattern.getY() + ", w: " + imagePattern.getWidth() + ", h: " + imagePattern.getHeight() + ", proportional: " + imagePattern.isProportional());
        }
        this.paintTx.setTransform(baseTransform);
        this.paintTx.deriveWithConcatenation(imagePattern.getPatternTransformNoClone());
        if (imagePattern.isProportional()) {
            this.paintTx.deriveWithConcatenation(f4 / (float)image.getWidth() * imagePattern.getWidth(), 0.0, 0.0, f5 / (float)image.getHeight() * imagePattern.getHeight(), f2 + f4 * imagePattern.getX(), f3 + f5 * imagePattern.getY());
        } else {
            this.paintTx.deriveWithConcatenation(imagePattern.getWidth() / (float)image.getWidth(), 0.0, 0.0, imagePattern.getHeight() / (float)image.getHeight(), f2 + imagePattern.getX(), f3 + imagePattern.getY());
        }
        SWUtils.convertToPiscesTransform(this.paintTx, this.piscesTx);
    }
}

