/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.glass.ui.Screen;
import com.sun.prism.Image;
import com.sun.prism.MediaFrame;
import com.sun.prism.Mesh;
import com.sun.prism.MeshView;
import com.sun.prism.PhongMaterial;
import com.sun.prism.PixelFormat;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.Texture$Usage;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.BaseResourceFactory;
import com.sun.prism.impl.BaseResourcePool;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;
import com.sun.prism.impl.shape.BasicRoundRectRep;
import com.sun.prism.impl.shape.BasicShapeRep;
import com.sun.prism.shape.ShapeRep;
import com.sun.prism.sw.SWArgbPreTexture;
import com.sun.prism.sw.SWContext;
import com.sun.prism.sw.SWPresentable;
import com.sun.prism.sw.SWRTTexture;
import com.sun.prism.sw.SWTexture;
import com.sun.prism.sw.SWTexturePool;
import java.util.Map;
import java.util.WeakHashMap;

final class SWResourceFactory
extends BaseResourceFactory {
    private static final Map<Image, Texture> clampTexCache = new WeakHashMap<Image, Texture>();
    private static final Map<Image, Texture> repeatTexCache = new WeakHashMap<Image, Texture>();
    private static final Map<Image, Texture> mipmapTexCache = new WeakHashMap<Image, Texture>();
    private static final ShapeRep theRep = new BasicShapeRep();
    private static final ShapeRep rectRep = new BasicRoundRectRep();
    private Screen screen;
    private final SWContext context;

    public SWResourceFactory(Screen screen) {
        super(clampTexCache, repeatTexCache, mipmapTexCache);
        this.screen = screen;
        this.context = new SWContext(this);
    }

    @Override
    public final TextureResourcePool getTextureResourcePool() {
        return SWTexturePool.instance;
    }

    public final Screen getScreen() {
        return this.screen;
    }

    final SWContext getContext() {
        return this.context;
    }

    @Override
    public final void dispose() {
        this.context.dispose();
    }

    @Override
    public final ShapeRep createArcRep() {
        return theRep;
    }

    @Override
    public final ShapeRep createEllipseRep() {
        return theRep;
    }

    @Override
    public final ShapeRep createRoundRectRep() {
        return rectRep;
    }

    @Override
    public final ShapeRep createPathRep() {
        return theRep;
    }

    @Override
    public final Presentable createPresentable(PresentableState presentableState) {
        if (PrismSettings.debug) {
            System.out.println("+ SWRF.createPresentable()");
        }
        return new SWPresentable(presentableState, this);
    }

    @Override
    public final int getRTTWidth(int n2, Texture$WrapMode texture$WrapMode) {
        return n2;
    }

    @Override
    public final int getRTTHeight(int n2, Texture$WrapMode texture$WrapMode) {
        return n2;
    }

    @Override
    public final boolean isCompatibleTexture(Texture texture) {
        return texture instanceof SWTexture;
    }

    @Override
    public final RTTexture createRTTexture(int n2, int n3, Texture$WrapMode texture$WrapMode, boolean bl2) {
        return this.createRTTexture(n2, n3, texture$WrapMode);
    }

    @Override
    public final RTTexture createRTTexture(int n2, int n3, Texture$WrapMode object) {
        object = SWTexturePool.instance;
        long l2 = ((SWTexturePool)object).estimateRTTextureSize(n2, n3, false);
        if (!((BaseResourcePool)object).prepareForAllocation(l2)) {
            return null;
        }
        return new SWRTTexture(this, n2, n3);
    }

    @Override
    public final int getMaximumTextureSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean isFormatSupported(PixelFormat pixelFormat) {
        switch (pixelFormat) {
            case BYTE_RGB: 
            case BYTE_GRAY: 
            case INT_ARGB_PRE: 
            case BYTE_BGRA_PRE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected final boolean canClampToZero() {
        return false;
    }

    @Override
    public final Texture createTexture(MediaFrame mediaFrame) {
        return new SWArgbPreTexture(this, Texture$WrapMode.CLAMP_TO_EDGE, mediaFrame.getWidth(), mediaFrame.getHeight());
    }

    @Override
    public final Texture createTexture(PixelFormat pixelFormat, Texture$Usage object, Texture$WrapMode texture$WrapMode, int n2, int n3) {
        object = SWTexturePool.instance;
        long l2 = ((SWTexturePool)object).estimateTextureSize(n2, n3, pixelFormat);
        if (!((BaseResourcePool)object).prepareForAllocation(l2)) {
            return null;
        }
        return SWTexture.create(this, pixelFormat, texture$WrapMode, n2, n3);
    }

    @Override
    public final Texture createTexture(PixelFormat pixelFormat, Texture$Usage texture$Usage, Texture$WrapMode texture$WrapMode, int n2, int n3, boolean bl2) {
        return this.createTexture(pixelFormat, texture$Usage, texture$WrapMode, n2, n3);
    }

    @Override
    public final PhongMaterial createPhongMaterial() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final MeshView createMeshView(Mesh mesh) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final Mesh createMesh() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

