/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.javafx.tk.Toolkit;
import com.sun.scenario.animation.AnimationPulse$AnimationPulseHolder;
import com.sun.scenario.animation.AnimationPulse$PulseData;
import com.sun.scenario.animation.AnimationPulse$PulseData$Accessor;
import com.sun.scenario.animation.AnimationPulseMBean;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class AnimationPulse
implements AnimationPulseMBean {
    private final Queue<AnimationPulse$PulseData> pulseDataQueue = new ConcurrentLinkedQueue<AnimationPulse$PulseData>();
    private AnimationPulse$PulseData pulseData = null;
    private volatile boolean isEnabled = false;
    private final AtomicLong pulseCounter = new AtomicLong();
    private final AtomicLong startMax = new AtomicLong();
    private final AtomicLong startSum = new AtomicLong();
    private final AtomicLong startAv = new AtomicLong();
    private final AtomicLong endMax = new AtomicLong();
    private final AtomicLong endSum = new AtomicLong();
    private final AtomicLong endAv = new AtomicLong();
    private final AtomicLong animationDurationMax = new AtomicLong();
    private final AtomicLong animationDurationSum = new AtomicLong();
    private final AtomicLong animationDurationAv = new AtomicLong();
    private final AtomicLong paintingDurationMax = new AtomicLong();
    private final AtomicLong paintingDurationSum = new AtomicLong();
    private final AtomicLong paintingDurationAv = new AtomicLong();
    private final AtomicLong pulseDurationMax = new AtomicLong();
    private final AtomicLong pulseDurationSum = new AtomicLong();
    private final AtomicLong pulseDurationAv = new AtomicLong();
    private final AtomicLong[] maxAndAv = new AtomicLong[]{this.startMax, this.startSum, this.startAv, this.endMax, this.endSum, this.endAv, this.animationDurationMax, this.animationDurationSum, this.animationDurationAv, this.paintingDurationMax, this.paintingDurationSum, this.paintingDurationAv, this.pulseDurationMax, this.pulseDurationSum, this.pulseDurationAv};
    private final AnimationPulse$PulseData$Accessor[] maxAndAvAccessors = new AnimationPulse$PulseData$Accessor[]{AnimationPulse$PulseData.PulseStartAccessor, AnimationPulse$PulseData.PulseEndAccessor, AnimationPulse$PulseData.AnimationDurationAccessor, AnimationPulse$PulseData.PaintingDurationAccessor, AnimationPulse$PulseData.PulseDurationAccessor};
    private final AtomicLong skippedPulses = new AtomicLong();
    private int skipPulses = 100;

    public static AnimationPulse getDefaultBean() {
        return AnimationPulse$AnimationPulseHolder.holder;
    }

    @Override
    public boolean getEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean bl2) {
        if (bl2 == this.isEnabled) {
            return;
        }
        this.isEnabled = bl2;
    }

    @Override
    public long getPULSE_DURATION() {
        return Toolkit.getToolkit().getPrimaryTimer().getPulseDuration(1000);
    }

    @Override
    public long getSkippedPulses() {
        return this.skippedPulses.get();
    }

    @Override
    public long getSkippedPulsesIn1Sec() {
        long l2 = 0L;
        for (AnimationPulse$PulseData animationPulse$PulseData : this.pulseDataQueue) {
            if (animationPulse$PulseData.getPulseStartFromNow(TimeUnit.SECONDS) != 0L) continue;
            l2 += animationPulse$PulseData.getSkippedPulses();
        }
        return l2;
    }

    public void recordStart(long l2) {
        if (!this.getEnabled()) {
            return;
        }
        this.pulseData = new AnimationPulse$PulseData(TimeUnit.MILLISECONDS.toNanos(l2));
    }

    private void purgeOldPulseData() {
        Iterator iterator = this.pulseDataQueue.iterator();
        while (iterator.hasNext() && ((AnimationPulse$PulseData)iterator.next()).getPulseStartFromNow(TimeUnit.SECONDS) > 1L) {
            iterator.remove();
        }
    }

    private void updateMaxAndAv() {
        long l2 = this.pulseCounter.incrementAndGet();
        for (int i2 = 0; i2 < this.maxAndAvAccessors.length; ++i2) {
            int n2 = i2 * 3;
            long l3 = this.maxAndAvAccessors[i2].get(this.pulseData, TimeUnit.MILLISECONDS);
            this.maxAndAv[n2].set(Math.max(this.maxAndAv[n2].get(), l3));
            this.maxAndAv[n2 + 1].addAndGet(l3);
            this.maxAndAv[n2 + 2].set(this.maxAndAv[n2 + 1].get() / l2);
        }
    }

    public void recordEnd() {
        if (!this.getEnabled()) {
            return;
        }
        if (this.skipPulses > 0) {
            --this.skipPulses;
            this.pulseData = null;
            return;
        }
        this.pulseData.recordEnd();
        this.purgeOldPulseData();
        this.updateMaxAndAv();
        this.skippedPulses.addAndGet(this.pulseData.getSkippedPulses());
        this.pulseDataQueue.add(this.pulseData);
        this.pulseData = null;
    }

    private long getAv(AnimationPulse$PulseData$Accessor animationPulse$PulseData$Accessor, long l2, TimeUnit timeUnit) {
        if (!this.getEnabled()) {
            return 0L;
        }
        long l3 = 0L;
        long l4 = 0L;
        for (AnimationPulse$PulseData animationPulse$PulseData : this.pulseDataQueue) {
            if (animationPulse$PulseData.getPulseStartFromNow(timeUnit) > l2) continue;
            l3 += animationPulse$PulseData$Accessor.get(animationPulse$PulseData, timeUnit);
            ++l4;
        }
        if (l4 == 0L) {
            return 0L;
        }
        return l3 / l4;
    }

    private long getMax(AnimationPulse$PulseData$Accessor animationPulse$PulseData$Accessor, long l2, TimeUnit timeUnit) {
        if (!this.getEnabled()) {
            return 0L;
        }
        long l3 = 0L;
        for (AnimationPulse$PulseData animationPulse$PulseData : this.pulseDataQueue) {
            if (animationPulse$PulseData.getPulseStartFromNow(timeUnit) > l2) continue;
            l3 = Math.max(animationPulse$PulseData$Accessor.get(animationPulse$PulseData, timeUnit), l3);
        }
        return l3;
    }

    @Override
    public long getStartMax() {
        return this.startMax.get();
    }

    @Override
    public long getStartAv() {
        return this.startAv.get();
    }

    @Override
    public long getStartMaxIn1Sec() {
        return this.getMax(AnimationPulse$PulseData.PulseStartAccessor, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getStartAvIn100Millis() {
        return this.getAv(AnimationPulse$PulseData.PulseStartAccessor, 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getEndMax() {
        return this.endMax.get();
    }

    @Override
    public long getEndMaxIn1Sec() {
        return this.getMax(AnimationPulse$PulseData.PulseEndAccessor, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getEndAv() {
        return this.endAv.get();
    }

    @Override
    public long getEndAvIn100Millis() {
        return this.getAv(AnimationPulse$PulseData.PulseEndAccessor, 100L, TimeUnit.MILLISECONDS);
    }

    public void recordAnimationEnd() {
        if (this.getEnabled() && this.pulseData != null) {
            this.pulseData.recordAnimationEnd();
        }
    }

    @Override
    public long getAnimationDurationMax() {
        return this.animationDurationMax.get();
    }

    @Override
    public long getAnimationMaxIn1Sec() {
        return this.getMax(AnimationPulse$PulseData.AnimationDurationAccessor, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getAnimationDurationAv() {
        return this.animationDurationAv.get();
    }

    @Override
    public long getAnimationDurationAvIn100Millis() {
        return this.getAv(AnimationPulse$PulseData.AnimationDurationAccessor, 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getPaintingDurationMax() {
        return this.paintingDurationMax.get();
    }

    @Override
    public long getPaintingDurationMaxIn1Sec() {
        return this.getMax(AnimationPulse$PulseData.PaintingDurationAccessor, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getPaintingDurationAv() {
        return this.paintingDurationAv.get();
    }

    @Override
    public long getPaintingDurationAvIn100Millis() {
        return this.getAv(AnimationPulse$PulseData.PaintingDurationAccessor, 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getScenePaintingDurationMaxIn1Sec() {
        return this.getMax(AnimationPulse$PulseData.ScenePaintingDurationAccessor, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getPulseDurationMax() {
        return this.pulseDurationMax.get();
    }

    @Override
    public long getPulseDurationMaxIn1Sec() {
        return this.getMax(AnimationPulse$PulseData.PulseDurationAccessor, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getPulseDurationAv() {
        return this.pulseDurationAv.get();
    }

    @Override
    public long getPulseDurationAvIn100Millis() {
        return this.getAv(AnimationPulse$PulseData.PulseDurationAccessor, 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getPaintingPreparationDurationMaxIn1Sec() {
        return this.getMax(AnimationPulse$PulseData.PaintingPreparationDuration, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getPaintingFinalizationDurationMaxIn1Sec() {
        return this.getMax(AnimationPulse$PulseData.PaintingFinalizationDuration, 1000L, TimeUnit.MILLISECONDS);
    }
}

