/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.javafx.util.Utils;
import com.sun.scenario.animation.shared.AnimationAccessor;
import com.sun.scenario.animation.shared.ClipEnvelope;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.util.Duration;

public class SingleLoopClipEnvelope
extends ClipEnvelope {
    private int cycleCount;

    protected SingleLoopClipEnvelope(Animation animation) {
        super(animation);
        if (animation != null) {
            this.cycleCount = animation.getCycleCount();
        }
    }

    @Override
    public void setAutoReverse(boolean bl2) {
    }

    @Override
    public ClipEnvelope setCycleDuration(Duration duration) {
        if (this.cycleCount != 1 && !duration.isIndefinite()) {
            return SingleLoopClipEnvelope.create(this.animation);
        }
        this.updateCycleTicks(duration);
        return this;
    }

    @Override
    public ClipEnvelope setCycleCount(int n2) {
        if (n2 != 1 && this.cycleTicks != Long.MAX_VALUE) {
            return SingleLoopClipEnvelope.create(this.animation);
        }
        this.cycleCount = n2;
        return this;
    }

    @Override
    public void setRate(double d2) {
        Animation$Status animation$Status = this.animation.getStatus();
        if (animation$Status != Animation$Status.STOPPED) {
            SingleLoopClipEnvelope singleLoopClipEnvelope = this;
            singleLoopClipEnvelope.setInternalCurrentRate(Math.abs(singleLoopClipEnvelope.currentRate - this.rate) < 1.0E-12 ? d2 : -d2);
            this.deltaTicks = this.ticks - this.ticksRateChange(d2);
            this.abortCurrentPulse();
        }
        this.rate = d2;
    }

    @Override
    protected double calculateCurrentRate() {
        return this.rate;
    }

    @Override
    public boolean wasSynched() {
        return super.wasSynched() && this.cycleCount != 0;
    }

    @Override
    public void timePulse(long l2) {
        if (this.cycleTicks == 0L) {
            return;
        }
        this.aborted = false;
        this.inTimePulse = true;
        try {
            boolean bl2;
            long l3 = Math.round((double)l2 * this.currentRate);
            this.ticks = Utils.clamp(0L, this.deltaTicks + l3, this.cycleTicks);
            AnimationAccessor.getDefault().playTo(this.animation, this.ticks, this.cycleTicks);
            boolean bl3 = this.currentRate > 0.0 ? this.ticks == this.cycleTicks : (bl2 = this.ticks == 0L);
            if (bl3 && !this.aborted) {
                AnimationAccessor.getDefault().finished(this.animation);
            }
            return;
        }
        finally {
            this.inTimePulse = false;
        }
    }

    @Override
    public void jumpTo(long l2) {
        if (this.cycleTicks == 0L) {
            return;
        }
        long l3 = Utils.clamp(0L, l2, this.cycleTicks);
        this.deltaTicks += l3 - this.ticks;
        this.ticks = l3;
        AnimationAccessor.getDefault().jumpTo(this.animation, l3, this.cycleTicks, false);
        this.abortCurrentPulse();
    }
}

