/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.Effect$AccelType;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.Offset;
import com.sun.scenario.effect.impl.Renderer;
import java.util.HashMap;
import java.util.Map;

public class Identity
extends Effect {
    private Filterable src;
    private Point2D loc = new Point2D();
    private final Map<FilterContext, ImageData> datacache = new HashMap<FilterContext, ImageData>();

    public Identity(Filterable filterable) {
        this.src = filterable;
    }

    public final Filterable getSource() {
        return this.src;
    }

    public void setSource(Filterable filterable) {
        this.src = filterable;
        this.clearCache();
    }

    public final Point2D getLocation() {
        return this.loc;
    }

    public void setLocation(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException("Location must be non-null");
        }
        this.loc.setLocation(point2D);
    }

    @Override
    public BaseBounds getBounds(BaseTransform baseTransform, Effect effect) {
        if (this.src == null) {
            return new RectBounds();
        }
        float f2 = (float)this.src.getPhysicalWidth() / this.src.getPixelScale();
        float f3 = (float)this.src.getPhysicalHeight() / this.src.getPixelScale();
        BaseBounds baseBounds = new RectBounds(this.loc.x, this.loc.y, this.loc.x + f2, this.loc.y + f3);
        if (baseTransform != null && !baseTransform.isIdentity()) {
            baseBounds = Identity.transformBounds(baseTransform, baseBounds);
        }
        return baseBounds;
    }

    @Override
    public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Rectangle object, Object object2, Effect effect) {
        object = this.datacache.get(filterContext);
        if (object != null && !((ImageData)object).addref()) {
            ((ImageData)object).setReusable(false);
            this.datacache.remove(filterContext);
            ((ImageData)object).unref();
            object = null;
        }
        if (object == null) {
            object = Renderer.getRenderer(filterContext);
            object2 = this.src;
            if (object2 == null) {
                object2 = Identity.getCompatibleImage(filterContext, 1, 1);
                object = new ImageData(filterContext, (Filterable)object2, new Rectangle(1, 1));
            } else {
                object = ((Renderer)object).createImageData(filterContext, (Filterable)object2);
            }
            if (object == null) {
                return new ImageData(filterContext, null, null);
            }
            ((ImageData)object).setReusable(true);
            this.datacache.put(filterContext, (ImageData)object);
        }
        baseTransform = Offset.getOffsetTransform(baseTransform, this.loc.x, this.loc.y);
        object = ((ImageData)object).transform(baseTransform);
        return object;
    }

    @Override
    public Effect$AccelType getAccelType(FilterContext filterContext) {
        return Effect$AccelType.INTRINSIC;
    }

    private void clearCache() {
        this.datacache.clear();
    }

    @Override
    public boolean reducesOpaquePixels() {
        return true;
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect object, DirtyRegionPool dirtyRegionPool) {
        object = dirtyRegionPool.checkOut();
        ((DirtyRegionContainer)object).reset();
        return object;
    }
}

