/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.state.PerspectiveTransformState;
import com.sun.scenario.effect.impl.state.RenderState;

public class PerspectiveTransform
extends CoreEffect<RenderState> {
    private float[][] tx = new float[3][3];
    private float ulx;
    private float uly;
    private float urx;
    private float ury;
    private float lrx;
    private float lry;
    private float llx;
    private float lly;
    private float[] devcoords = new float[8];
    private final PerspectiveTransformState state = new PerspectiveTransformState();

    public PerspectiveTransform() {
        this(DefaultInput);
    }

    public PerspectiveTransform(Effect effect) {
        super(effect);
        this.setQuadMapping(0.0f, 0.0f, 100.0f, 0.0f, 100.0f, 100.0f, 0.0f, 100.0f);
        this.updatePeerKey("PerspectiveTransform");
    }

    @Override
    Object getState() {
        return this.state;
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect effect) {
        this.setInput(0, effect);
    }

    private void setUnitQuadMapping(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f2 - f4 + f6 - f8;
        float f11 = f3 - f5 + f7 - f9;
        this.tx[2][2] = 1.0f;
        if (f10 == 0.0f && f11 == 0.0f) {
            this.tx[0][0] = f4 - f2;
            this.tx[0][1] = f6 - f4;
            this.tx[0][2] = f2;
            this.tx[1][0] = f5 - f3;
            this.tx[1][1] = f7 - f5;
            this.tx[1][2] = f3;
            this.tx[2][0] = 0.0f;
            this.tx[2][1] = 0.0f;
        } else {
            float f12 = f4 - f6;
            float f13 = f5 - f7;
            f6 = f8 - f6;
            f7 = f9 - f7;
            float f14 = 1.0f / (f12 * f7 - f6 * f13);
            this.tx[2][0] = (f10 * f7 - f6 * f11) * f14;
            this.tx[2][1] = (f12 * f11 - f10 * f13) * f14;
            this.tx[0][0] = f4 - f2 + this.tx[2][0] * f4;
            this.tx[0][1] = f8 - f2 + this.tx[2][1] * f8;
            this.tx[0][2] = f2;
            this.tx[1][0] = f5 - f3 + this.tx[2][0] * f5;
            this.tx[1][1] = f9 - f3 + this.tx[2][1] * f9;
            this.tx[1][2] = f3;
        }
        this.state.updateTx(this.tx);
    }

    public final void setQuadMapping(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.ulx = f2;
        this.uly = f3;
        this.urx = f4;
        this.ury = f5;
        this.lrx = f6;
        this.lry = f7;
        this.llx = f8;
        this.lly = f9;
    }

    @Override
    public RectBounds getBounds(BaseTransform baseTransform, Effect effect) {
        float f2;
        float f3;
        this.setupDevCoords(baseTransform);
        float f4 = f3 = this.devcoords[0];
        float f5 = f2 = this.devcoords[1];
        for (int i2 = 2; i2 < this.devcoords.length; i2 += 2) {
            if (f4 > this.devcoords[i2]) {
                f4 = this.devcoords[i2];
            } else if (f3 < this.devcoords[i2]) {
                f3 = this.devcoords[i2];
            }
            if (f5 > this.devcoords[i2 + 1]) {
                f5 = this.devcoords[i2 + 1];
                continue;
            }
            if (!(f2 < this.devcoords[i2 + 1])) continue;
            f2 = this.devcoords[i2 + 1];
        }
        return new RectBounds(f4, f5, f3, f2);
    }

    private void setupDevCoords(BaseTransform baseTransform) {
        this.devcoords[0] = this.ulx;
        this.devcoords[1] = this.uly;
        this.devcoords[2] = this.urx;
        this.devcoords[3] = this.ury;
        this.devcoords[4] = this.lrx;
        this.devcoords[5] = this.lry;
        this.devcoords[6] = this.llx;
        this.devcoords[7] = this.lly;
        baseTransform.transform(this.devcoords, 0, this.devcoords, 0, 4);
    }

    @Override
    public ImageData filter(FilterContext object, BaseTransform baseTransform, Rectangle rectangle, Object object2, Effect object3) {
        this.setupTransforms(baseTransform);
        object2 = this.getRenderState((FilterContext)object, baseTransform, rectangle, object2, (Effect)object3);
        Effect effect = this.getDefaultedInput(0, (Effect)object3);
        Rectangle rectangle2 = object2.getInputClip(0, rectangle);
        object3 = effect.filter((FilterContext)object, BaseTransform.IDENTITY_TRANSFORM, rectangle2, null, (Effect)object3);
        if (!((ImageData)object3).validate((FilterContext)object)) {
            ((ImageData)object3).unref();
            return new ImageData((FilterContext)object, null, ((ImageData)object3).getUntransformedBounds());
        }
        object = this.filterImageDatas((FilterContext)object, baseTransform, rectangle, (RenderState)object2, new ImageData[]{object3});
        ((ImageData)object3).unref();
        return object;
    }

    @Override
    public Rectangle getResultBounds(BaseTransform object, Rectangle rectangle, ImageData ... imageDataArray) {
        object = new Rectangle(this.getBounds((BaseTransform)object, null));
        ((Rectangle)object).intersectWith(rectangle);
        return object;
    }

    @Override
    public Point2D transform(Point2D point2D, Effect object) {
        this.setupTransforms(BaseTransform.IDENTITY_TRANSFORM);
        Effect effect = this.getDefaultedInput(0, (Effect)object);
        point2D = effect.transform(point2D, (Effect)object);
        object = effect.getBounds(BaseTransform.IDENTITY_TRANSFORM, (Effect)object);
        float f2 = (point2D.x - ((BaseBounds)object).getMinX()) / ((BaseBounds)object).getWidth();
        float f3 = (point2D.y - ((BaseBounds)object).getMinY()) / ((BaseBounds)object).getHeight();
        float f4 = this.tx[0][0] * f2 + this.tx[0][1] * f3 + this.tx[0][2];
        float f5 = this.tx[1][0] * f2 + this.tx[1][1] * f3 + this.tx[1][2];
        f3 = this.tx[2][0] * f2 + this.tx[2][1] * f3 + this.tx[2][2];
        Point2D point2D2 = new Point2D(f4 / f3, f5 / f3);
        return point2D2;
    }

    @Override
    public Point2D untransform(Point2D point2D, Effect effect) {
        this.setupTransforms(BaseTransform.IDENTITY_TRANSFORM);
        Object object = this.getDefaultedInput(0, effect);
        float f2 = point2D.x;
        float f3 = point2D.y;
        float[][] fArray = this.state.getITX();
        float f4 = fArray[0][0] * f2 + fArray[0][1] * f3 + fArray[0][2];
        float f5 = fArray[1][0] * f2 + fArray[1][1] * f3 + fArray[1][2];
        f3 = fArray[2][0] * f2 + fArray[2][1] * f3 + fArray[2][2];
        object = ((Effect)object).getBounds(BaseTransform.IDENTITY_TRANSFORM, effect);
        Point2D point2D2 = new Point2D(((BaseBounds)object).getMinX() + f4 / f3 * ((BaseBounds)object).getWidth(), ((BaseBounds)object).getMinY() + f5 / f3 * ((BaseBounds)object).getHeight());
        point2D2 = this.getDefaultedInput(0, effect).untransform(point2D2, effect);
        return point2D2;
    }

    private void setupTransforms(BaseTransform baseTransform) {
        this.setupDevCoords(baseTransform);
        PerspectiveTransform perspectiveTransform = this;
        perspectiveTransform.setUnitQuadMapping(perspectiveTransform.devcoords[0], this.devcoords[1], this.devcoords[2], this.devcoords[3], this.devcoords[4], this.devcoords[5], this.devcoords[6], this.devcoords[7]);
    }

    @Override
    public RenderState getRenderState(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, Object object, Effect effect) {
        return RenderState.UnclippedUserSpaceRenderState;
    }

    @Override
    public boolean reducesOpaquePixels() {
        return true;
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect effect, DirtyRegionPool object) {
        object = ((DirtyRegionPool)object).checkOut();
        ((DirtyRegionContainer)object).deriveWithNewRegion(this.getBounds(BaseTransform.IDENTITY_TRANSFORM, effect));
        return object;
    }
}

