/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.ps;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.GraphicsPipeline$ShaderModel;
import com.sun.prism.GraphicsPipeline$ShaderType;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.prism.Texture$Usage;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;
import com.sun.prism.ps.ShaderGraphics;
import com.sun.scenario.effect.Effect$AccelType;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.LockableResource;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.Renderer$RendererState;
import com.sun.scenario.effect.impl.hw.ShaderSource;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrImage;
import com.sun.scenario.effect.impl.prism.PrRenderer;
import com.sun.scenario.effect.impl.prism.PrTexture;
import com.sun.scenario.effect.impl.prism.ps.PPSDrawable;
import com.sun.scenario.effect.impl.prism.ps.PPSRenderer$1;
import com.sun.scenario.effect.impl.prism.ps.PPStoPSWDisplacementMapPeer;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.nio.FloatBuffer;
import java.util.Map;

public class PPSRenderer
extends PrRenderer {
    private ResourceFactory rf;
    private Screen screen;
    private final ShaderSource shaderSource;
    private Renderer$RendererState state;
    private boolean needsSWDispMap;
    private final ResourceFactoryListener listener = new PPSRenderer$1(this);

    private PPSRenderer(Screen object, ShaderSource shaderSource) {
        this.shaderSource = shaderSource;
        this.screen = object;
        object = this;
        synchronized (object) {
            this.state = Renderer$RendererState.NOTREADY;
            return;
        }
    }

    private boolean validate() {
        Object object = ((Renderer)this).getRendererState();
        switch (object) {
            case NOTREADY: {
                if (this.rf == null) {
                    this.rf = GraphicsPipeline.getPipeline().getResourceFactory(this.screen);
                    if (this.rf == null) {
                        return false;
                    }
                }
                if (this.rf.isDisposed()) {
                    this.dispose();
                    return false;
                }
                this.rf.addFactoryListener(this.listener);
                this.needsSWDispMap = !this.rf.isFormatSupported(PixelFormat.FLOAT_XYZW);
                object = this;
                synchronized (object) {
                    this.state = Renderer$RendererState.OK;
                }
                return true;
            }
            case OK: 
            case LOST: {
                return true;
            }
        }
        return false;
    }

    @Override
    public PrDrawable createDrawable(RTTexture rTTexture) {
        if (!this.validate()) {
            return null;
        }
        return PPSDrawable.create(rTTexture);
    }

    @Override
    public Effect$AccelType getAccelType() {
        return this.shaderSource.getAccelType();
    }

    @Override
    public synchronized Renderer$RendererState getRendererState() {
        return this.state;
    }

    @Override
    protected Renderer getBackupRenderer() {
        return this;
    }

    protected void dispose() {
        for (EffectPeer effectPeer : this.getPeers()) {
            effectPeer.dispose();
        }
        PPSRenderer pPSRenderer = this;
        synchronized (pPSRenderer) {
            this.state = Renderer$RendererState.DISPOSED;
        }
        this.rf.removeFactoryListener(this.listener);
        this.rf = null;
        this.screen = null;
    }

    protected final synchronized void markLost() {
        if (this.state == Renderer$RendererState.NOTREADY || this.state == Renderer$RendererState.OK) {
            this.state = Renderer$RendererState.LOST;
        }
    }

    @Override
    public int getCompatibleWidth(int n2) {
        if (!this.validate()) {
            return -1;
        }
        return PPSDrawable.getCompatibleWidth(this.rf, n2);
    }

    @Override
    public int getCompatibleHeight(int n2) {
        if (!this.validate()) {
            return -1;
        }
        return PPSDrawable.getCompatibleHeight(this.rf, n2);
    }

    @Override
    public final PPSDrawable createCompatibleImage(int n2, int n3) {
        if (!this.validate()) {
            return null;
        }
        return PPSDrawable.create(this.rf, n2, n3);
    }

    @Override
    public PPSDrawable getCompatibleImage(int n2, int n3) {
        if (!this.validate()) {
            return null;
        }
        PPSDrawable pPSDrawable = (PPSDrawable)super.getCompatibleImage(n2, n3);
        if (pPSDrawable == null) {
            this.markLost();
        }
        return pPSDrawable;
    }

    @Override
    public LockableResource createFloatTexture(int n2, int n3) {
        if (!this.validate()) {
            return null;
        }
        Texture texture = this.rf.createFloatTexture(n2, n3);
        return new PrTexture<Texture>(texture);
    }

    @Override
    public void updateFloatTexture(LockableResource lockableResource, FloatMap floatMap) {
        if (!this.validate()) {
            return;
        }
        FloatBuffer floatBuffer = floatMap.getBuffer();
        int n2 = floatMap.getWidth();
        int n3 = floatMap.getHeight();
        Image image = Image.fromFloatMapData(floatBuffer, n2, n3);
        lockableResource = ((PrTexture)lockableResource).getTextureObject();
        lockableResource.update(image);
    }

    public Shader createShader(String object, Map<String, Integer> map, Map<String, Integer> map2, boolean bl2) {
        if (!this.validate()) {
            return null;
        }
        if (PrismSettings.verbose) {
            System.out.println("PPSRenderer: scenario.effect - createShader: " + (String)object);
        }
        object = this.shaderSource.loadSource((String)object);
        int n2 = map.keySet().size() - 1;
        ShaderFactory shaderFactory = (ShaderFactory)this.rf;
        return shaderFactory.createShader((InputStream)object, map, map2, n2, bl2, false);
    }

    private EffectPeer createIntrinsicPeer(FilterContext object, String string) {
        try {
            GenericDeclaration genericDeclaration = Class.forName("com.sun.scenario.effect.impl.prism.Pr" + string + "Peer");
            genericDeclaration = genericDeclaration.getConstructor(FilterContext.class, Renderer.class, String.class);
            object = (EffectPeer)((Constructor)genericDeclaration).newInstance(object, this, string);
        }
        catch (Exception exception) {
            return null;
        }
        return object;
    }

    private EffectPeer createPlatformPeer(FilterContext object, String string, int n2) {
        Object object2 = string;
        if (n2 > 0) {
            object2 = (String)object2 + "_" + n2;
        }
        try {
            GenericDeclaration genericDeclaration = Class.forName("com.sun.scenario.effect.impl.prism.ps.PPS" + string + "Peer");
            genericDeclaration = genericDeclaration.getConstructor(FilterContext.class, Renderer.class, String.class);
            object = (EffectPeer)((Constructor)genericDeclaration).newInstance(object, this, object2);
        }
        catch (Exception exception) {
            System.err.println("Error: Prism peer not found for: " + string + " due to error: " + exception.getMessage());
            return null;
        }
        return object;
    }

    @Override
    protected EffectPeer createPeer(FilterContext filterContext, String string, int n2) {
        if (PrRenderer.isIntrinsicPeer(string)) {
            return this.createIntrinsicPeer(filterContext, string);
        }
        if (this.needsSWDispMap && string.equals("DisplacementMap")) {
            filterContext = ((PrFilterContext)filterContext).getSoftwareInstance();
            return new PPStoPSWDisplacementMapPeer(filterContext, this, string);
        }
        return this.createPlatformPeer(filterContext, string, n2);
    }

    @Override
    public boolean isImageDataCompatible(ImageData object) {
        if (((Renderer)this).getRendererState() == Renderer$RendererState.OK) {
            return (object = ((ImageData)object).getUntransformedImage()) instanceof PrDrawable && !object.isLost();
        }
        return false;
    }

    @Override
    public void clearImage(Filterable filterable) {
        filterable = (PPSDrawable)filterable;
        ((PrDrawable)filterable).clear();
    }

    @Override
    public ImageData createImageData(FilterContext object, Filterable object2) {
        BaseTransform baseTransform;
        int n2;
        if (!this.validate()) {
            return null;
        }
        if (!(object2 instanceof PrImage)) {
            throw new IllegalArgumentException("Identity source must be PrImage");
        }
        int n3 = ((Image)(object2 = ((PrImage)object2).getImage())).getWidth();
        PPSDrawable pPSDrawable = this.createCompatibleImage(n3, n2 = ((Image)object2).getHeight());
        if (pPSDrawable == null) {
            return null;
        }
        ShaderGraphics shaderGraphics = pPSDrawable.createGraphics();
        GraphicsResource graphicsResource = shaderGraphics.getResourceFactory();
        graphicsResource = graphicsResource.createTexture((Image)object2, Texture$Usage.DEFAULT, Texture$WrapMode.CLAMP_TO_EDGE);
        shaderGraphics.drawTexture((Texture)graphicsResource, 0.0f, 0.0f, n3, n2);
        shaderGraphics.sync();
        graphicsResource.dispose();
        float f2 = ((Image)object2).getPixelScale();
        if (f2 != 1.0f) {
            f2 = 1.0f / f2;
            baseTransform = BaseTransform.getScaleInstance(f2, f2);
        } else {
            baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        }
        object = new ImageData((FilterContext)object, pPSDrawable, new Rectangle(n3, n2), baseTransform);
        return object;
    }

    @Override
    public Filterable transform(FilterContext object, Filterable filterable, BaseTransform baseTransform, Rectangle rectangle, Rectangle rectangle2) {
        if (!this.validate()) {
            return null;
        }
        object = this.getCompatibleImage(rectangle2.width, rectangle2.height);
        if (object != null) {
            ShaderGraphics shaderGraphics = ((PPSDrawable)object).createGraphics();
            shaderGraphics.translate(-rectangle2.x, -rectangle2.y);
            shaderGraphics.transform(baseTransform);
            shaderGraphics.drawTexture((Texture)((PPSDrawable)filterable).getTextureObject(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return object;
    }

    @Override
    public ImageData transform(FilterContext filterContext, ImageData imageData, BaseTransform baseTransform, Rectangle rectangle, Rectangle rectangle2) {
        if (!this.validate()) {
            return null;
        }
        PPSDrawable pPSDrawable = this.getCompatibleImage(rectangle2.width, rectangle2.height);
        if (pPSDrawable != null) {
            PPSDrawable pPSDrawable2 = (PPSDrawable)imageData.getUntransformedImage();
            ShaderGraphics shaderGraphics = pPSDrawable.createGraphics();
            shaderGraphics.translate(-rectangle2.x, -rectangle2.y);
            shaderGraphics.transform(baseTransform);
            shaderGraphics.drawTexture((Texture)pPSDrawable2.getTextureObject(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        imageData.unref();
        return new ImageData(filterContext, pPSDrawable, rectangle2);
    }

    private static ShaderSource createShaderSource(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (ShaderSource)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(string + " class not found");
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Renderer createRenderer(FilterContext object) {
        object = ((FilterContext)object).getReferent();
        Object object2 = GraphicsPipeline.getPipeline();
        if (object2 == null || !(object instanceof Screen)) {
            return null;
        }
        object = (Screen)object;
        if (((GraphicsPipeline)object2).supportsShader(GraphicsPipeline$ShaderType.HLSL, GraphicsPipeline$ShaderModel.SM3)) {
            object2 = PPSRenderer.createShaderSource("com.sun.scenario.effect.impl.hw.d3d.D3DShaderSource");
        } else if (((GraphicsPipeline)object2).supportsShader(GraphicsPipeline$ShaderType.GLSL, GraphicsPipeline$ShaderModel.SM3)) {
            object2 = PPSRenderer.createShaderSource("com.sun.scenario.effect.impl.es2.ES2ShaderSource");
        } else {
            throw new InternalError("Unknown GraphicsPipeline");
        }
        if (object2 == null) {
            return null;
        }
        return new PPSRenderer((Screen)object, (ShaderSource)object2);
    }
}

