/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.sw;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.Texture$Usage;
import com.sun.prism.Texture$WrapMode;
import com.sun.scenario.effect.Effect$AccelType;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.Renderer$RendererState;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrImage;
import com.sun.scenario.effect.impl.prism.PrRenderer;
import com.sun.scenario.effect.impl.prism.sw.PSWDrawable;
import com.sun.scenario.effect.impl.sw.RendererDelegate;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;

public class PSWRenderer
extends PrRenderer {
    private final Screen screen;
    private final ResourceFactory resourceFactory;
    private final RendererDelegate delegate;
    private Renderer$RendererState state;

    private PSWRenderer(Screen object, RendererDelegate rendererDelegate) {
        this.screen = object;
        this.resourceFactory = null;
        this.delegate = rendererDelegate;
        object = this;
        synchronized (object) {
            this.state = Renderer$RendererState.OK;
            return;
        }
    }

    private PSWRenderer(ResourceFactory object, RendererDelegate rendererDelegate) {
        this.screen = null;
        this.resourceFactory = object;
        this.delegate = rendererDelegate;
        object = this;
        synchronized (object) {
            this.state = Renderer$RendererState.OK;
            return;
        }
    }

    @Override
    public PrDrawable createDrawable(RTTexture rTTexture) {
        return PSWDrawable.create(rTTexture);
    }

    public static synchronized PSWRenderer createJSWInstance(Screen screen) {
        PSWRenderer pSWRenderer = null;
        try {
            Object object = Class.forName("com.sun.scenario.effect.impl.sw.java.JSWRendererDelegate");
            object = (RendererDelegate)((Class)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pSWRenderer = new PSWRenderer(screen, (RendererDelegate)object);
        }
        catch (Throwable throwable) {}
        return pSWRenderer;
    }

    public static synchronized PSWRenderer createJSWInstance(ResourceFactory resourceFactory) {
        PSWRenderer pSWRenderer = null;
        try {
            Object object = Class.forName("com.sun.scenario.effect.impl.sw.java.JSWRendererDelegate");
            object = (RendererDelegate)((Class)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pSWRenderer = new PSWRenderer(resourceFactory, (RendererDelegate)object);
        }
        catch (Throwable throwable) {}
        return pSWRenderer;
    }

    public static synchronized PSWRenderer createJSWInstance(FilterContext object) {
        PSWRenderer pSWRenderer = null;
        try {
            object = (ResourceFactory)((FilterContext)object).getReferent();
            pSWRenderer = PSWRenderer.createJSWInstance((ResourceFactory)object);
        }
        catch (Throwable throwable) {}
        return pSWRenderer;
    }

    private static synchronized PSWRenderer createSSEInstance(Screen screen) {
        PSWRenderer pSWRenderer = null;
        try {
            Object object = Class.forName("com.sun.scenario.effect.impl.sw.sse.SSERendererDelegate");
            object = (RendererDelegate)((Class)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pSWRenderer = new PSWRenderer(screen, (RendererDelegate)object);
        }
        catch (Throwable throwable) {}
        return pSWRenderer;
    }

    public static Renderer createRenderer(FilterContext object) {
        object = ((FilterContext)object).getReferent();
        Object object2 = GraphicsPipeline.getPipeline();
        if (object2 == null || !(object instanceof Screen)) {
            return null;
        }
        object2 = PSWRenderer.createSSEInstance((Screen)(object = (Screen)object));
        if (object2 == null) {
            object2 = PSWRenderer.createJSWInstance((Screen)object);
        }
        return object2;
    }

    @Override
    public Effect$AccelType getAccelType() {
        return this.delegate.getAccelType();
    }

    @Override
    public synchronized Renderer$RendererState getRendererState() {
        return this.state;
    }

    @Override
    protected Renderer getBackupRenderer() {
        return this;
    }

    protected void dispose() {
        PSWRenderer pSWRenderer = this;
        synchronized (pSWRenderer) {
            this.state = Renderer$RendererState.DISPOSED;
            return;
        }
    }

    protected final synchronized void markLost() {
        if (this.state == Renderer$RendererState.OK) {
            this.state = Renderer$RendererState.LOST;
        }
    }

    @Override
    public int getCompatibleWidth(int n2) {
        if (this.screen != null) {
            return PSWDrawable.getCompatibleWidth(this.screen, n2);
        }
        return this.resourceFactory.getRTTWidth(n2, Texture$WrapMode.CLAMP_TO_EDGE);
    }

    @Override
    public int getCompatibleHeight(int n2) {
        if (this.screen != null) {
            return PSWDrawable.getCompatibleHeight(this.screen, n2);
        }
        return this.resourceFactory.getRTTHeight(n2, Texture$WrapMode.CLAMP_TO_EDGE);
    }

    @Override
    public final PSWDrawable createCompatibleImage(int n2, int n3) {
        if (this.screen != null) {
            return PSWDrawable.create(this.screen, n2, n3);
        }
        RTTexture rTTexture = this.resourceFactory.createRTTexture(n2, n3, Texture$WrapMode.CLAMP_TO_EDGE);
        return PSWDrawable.create(rTTexture);
    }

    @Override
    public PSWDrawable getCompatibleImage(int n2, int n3) {
        PSWDrawable pSWDrawable = (PSWDrawable)super.getCompatibleImage(n2, n3);
        if (pSWDrawable == null) {
            this.markLost();
        }
        return pSWDrawable;
    }

    private EffectPeer createIntrinsicPeer(FilterContext object, String string) {
        try {
            GenericDeclaration genericDeclaration = Class.forName("com.sun.scenario.effect.impl.prism.Pr" + string + "Peer");
            genericDeclaration = genericDeclaration.getConstructor(FilterContext.class, Renderer.class, String.class);
            object = (EffectPeer)((Constructor)genericDeclaration).newInstance(object, this, string);
        }
        catch (Exception exception) {
            return null;
        }
        return object;
    }

    private EffectPeer createPlatformPeer(FilterContext object, String string, int n2) {
        Constructor<?> constructor = this.delegate.getPlatformPeerName(string, n2);
        try {
            constructor = Class.forName((String)((Object)constructor));
            constructor = ((Class)((Object)constructor)).getConstructor(FilterContext.class, Renderer.class, String.class);
            object = (EffectPeer)constructor.newInstance(object, this, string);
        }
        catch (Exception exception) {
            System.err.println("Error: " + String.valueOf((Object)((Renderer)this).getAccelType()) + " peer not found for: " + string + " due to error: " + exception.getMessage());
            return null;
        }
        return object;
    }

    @Override
    protected EffectPeer createPeer(FilterContext filterContext, String string, int n2) {
        if (PrRenderer.isIntrinsicPeer(string)) {
            return this.createIntrinsicPeer(filterContext, string);
        }
        return this.createPlatformPeer(filterContext, string, n2);
    }

    @Override
    public boolean isImageDataCompatible(ImageData imageData) {
        return ((Renderer)this).getRendererState() == Renderer$RendererState.OK && imageData.getUntransformedImage() instanceof PSWDrawable;
    }

    @Override
    public void clearImage(Filterable filterable) {
        filterable = (PSWDrawable)filterable;
        ((PrDrawable)filterable).clear();
    }

    @Override
    public ImageData createImageData(FilterContext filterContext, Filterable object) {
        int n2;
        if (!(object instanceof PrImage)) {
            throw new IllegalArgumentException("Identity source must be PrImage");
        }
        int n3 = ((Image)(object = ((PrImage)object).getImage())).getWidth();
        PSWDrawable pSWDrawable = this.createCompatibleImage(n3, n2 = ((Image)object).getHeight());
        if (pSWDrawable == null) {
            return null;
        }
        Graphics graphics = ((PrDrawable)pSWDrawable).createGraphics();
        ResourceFactory resourceFactory = graphics.getResourceFactory();
        object = resourceFactory.createTexture((Image)object, Texture$Usage.DEFAULT, Texture$WrapMode.CLAMP_TO_EDGE);
        graphics.drawTexture((Texture)object, 0.0f, 0.0f, n3, n2);
        graphics.sync();
        object.dispose();
        return new ImageData(filterContext, pSWDrawable, new Rectangle(n3, n2));
    }

    @Override
    public Filterable transform(FilterContext object, Filterable filterable, BaseTransform baseTransform, Rectangle rectangle, Rectangle rectangle2) {
        object = this.getCompatibleImage(rectangle2.width, rectangle2.height);
        if (object != null) {
            Graphics graphics = ((PrDrawable)object).createGraphics();
            graphics.translate(-rectangle2.x, -rectangle2.y);
            graphics.transform(baseTransform);
            graphics.drawTexture(((PSWDrawable)filterable).getTextureObject(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return object;
    }

    @Override
    public ImageData transform(FilterContext filterContext, ImageData imageData, BaseTransform baseTransform, Rectangle rectangle, Rectangle rectangle2) {
        PSWDrawable pSWDrawable = this.getCompatibleImage(rectangle2.width, rectangle2.height);
        if (pSWDrawable != null) {
            PSWDrawable pSWDrawable2 = (PSWDrawable)imageData.getUntransformedImage();
            Graphics graphics = ((PrDrawable)pSWDrawable).createGraphics();
            graphics.translate(-rectangle2.x, -rectangle2.y);
            graphics.transform(baseTransform);
            graphics.drawTexture(pSWDrawable2.getTextureObject(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        imageData.unref();
        return new ImageData(filterContext, pSWDrawable, rectangle2);
    }
}

