/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.LinearConvolveRenderState;
import com.sun.scenario.effect.impl.state.RenderState$EffectCoordinateSpace;
import java.nio.FloatBuffer;

public class BoxRenderState
extends LinearConvolveRenderState {
    private static final int[] MAX_BOX_SIZES = new int[]{BoxRenderState.getMaxSizeForKernelSize(MAX_KERNEL_SIZE, 0), BoxRenderState.getMaxSizeForKernelSize(MAX_KERNEL_SIZE, 1), BoxRenderState.getMaxSizeForKernelSize(MAX_KERNEL_SIZE, 2), BoxRenderState.getMaxSizeForKernelSize(MAX_KERNEL_SIZE, 3)};
    private final boolean isShadow;
    private final int blurPasses;
    private final float spread;
    private Color4f shadowColor;
    private RenderState$EffectCoordinateSpace space;
    private BaseTransform inputtx;
    private BaseTransform resulttx;
    private final float inputSizeH;
    private final float inputSizeV;
    private final int spreadPass;
    private float[] samplevectors;
    private int validatedPass;
    private float passSize;
    private FloatBuffer weights;
    private float weightsValidSize;
    private float weightsValidSpread;
    private boolean swCompatible;

    public static int getMaxSizeForKernelSize(int n2, int n3) {
        if (n3 == 0) {
            return Integer.MAX_VALUE;
        }
        int n4 = n2 - 1 | 1;
        n4 = (n4 - 1) / n3 | 1;
        assert (BoxRenderState.getKernelSize(n4, n3) <= n2);
        return n4;
    }

    public static int getKernelSize(int n2, int n3) {
        n2 = n2 <= 0 ? 1 : n2;
        n2 = (n2 - 1) * n3 + 1;
        return n2 |= 1;
    }

    public BoxRenderState(float f2, float f3, int n2, float f4, boolean bl2, Color4f color4f, BaseTransform baseTransform) {
        this.isShadow = bl2;
        this.shadowColor = color4f;
        this.spread = f4;
        this.blurPasses = n2;
        if (baseTransform == null) {
            baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        }
        double d2 = Math.hypot(baseTransform.getMxx(), baseTransform.getMyx());
        double d3 = Math.hypot(baseTransform.getMxy(), baseTransform.getMyy());
        f4 = (float)((double)f2 * d2);
        float f5 = (float)((double)f3 * d3);
        if (f4 > (float)(n2 = MAX_BOX_SIZES[n2])) {
            d2 = (float)n2 / f2;
            f4 = n2;
        }
        if (f5 > (float)n2) {
            d3 = (float)n2 / f3;
            f5 = n2;
        }
        this.inputSizeH = f4;
        this.inputSizeV = f5;
        this.spreadPass = f5 > 1.0f ? 1 : 0;
        boolean bl3 = d2 != baseTransform.getMxx() || 0.0 != baseTransform.getMyx() || d3 != baseTransform.getMyy() || 0.0 != baseTransform.getMxy();
        if (bl3) {
            this.space = RenderState$EffectCoordinateSpace.CustomSpace;
            this.inputtx = BaseTransform.getScaleInstance(d2, d3);
            this.resulttx = baseTransform.copy().deriveWithScale(1.0 / d2, 1.0 / d3, 1.0);
            return;
        }
        this.space = RenderState$EffectCoordinateSpace.RenderSpace;
        this.inputtx = baseTransform;
        this.resulttx = BaseTransform.IDENTITY_TRANSFORM;
    }

    public int getBoxPixelSize(int n2) {
        float f2;
        float f3 = this.passSize;
        if (f2 < 1.0f) {
            f3 = 1.0f;
        }
        int n3 = (int)Math.ceil(f3) | 1;
        return n3;
    }

    public int getBlurPasses() {
        return this.blurPasses;
    }

    public float getSpread() {
        return this.spread;
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public Color4f getShadowColor() {
        return this.shadowColor;
    }

    @Override
    public float[] getPassShadowColorComponents() {
        if (this.validatedPass == 0) {
            return BLACK_COMPONENTS;
        }
        return this.shadowColor.getPremultipliedRGBComponents();
    }

    @Override
    public RenderState$EffectCoordinateSpace getEffectTransformSpace() {
        return this.space;
    }

    @Override
    public BaseTransform getInputTransform(BaseTransform baseTransform) {
        return this.inputtx;
    }

    @Override
    public BaseTransform getResultTransform(BaseTransform baseTransform) {
        return this.resulttx;
    }

    public EffectPeer<BoxRenderState> getPassPeer(Renderer object, FilterContext filterContext) {
        if (((LinearConvolveRenderState)this).isPassNop()) {
            return null;
        }
        int n2 = ((LinearConvolveRenderState)this).getPassKernelSize();
        n2 = BoxRenderState.getPeerSize(n2);
        Object object2 = ((Renderer)object).getAccelType();
        switch (object2) {
            case NONE: 
            case SIMD: {
                if (this.swCompatible && this.spread == 0.0f) {
                    object2 = ((LinearConvolveRenderState)this).isShadow() ? "BoxShadow" : "BoxBlur";
                    break;
                }
            }
            default: {
                object2 = ((LinearConvolveRenderState)this).isShadow() ? "LinearConvolveShadow" : "LinearConvolve";
            }
        }
        object = ((Renderer)object).getPeerInstance(filterContext, (String)object2, n2);
        return object;
    }

    @Override
    public Rectangle getInputClip(int n2, Rectangle rectangle) {
        int n3;
        if (rectangle != null && ((n2 = ((LinearConvolveRenderState)this).getInputKernelSize(0)) | (n3 = ((LinearConvolveRenderState)this).getInputKernelSize(1))) > 1) {
            rectangle = new Rectangle(rectangle);
            rectangle.grow(n2 / 2, n3 / 2);
        }
        return rectangle;
    }

    @Override
    public ImageData validatePassInput(ImageData imageData, int n2) {
        float f2;
        this.validatedPass = n2;
        BaseTransform baseTransform = imageData.getTransform();
        this.samplevectors = new float[2];
        this.samplevectors[n2] = 1.0f;
        float f3 = f2 = n2 == 0 ? this.inputSizeH : this.inputSizeV;
        if (baseTransform.isTranslateOrIdentity()) {
            this.swCompatible = true;
            this.passSize = f2;
        } else {
            try {
                baseTransform.inverseDeltaTransform(this.samplevectors, 0, this.samplevectors, 0, 1);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                this.passSize = 0.0f;
                this.samplevectors[1] = 0.0f;
                this.samplevectors[0] = 0.0f;
                this.swCompatible = true;
                return imageData;
            }
            double d2 = Math.hypot(this.samplevectors[0], this.samplevectors[1]);
            float f4 = (float)((double)f2 * d2);
            f4 = (float)((double)f4 * d2);
            int n3 = MAX_BOX_SIZES[this.blurPasses];
            if (f4 > (float)n3) {
                f4 = n3;
                d2 = (float)n3 / f2;
            }
            this.passSize = f4;
            this.samplevectors[0] = (float)((double)this.samplevectors[0] / d2);
            this.samplevectors[1] = (float)((double)this.samplevectors[1] / d2);
            Rectangle rectangle = imageData.getUntransformedBounds();
            this.swCompatible = n2 == 0 ? BoxRenderState.nearOne(this.samplevectors[0], rectangle.width) && BoxRenderState.nearZero(this.samplevectors[1], rectangle.width) : BoxRenderState.nearZero(this.samplevectors[0], rectangle.height) && BoxRenderState.nearOne(this.samplevectors[1], rectangle.height);
        }
        Filterable filterable = imageData.getUntransformedImage();
        this.samplevectors[0] = this.samplevectors[0] / (float)filterable.getPhysicalWidth();
        this.samplevectors[1] = this.samplevectors[1] / (float)filterable.getPhysicalHeight();
        return imageData;
    }

    @Override
    public Rectangle getPassResultBounds(Rectangle rectangle, Rectangle rectangle2) {
        rectangle = new Rectangle(rectangle);
        if (this.validatedPass == 0) {
            rectangle.grow(((LinearConvolveRenderState)this).getInputKernelSize(0) / 2, 0);
        } else {
            rectangle.grow(0, ((LinearConvolveRenderState)this).getInputKernelSize(1) / 2);
        }
        if (rectangle2 != null) {
            if (this.validatedPass == 0) {
                rectangle2 = new Rectangle(rectangle2);
                rectangle2.grow(0, ((LinearConvolveRenderState)this).getInputKernelSize(1) / 2);
            }
            rectangle.intersectWith(rectangle2);
        }
        return rectangle;
    }

    @Override
    public float[] getPassVector() {
        float f2 = this.samplevectors[0];
        float f3 = this.samplevectors[1];
        int n2 = ((LinearConvolveRenderState)this).getPassKernelSize();
        float[] fArray = new float[4];
        float[] fArray2 = fArray;
        fArray[0] = f2;
        fArray2[1] = f3;
        fArray2[2] = (float)(-(n2 /= 2)) * f2;
        fArray2[3] = (float)(-n2) * f3;
        return fArray2;
    }

    @Override
    public int getPassWeightsArrayLength() {
        this.validateWeights();
        return this.weights.limit() / 4;
    }

    @Override
    public FloatBuffer getPassWeights() {
        this.validateWeights();
        this.weights.rewind();
        return this.weights;
    }

    private void validateWeights() {
        int n2;
        double d2;
        int n3;
        float f2;
        float f3;
        if (this.blurPasses == 0) {
            f3 = 1.0f;
        } else {
            float f4;
            f3 = this.passSize;
            if (f4 < 1.0f) {
                f3 = 1.0f;
            }
        }
        float f5 = f2 = this.validatedPass == this.spreadPass ? this.spread : 0.0f;
        if (this.weights != null && this.weightsValidSize == f3 && this.weightsValidSpread == f2) {
            return;
        }
        int n4 = n3 = (int)Math.ceil(f3) | 1;
        for (int i2 = 1; i2 < this.blurPasses; ++i2) {
            n4 += n3 - 1;
        }
        double[] dArray = new double[n4];
        for (int i3 = 0; i3 < n3; ++i3) {
            dArray[i3] = 1.0;
        }
        double d3 = (float)n3 - f3;
        if (d2 > 0.0) {
            double d4 = 1.0 - d3 * 0.5;
            dArray[n3 - 1] = d4;
            dArray[0] = d4;
        }
        int n5 = n3;
        for (int i4 = 1; i4 < this.blurPasses; ++i4) {
            double d5;
            int n6 = (n5 += n3 - 1) - 1;
            while (n6 > n3) {
                d5 = dArray[n6];
                for (n4 = 1; n4 < n3; ++n4) {
                    d5 += dArray[n6 - n4];
                }
                dArray[n6--] = d5;
            }
            while (n6 > 0) {
                d5 = dArray[n6];
                for (n4 = 0; n4 < n6; ++n4) {
                    d5 += dArray[n4];
                }
                dArray[n6--] = d5;
            }
        }
        double d6 = 0.0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            d6 += dArray[n2];
        }
        d6 += (1.0 - d6) * (double)f2;
        if (this.weights == null) {
            n2 = BoxRenderState.getPeerSize(MAX_KERNEL_SIZE);
            n2 = n2 + 3 & 0xFFFFFFFC;
            this.weights = BufferUtil.newFloatBuffer(n2);
        }
        this.weights.clear();
        for (n2 = 0; n2 < dArray.length; ++n2) {
            this.weights.put((float)(dArray[n2] / d6));
        }
        n2 = BoxRenderState.getPeerSize(dArray.length);
        while (this.weights.position() < n2) {
            this.weights.put(0.0f);
        }
        this.weights.limit(n2);
        this.weights.rewind();
    }

    @Override
    public int getInputKernelSize(int n2) {
        float f2;
        float f3 = f2 = n2 == 0 ? this.inputSizeH : this.inputSizeV;
        if (f3 < 1.0f) {
            f2 = 1.0f;
        }
        int n3 = (int)Math.ceil(f2) | 1;
        int n4 = 1;
        for (int i2 = 0; i2 < this.blurPasses; ++i2) {
            n4 += n3 - 1;
        }
        return n4;
    }

    @Override
    public int getPassKernelSize() {
        float f2;
        float f3 = this.passSize;
        if (f2 < 1.0f) {
            f3 = 1.0f;
        }
        int n2 = (int)Math.ceil(f3) | 1;
        int n3 = 1;
        for (int i2 = 0; i2 < this.blurPasses; ++i2) {
            n3 += n2 - 1;
        }
        return n3;
    }

    @Override
    public boolean isNop() {
        if (this.isShadow) {
            return false;
        }
        return this.blurPasses == 0 || this.inputSizeH <= 1.0f && this.inputSizeV <= 1.0f;
    }

    @Override
    public boolean isPassNop() {
        if (this.isShadow && this.validatedPass == 1) {
            return false;
        }
        return this.blurPasses == 0 || this.passSize <= 1.0f;
    }
}

