/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.light;

import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.light.Light;
import com.sun.scenario.effect.light.Light$Type;

public class DistantLight
extends Light {
    private float azimuth;
    private float elevation;

    public DistantLight() {
        this(0.0f, 0.0f, Color4f.WHITE);
    }

    public DistantLight(float f2, float f3, Color4f color4f) {
        super(Light$Type.DISTANT, color4f);
        this.azimuth = f2;
        this.elevation = f3;
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(float f2) {
        this.azimuth = f2;
    }

    public float getElevation() {
        return this.elevation;
    }

    public void setElevation(float f2) {
        this.elevation = f2;
    }

    @Override
    public float[] getNormalizedLightPosition() {
        double d2 = Math.toRadians(this.azimuth);
        double d3 = Math.toRadians(this.elevation);
        float f2 = (float)(Math.cos(d2) * Math.cos(d3));
        float f3 = (float)(Math.sin(d2) * Math.cos(d3));
        float f4 = (float)Math.sin(d3);
        float f5 = f2;
        float f6 = f3;
        float f7 = f4;
        float f8 = (float)Math.sqrt(f5 * f5 + f6 * f6 + f7 * f7);
        if (f8 == 0.0f) {
            f8 = 1.0f;
        }
        float[] fArray = new float[]{f2 / f8, f3 / f8, f4 / f8};
        return fArray;
    }
}

