/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.light;

import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.light.Light$Type;
import com.sun.scenario.effect.light.PointLight;

public class SpotLight
extends PointLight {
    private float pointsAtX = 0.0f;
    private float pointsAtY = 0.0f;
    private float pointsAtZ = 0.0f;
    private float specularExponent = 1.0f;

    public SpotLight() {
        this(0.0f, 0.0f, 0.0f, Color4f.WHITE);
    }

    public SpotLight(float f2, float f3, float f4, Color4f color4f) {
        super(Light$Type.SPOT, f2, f3, f4, color4f);
    }

    public float getPointsAtX() {
        return this.pointsAtX;
    }

    public void setPointsAtX(float f2) {
        this.pointsAtX = f2;
    }

    public float getPointsAtY() {
        return this.pointsAtY;
    }

    public void setPointsAtY(float f2) {
        this.pointsAtY = f2;
    }

    public float getPointsAtZ() {
        return this.pointsAtZ;
    }

    public void setPointsAtZ(float f2) {
        this.pointsAtZ = f2;
    }

    public float getSpecularExponent() {
        return this.specularExponent;
    }

    public void setSpecularExponent(float f2) {
        if (f2 < 0.0f || f2 > 4.0f) {
            throw new IllegalArgumentException("Specular exponent must be in the range [0,4]");
        }
        this.specularExponent = f2;
    }

    @Override
    public float[] getNormalizedLightPosition() {
        float f2 = this.getX();
        float f3 = this.getY();
        float f4 = this.getZ();
        float f5 = f2;
        float f6 = f3;
        float f7 = f4;
        float f8 = (float)Math.sqrt(f5 * f5 + f6 * f6 + f7 * f7);
        if (f8 == 0.0f) {
            f8 = 1.0f;
        }
        float[] fArray = new float[]{f2 / f8, f3 / f8, f4 / f8};
        return fArray;
    }

    public float[] getNormalizedLightDirection() {
        float f2 = this.pointsAtX - this.getX();
        float f3 = this.pointsAtY - this.getY();
        float f4 = this.pointsAtZ - this.getZ();
        float f5 = f2;
        float f6 = f3;
        float f7 = f4;
        float f8 = (float)Math.sqrt(f5 * f5 + f6 * f6 + f7 * f7);
        if (f8 == 0.0f) {
            f8 = 1.0f;
        }
        float[] fArray = new float[]{f2 / f8, f3 / f8, f4 / f8};
        return fArray;
    }
}

