/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken;

import io.jsonwebtoken.lang.Arrays;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.WeakKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;

@Deprecated
public enum SignatureAlgorithm {
    NONE("none", "No digital signature or MAC performed", "None", null, false, 0, 0),
    HS256("HS256", "HMAC using SHA-256", "HMAC", "HmacSHA256", true, 256, 256, "1.2.840.113549.2.9"),
    HS384("HS384", "HMAC using SHA-384", "HMAC", "HmacSHA384", true, 384, 384, "1.2.840.113549.2.10"),
    HS512("HS512", "HMAC using SHA-512", "HMAC", "HmacSHA512", true, 512, 512, "1.2.840.113549.2.11"),
    RS256("RS256", "RSASSA-PKCS-v1_5 using SHA-256", "RSA", "SHA256withRSA", true, 256, 2048),
    RS384("RS384", "RSASSA-PKCS-v1_5 using SHA-384", "RSA", "SHA384withRSA", true, 384, 2048),
    RS512("RS512", "RSASSA-PKCS-v1_5 using SHA-512", "RSA", "SHA512withRSA", true, 512, 2048),
    ES256("ES256", "ECDSA using P-256 and SHA-256", "ECDSA", "SHA256withECDSA", true, 256, 256),
    ES384("ES384", "ECDSA using P-384 and SHA-384", "ECDSA", "SHA384withECDSA", true, 384, 384),
    ES512("ES512", "ECDSA using P-521 and SHA-512", "ECDSA", "SHA512withECDSA", true, 512, 521),
    PS256("PS256", "RSASSA-PSS using SHA-256 and MGF1 with SHA-256", "RSA", "RSASSA-PSS", false, 256, 2048),
    PS384("PS384", "RSASSA-PSS using SHA-384 and MGF1 with SHA-384", "RSA", "RSASSA-PSS", false, 384, 2048),
    PS512("PS512", "RSASSA-PSS using SHA-512 and MGF1 with SHA-512", "RSA", "RSASSA-PSS", false, 512, 2048);

    private static final List<SignatureAlgorithm> PREFERRED_HMAC_ALGS;
    private static final List<SignatureAlgorithm> PREFERRED_EC_ALGS;
    private final String value;
    private final String description;
    private final String familyName;
    private final String jcaName;
    private final boolean jdkStandard;
    private final int digestLength;
    private final int minKeyLength;
    @Deprecated
    private final String pkcs12Name;

    private SignatureAlgorithm(String string2, String string3, String string4, String string5, boolean bl2, int n3, int n4) {
        this(string2, string3, string4, string5, bl2, n3, n4, string5);
    }

    private SignatureAlgorithm(String string2, String string3, String string4, String string5, boolean bl2, int n3, int n4, String string6) {
        this.value = string2;
        this.description = string3;
        this.familyName = string4;
        this.jcaName = string5;
        this.jdkStandard = bl2;
        this.digestLength = n3;
        this.minKeyLength = n4;
        this.pkcs12Name = string6;
    }

    public final String getValue() {
        return this.value;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getFamilyName() {
        return this.familyName;
    }

    public final String getJcaName() {
        return this.jcaName;
    }

    public final boolean isJdkStandard() {
        return this.jdkStandard;
    }

    public final boolean isHmac() {
        return this.familyName.equals("HMAC");
    }

    public final boolean isRsa() {
        return this.familyName.equals("RSA");
    }

    public final boolean isEllipticCurve() {
        return this.familyName.equals("ECDSA");
    }

    public final int getMinKeyLength() {
        return this.minKeyLength;
    }

    public final void assertValidSigningKey(Key key) throws InvalidKeyException {
        this.assertValid(key, true);
    }

    public final void assertValidVerificationKey(Key key) throws InvalidKeyException {
        this.assertValid(key, false);
    }

    private static String keyType(boolean bl2) {
        if (bl2) {
            return "signing";
        }
        return "verification";
    }

    private void assertValid(Key object, boolean bl2) throws InvalidKeyException {
        if (this == NONE) {
            object = "The 'NONE' signature algorithm does not support cryptographic keys.";
            throw new InvalidKeyException((String)object);
        }
        if (this.isHmac()) {
            if (!(object instanceof SecretKey)) {
                object = this.familyName + " " + SignatureAlgorithm.keyType(bl2) + " keys must be SecretKey instances.";
                throw new InvalidKeyException((String)object);
            }
            byte[] byArray = (object = (SecretKey)object).getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("The " + SignatureAlgorithm.keyType(bl2) + " key's encoded bytes cannot be null.");
            }
            if ((object = object.getAlgorithm()) == null) {
                throw new InvalidKeyException("The " + SignatureAlgorithm.keyType(bl2) + " key's algorithm cannot be null.");
            }
            if (!(SignatureAlgorithm.HS256.jcaName.equalsIgnoreCase((String)object) || SignatureAlgorithm.HS384.jcaName.equalsIgnoreCase((String)object) || SignatureAlgorithm.HS512.jcaName.equalsIgnoreCase((String)object) || SignatureAlgorithm.HS256.pkcs12Name.equals(object) || SignatureAlgorithm.HS384.pkcs12Name.equals(object) || SignatureAlgorithm.HS512.pkcs12Name.equals(object))) {
                throw new InvalidKeyException("The " + SignatureAlgorithm.keyType(bl2) + " key's algorithm '" + (String)object + "' does not equal a valid HmacSHA* algorithm name and cannot be used with " + this.name() + ".");
            }
            int n2 = byArray.length << 3;
            if (n2 < this.minKeyLength) {
                String string = "The " + SignatureAlgorithm.keyType(bl2) + " key's size is " + n2 + " bits which is not secure enough for the " + this.name() + " algorithm.  The JWT JWA Specification (RFC 7518, Section 3.2) states that keys used with " + this.name() + " MUST have a size >= " + this.minKeyLength + " bits (the key size must be greater than or equal to the hash output size).  Consider using the " + Keys.class.getName() + " class's 'secretKeyFor(SignatureAlgorithm." + this.name() + ")' method to create a key guaranteed to be secure enough for " + this.name() + ".  See https://tools.ietf.org/html/rfc7518#section-3.2 for more information.";
                throw new WeakKeyException(string);
            }
            return;
        }
        if (bl2 && !(object instanceof PrivateKey)) {
            object = this.familyName + " signing keys must be PrivateKey instances.";
            throw new InvalidKeyException((String)object);
        }
        if (this.isEllipticCurve()) {
            if (!(object instanceof ECKey)) {
                object = this.familyName + " " + SignatureAlgorithm.keyType(bl2) + " keys must be ECKey instances.";
                throw new InvalidKeyException((String)object);
            }
            int n3 = (object = (ECKey)object).getParams().getOrder().bitLength();
            if (n3 < this.minKeyLength) {
                object = "The " + SignatureAlgorithm.keyType(bl2) + " key's size (ECParameterSpec order) is " + n3 + " bits which is not secure enough for the " + this.name() + " algorithm.  The JWT JWA Specification (RFC 7518, Section 3.4) states that keys used with " + this.name() + " MUST have a size >= " + this.minKeyLength + " bits.  Consider using the " + Keys.class.getName() + " class's 'keyPairFor(SignatureAlgorithm." + this.name() + ")' method to create a key pair guaranteed to be secure enough for " + this.name() + ".  See https://tools.ietf.org/html/rfc7518#section-3.4 for more information.";
                throw new WeakKeyException((String)object);
            }
            return;
        }
        if (!(object instanceof RSAKey)) {
            object = this.familyName + " " + SignatureAlgorithm.keyType(bl2) + " keys must be RSAKey instances.";
            throw new InvalidKeyException((String)object);
        }
        int n4 = (object = (RSAKey)object).getModulus().bitLength();
        if (n4 < this.minKeyLength) {
            object = this.name().startsWith("P") ? "3.5" : "3.3";
            object = "The " + SignatureAlgorithm.keyType(bl2) + " key's size is " + n4 + " bits which is not secure enough for the " + this.name() + " algorithm.  The JWT JWA Specification (RFC 7518, Section " + (String)object + ") states that keys used with " + this.name() + " MUST have a size >= " + this.minKeyLength + " bits.  Consider using the " + Keys.class.getName() + " class's 'keyPairFor(SignatureAlgorithm." + this.name() + ")' method to create a key pair guaranteed to be secure enough for " + this.name() + ".  See https://tools.ietf.org/html/rfc7518#section-" + (String)object + " for more information.";
            throw new WeakKeyException((String)object);
        }
    }

    public static SignatureAlgorithm forSigningKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key argument cannot be null.");
        }
        if (!(key instanceof SecretKey || key instanceof PrivateKey && (key instanceof ECKey || key instanceof RSAKey))) {
            String string = "JWT standard signing algorithms require either 1) a SecretKey for HMAC-SHA algorithms or 2) a private RSAKey for RSA algorithms or 3) a private ECKey for Elliptic Curve algorithms.  The specified key is of type " + key.getClass().getName();
            throw new InvalidKeyException(string);
        }
        if (key instanceof SecretKey) {
            SecretKey secretKey = (SecretKey)key;
            int n2 = Arrays.length(secretKey.getEncoded()) << 3;
            for (SignatureAlgorithm signatureAlgorithm : PREFERRED_HMAC_ALGS) {
                if (n2 < signatureAlgorithm.minKeyLength) continue;
                return signatureAlgorithm;
            }
            String string = "The specified SecretKey is not strong enough to be used with JWT HMAC signature algorithms.  The JWT specification requires HMAC keys to be >= 256 bits long.  The specified key is " + n2 + " bits.  See https://tools.ietf.org/html/rfc7518#section-3.2 for more information.";
            throw new WeakKeyException(string);
        }
        if (key instanceof RSAKey) {
            RSAKey rSAKey = (RSAKey)((Object)key);
            int n3 = rSAKey.getModulus().bitLength();
            if (n3 >= 4096) {
                RS512.assertValidSigningKey(key);
                return RS512;
            }
            if (n3 >= 3072) {
                RS384.assertValidSigningKey(key);
                return RS384;
            }
            if (n3 >= SignatureAlgorithm.RS256.minKeyLength) {
                RS256.assertValidSigningKey(key);
                return RS256;
            }
            String string = "The specified RSA signing key is not strong enough to be used with JWT RSA signature algorithms.  The JWT specification requires RSA keys to be >= 2048 bits long.  The specified RSA key is " + n3 + " bits.  See https://tools.ietf.org/html/rfc7518#section-3.3 for more information.";
            throw new WeakKeyException(string);
        }
        ECKey eCKey = (ECKey)((Object)key);
        int n4 = eCKey.getParams().getOrder().bitLength();
        for (SignatureAlgorithm signatureAlgorithm : PREFERRED_EC_ALGS) {
            if (n4 < signatureAlgorithm.minKeyLength) continue;
            signatureAlgorithm.assertValidSigningKey(key);
            return signatureAlgorithm;
        }
        String string = "The specified Elliptic Curve signing key is not strong enough to be used with JWT ECDSA signature algorithms.  The JWT specification requires ECDSA keys to be >= 256 bits long.  The specified ECDSA key is " + n4 + " bits.  See https://tools.ietf.org/html/rfc7518#section-3.4 for more information.";
        throw new WeakKeyException(string);
    }

    public static SignatureAlgorithm forName(String string) throws SignatureException {
        for (SignatureAlgorithm signatureAlgorithm : SignatureAlgorithm.values()) {
            if (!signatureAlgorithm.getValue().equalsIgnoreCase(string)) continue;
            return signatureAlgorithm;
        }
        throw new SignatureException("Unsupported signature algorithm '" + string + "'");
    }

    static {
        PREFERRED_HMAC_ALGS = Collections.unmodifiableList(java.util.Arrays.asList(HS512, HS384, HS256));
        PREFERRED_EC_ALGS = Collections.unmodifiableList(java.util.Arrays.asList(ES512, ES384, ES256));
    }
}

