/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtVisitor;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;

public class DefaultJwt<H extends Header, P>
implements Jwt<H, P> {
    private final H header;
    private final P payload;

    public DefaultJwt(H h2, P p2) {
        this.header = (Header)Assert.notNull(h2, "header cannot be null.");
        this.payload = Assert.notNull(p2, "payload cannot be null.");
    }

    @Override
    public H getHeader() {
        return this.header;
    }

    @Override
    public P getBody() {
        return this.getPayload();
    }

    @Override
    public P getPayload() {
        return this.payload;
    }

    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("header=").append(this.header).append(",payload=");
        if (this.payload instanceof byte[]) {
            String string = Encoders.BASE64URL.encode((byte[])this.payload);
            stringBuilder.append(string);
        } else {
            stringBuilder.append(this.payload);
        }
        return stringBuilder;
    }

    public final String toString() {
        return this.toStringBuilder().toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Jwt) {
            return Objects.nullSafeEquals(this.header, (object = (Jwt)object).getHeader()) && Objects.nullSafeEquals(this.payload, object.getPayload());
        }
        return false;
    }

    public int hashCode() {
        return Objects.nullSafeHashCode(this.header, this.payload);
    }

    @Override
    public <T> T accept(JwtVisitor<T> jwtVisitor) {
        return jwtVisitor.visit(this);
    }
}

