/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ClaimsMutator$AudienceCollection;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtBuilder$BuilderClaims;
import io.jsonwebtoken.JwtBuilder$BuilderHeader;
import io.jsonwebtoken.Jwts$KEY;
import io.jsonwebtoken.Jwts$SIG;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.DefaultJweHeader;
import io.jsonwebtoken.impl.DefaultJwsHeader;
import io.jsonwebtoken.impl.DefaultJwtBuilder$1;
import io.jsonwebtoken.impl.DefaultJwtBuilder$2;
import io.jsonwebtoken.impl.DefaultJwtBuilder$3;
import io.jsonwebtoken.impl.DefaultJwtBuilder$DefaultBuilderClaims;
import io.jsonwebtoken.impl.DefaultJwtBuilder$DefaultBuilderHeader;
import io.jsonwebtoken.impl.DefaultMutableJweHeader;
import io.jsonwebtoken.impl.DefaultProtectedHeader;
import io.jsonwebtoken.impl.DelegateAudienceCollection;
import io.jsonwebtoken.impl.Payload;
import io.jsonwebtoken.impl.io.Base64UrlStreamEncoder;
import io.jsonwebtoken.impl.io.ByteBase64UrlStreamEncoder;
import io.jsonwebtoken.impl.io.CountingInputStream;
import io.jsonwebtoken.impl.io.EncodingOutputStream;
import io.jsonwebtoken.impl.io.NamedSerializer;
import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.io.UncloseableInputStream;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.lang.Functions;
import io.jsonwebtoken.impl.lang.Services;
import io.jsonwebtoken.impl.security.DefaultAeadRequest;
import io.jsonwebtoken.impl.security.DefaultAeadResult;
import io.jsonwebtoken.impl.security.DefaultKeyRequest;
import io.jsonwebtoken.impl.security.DefaultSecureRequest;
import io.jsonwebtoken.impl.security.Pbes2HsAkwAlgorithm;
import io.jsonwebtoken.impl.security.ProviderKey;
import io.jsonwebtoken.impl.security.StandardSecureDigestAlgorithms;
import io.jsonwebtoken.io.CompressionAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.Encoder;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.AeadAlgorithm;
import io.jsonwebtoken.security.AeadRequest;
import io.jsonwebtoken.security.AeadResult;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeyAlgorithm;
import io.jsonwebtoken.security.KeyRequest;
import io.jsonwebtoken.security.KeyResult;
import io.jsonwebtoken.security.Password;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.UnsupportedKeyException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DefaultJwtBuilder
implements JwtBuilder {
    private static final String PUB_KEY_SIGN_MSG = "PublicKeys may not be used to create digital signatures. PrivateKeys are used to sign, and PublicKeys are used to verify.";
    private static final String PRIV_KEY_ENC_MSG = "PrivateKeys may not be used to encrypt data. PublicKeys are used to encrypt, and PrivateKeys are used to decrypt.";
    protected Provider provider;
    protected SecureRandom secureRandom;
    private final DefaultJwtBuilder$DefaultBuilderHeader headerBuilder;
    private final DefaultJwtBuilder$DefaultBuilderClaims claimsBuilder;
    private Payload payload = Payload.EMPTY;
    private SecureDigestAlgorithm<Key, ?> sigAlg = Jwts$SIG.NONE;
    private Function<SecureRequest<InputStream, Key>, byte[]> signFunction;
    private AeadAlgorithm enc;
    private KeyAlgorithm<Key, ?> keyAlg;
    private Function<KeyRequest<Key>, KeyResult> keyAlgFunction;
    private Key key;
    private Serializer<Map<String, ?>> serializer;
    protected Encoder<OutputStream, OutputStream> encoder = Base64UrlStreamEncoder.INSTANCE;
    private boolean encodePayload = true;
    protected CompressionAlgorithm compressionAlgorithm;

    public DefaultJwtBuilder() {
        this.headerBuilder = new DefaultJwtBuilder$DefaultBuilderHeader(this, null);
        this.claimsBuilder = new DefaultJwtBuilder$DefaultBuilderClaims(this, null);
    }

    @Override
    public JwtBuilder$BuilderHeader header() {
        return this.headerBuilder;
    }

    @Override
    public JwtBuilder$BuilderClaims claims() {
        return this.claimsBuilder;
    }

    @Override
    public JwtBuilder provider(Provider provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public JwtBuilder random(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    @Override
    public JwtBuilder serializeToJsonWith(Serializer<Map<String, ?>> serializer) {
        return this.json(serializer);
    }

    @Override
    public JwtBuilder json(Serializer<Map<String, ?>> serializer) {
        this.serializer = Assert.notNull(serializer, "JSON Serializer cannot be null.");
        return this;
    }

    @Override
    public JwtBuilder base64UrlEncodeWith(Encoder<byte[], String> encoder) {
        return this.b64Url(new ByteBase64UrlStreamEncoder(encoder));
    }

    @Override
    public JwtBuilder b64Url(Encoder<OutputStream, OutputStream> encoder) {
        Assert.notNull(encoder, "encoder cannot be null.");
        this.encoder = encoder;
        return this;
    }

    @Override
    public JwtBuilder encodePayload(boolean bl2) {
        this.encodePayload = bl2;
        String string = DefaultProtectedHeader.CRIT.getId();
        String string2 = DefaultJwsHeader.B64.getId();
        LinkedHashSet linkedHashSet = (LinkedHashSet)DefaultJwtBuilder$DefaultBuilderHeader.access$200(this.headerBuilder, DefaultProtectedHeader.CRIT);
        linkedHashSet = new LinkedHashSet(Collections.nullSafe(linkedHashSet));
        linkedHashSet.remove(string2);
        return (JwtBuilder)((JwtBuilder$BuilderHeader)((JwtBuilder$BuilderHeader)this.header().delete(string2)).add(string, linkedHashSet)).and();
    }

    @Override
    public JwtBuilder setHeader(Map<String, ?> map) {
        return (JwtBuilder)((JwtBuilder$BuilderHeader)((JwtBuilder$BuilderHeader)this.header().empty()).add(map)).and();
    }

    @Override
    public JwtBuilder setHeaderParams(Map<String, ?> map) {
        return (JwtBuilder)((JwtBuilder$BuilderHeader)this.header().add(map)).and();
    }

    @Override
    public JwtBuilder setHeaderParam(String string, Object object) {
        return (JwtBuilder)((JwtBuilder$BuilderHeader)this.header().add(string, object)).and();
    }

    protected static <K extends Key> SecureDigestAlgorithm<K, ?> forSigningKey(K object) {
        Assert.notNull(object, "Key cannot be null.");
        object = StandardSecureDigestAlgorithms.findBySigningKey(object);
        if (object == null) {
            object = "Unable to determine a suitable MAC or Signature algorithm for the specified key using available heuristics: either the key size is too weak be used with available algorithms, or the key size is unavailable (e.g. if using a PKCS11 or HSM (Hardware Security Module) key store). If you are using a PKCS11 or HSM keystore, consider using the JwtBuilder.signWith(Key, SecureDigestAlgorithm) method instead.";
            throw new UnsupportedKeyException((String)object);
        }
        return object;
    }

    @Override
    public JwtBuilder signWith(Key key) throws InvalidKeyException {
        Assert.notNull(key, "Key argument cannot be null.");
        SecureDigestAlgorithm<Key, ?> secureDigestAlgorithm = DefaultJwtBuilder.forSigningKey(key);
        return this.signWith(key, secureDigestAlgorithm);
    }

    @Override
    public <K extends Key> JwtBuilder signWith(K object, SecureDigestAlgorithm<? super K, ?> secureDigestAlgorithm) throws InvalidKeyException {
        Assert.notNull(object, "Key argument cannot be null.");
        if (object instanceof PublicKey) {
            throw new IllegalArgumentException(PUB_KEY_SIGN_MSG);
        }
        Assert.notNull(secureDigestAlgorithm, "SignatureAlgorithm cannot be null.");
        String string = Assert.hasText(secureDigestAlgorithm.getId(), "SignatureAlgorithm id cannot be null or empty.");
        if (Jwts$SIG.NONE.getId().equalsIgnoreCase(string)) {
            object = "The 'none' JWS algorithm cannot be used to sign JWTs.";
            throw new IllegalArgumentException((String)object);
        }
        this.key = object;
        this.sigAlg = secureDigestAlgorithm;
        this.signFunction = Functions.wrap(new DefaultJwtBuilder$1(this), SignatureException.class, "Unable to compute %s signature.", string);
        return this;
    }

    @Override
    public JwtBuilder signWith(Key key, SignatureAlgorithm signatureAlgorithm) throws InvalidKeyException {
        Assert.notNull(signatureAlgorithm, "SignatureAlgorithm cannot be null.");
        signatureAlgorithm.assertValidSigningKey(key);
        return this.signWith(key, Jwts$SIG.get().forKey(signatureAlgorithm.getValue()));
    }

    @Override
    public JwtBuilder signWith(SignatureAlgorithm signatureAlgorithm, byte[] object) throws InvalidKeyException {
        Assert.notNull(signatureAlgorithm, "SignatureAlgorithm cannot be null.");
        Assert.notEmpty(object, "secret key byte array cannot be null or empty.");
        Assert.isTrue(signatureAlgorithm.isHmac(), "Key bytes may only be specified for HMAC signatures.  If using RSA or Elliptic Curve, use the signWith(SignatureAlgorithm, Key) method instead.");
        object = new SecretKeySpec((byte[])object, signatureAlgorithm.getJcaName());
        return this.signWith((Key)object, signatureAlgorithm);
    }

    @Override
    public JwtBuilder signWith(SignatureAlgorithm signatureAlgorithm, String object) throws InvalidKeyException {
        Assert.hasText(object, "base64-encoded secret key cannot be null or empty.");
        Assert.isTrue(signatureAlgorithm.isHmac(), "Base64-encoded key bytes may only be specified for HMAC signatures.  If using RSA or Elliptic Curve, use the signWith(SignatureAlgorithm, Key) method instead.");
        object = Decoders.BASE64.decode((CharSequence)object);
        return this.signWith(signatureAlgorithm, (byte[])object);
    }

    @Override
    public JwtBuilder signWith(SignatureAlgorithm signatureAlgorithm, Key key) {
        return this.signWith(key, signatureAlgorithm);
    }

    @Override
    public JwtBuilder encryptWith(SecretKey secretKey, AeadAlgorithm aeadAlgorithm) {
        if (secretKey instanceof Password) {
            return this.encryptWith((Password)secretKey, new Pbes2HsAkwAlgorithm(aeadAlgorithm.getKeyBitLength()), aeadAlgorithm);
        }
        return this.encryptWith(secretKey, Jwts$KEY.DIRECT, aeadAlgorithm);
    }

    @Override
    public <K extends Key> JwtBuilder encryptWith(K object, KeyAlgorithm<? super K, ?> keyAlgorithm, AeadAlgorithm object2) {
        this.enc = Assert.notNull(object2, "Encryption algorithm cannot be null.");
        Assert.hasText(object2.getId(), "Encryption algorithm id cannot be null or empty.");
        Assert.notNull(object, "Encryption key cannot be null.");
        if (object instanceof PrivateKey) {
            throw new IllegalArgumentException(PRIV_KEY_ENC_MSG);
        }
        Assert.notNull(keyAlgorithm, "KeyAlgorithm cannot be null.");
        object2 = Assert.hasText(keyAlgorithm.getId(), "KeyAlgorithm id cannot be null or empty.");
        this.key = object;
        this.keyAlg = keyAlgorithm;
        object = this.keyAlg;
        this.keyAlgFunction = Functions.wrap(new DefaultJwtBuilder$2(this, (KeyAlgorithm)object), SecurityException.class, "Unable to obtain content encryption key from key management algorithm '%s'.", object2);
        return this;
    }

    @Override
    public JwtBuilder compressWith(CompressionAlgorithm compressionAlgorithm) {
        Assert.notNull(compressionAlgorithm, "CompressionAlgorithm cannot be null");
        Assert.hasText(compressionAlgorithm.getId(), "CompressionAlgorithm id cannot be null or empty.");
        this.compressionAlgorithm = compressionAlgorithm;
        return (JwtBuilder)((JwtBuilder$BuilderHeader)this.header().delete(DefaultHeader.COMPRESSION_ALGORITHM.getId())).and();
    }

    @Override
    public JwtBuilder setPayload(String string) {
        return this.content(string);
    }

    @Override
    public JwtBuilder content(String string) {
        if (Strings.hasText(string)) {
            this.payload = new Payload(string, null);
        }
        return this;
    }

    @Override
    public JwtBuilder content(byte[] byArray) {
        if (!Bytes.isEmpty(byArray)) {
            this.payload = new Payload(byArray, null);
        }
        return this;
    }

    @Override
    public JwtBuilder content(InputStream inputStream) {
        if (inputStream != null) {
            this.payload = new Payload(inputStream, null);
        }
        return this;
    }

    @Override
    public JwtBuilder content(byte[] byArray, String string) {
        Assert.notEmpty(byArray, "content byte array cannot be null or empty.");
        Assert.hasText(string, "Content Type String cannot be null or empty.");
        this.payload = new Payload(byArray, string);
        return (JwtBuilder)((JwtBuilder$BuilderHeader)this.header().delete(DefaultHeader.CONTENT_TYPE.getId())).and();
    }

    @Override
    public JwtBuilder content(String string, String string2) throws IllegalArgumentException {
        Assert.hasText(string, "Content string cannot be null or empty.");
        Assert.hasText(string2, "ContentType string cannot be null or empty.");
        this.payload = new Payload(string, string2);
        return (JwtBuilder)((JwtBuilder$BuilderHeader)this.header().delete(DefaultHeader.CONTENT_TYPE.getId())).and();
    }

    @Override
    public JwtBuilder content(InputStream inputStream, String string) throws IllegalArgumentException {
        Assert.notNull(inputStream, "Payload InputStream cannot be null.");
        Assert.hasText(string, "ContentType string cannot be null or empty.");
        this.payload = new Payload(inputStream, string);
        return (JwtBuilder)((JwtBuilder$BuilderHeader)this.header().delete(DefaultHeader.CONTENT_TYPE.getId())).and();
    }

    @Override
    public JwtBuilder setClaims(Map<String, ?> map) {
        Assert.notNull(map, "Claims map cannot be null.");
        return (JwtBuilder)((JwtBuilder$BuilderClaims)((JwtBuilder$BuilderClaims)this.claims().empty()).add(map)).and();
    }

    @Override
    public JwtBuilder addClaims(Map<String, ?> map) {
        return this.claims(map);
    }

    @Override
    public JwtBuilder claims(Map<String, ?> map) {
        return (JwtBuilder)((JwtBuilder$BuilderClaims)this.claims().add(map)).and();
    }

    @Override
    public JwtBuilder claim(String string, Object object) {
        return (JwtBuilder)((JwtBuilder$BuilderClaims)this.claims().add(string, object)).and();
    }

    @Override
    public JwtBuilder setIssuer(String string) {
        return this.issuer(string);
    }

    @Override
    public JwtBuilder issuer(String string) {
        return (JwtBuilder)((JwtBuilder$BuilderClaims)this.claims().issuer(string)).and();
    }

    @Override
    public JwtBuilder setSubject(String string) {
        return this.subject(string);
    }

    @Override
    public JwtBuilder subject(String string) {
        return (JwtBuilder)((JwtBuilder$BuilderClaims)this.claims().subject(string)).and();
    }

    @Override
    public JwtBuilder setAudience(String string) {
        return (JwtBuilder)((JwtBuilder$BuilderClaims)this.claims().setAudience(string)).and();
    }

    @Override
    public ClaimsMutator$AudienceCollection<JwtBuilder> audience() {
        DefaultJwtBuilder defaultJwtBuilder = this;
        return new DelegateAudienceCollection<JwtBuilder>(defaultJwtBuilder, defaultJwtBuilder.claims().audience());
    }

    @Override
    public JwtBuilder setExpiration(Date date) {
        return this.expiration(date);
    }

    @Override
    public JwtBuilder expiration(Date date) {
        return (JwtBuilder)((JwtBuilder$BuilderClaims)this.claims().expiration(date)).and();
    }

    @Override
    public JwtBuilder setNotBefore(Date date) {
        return this.notBefore(date);
    }

    @Override
    public JwtBuilder notBefore(Date date) {
        return (JwtBuilder)((JwtBuilder$BuilderClaims)this.claims().notBefore(date)).and();
    }

    @Override
    public JwtBuilder setIssuedAt(Date date) {
        return this.issuedAt(date);
    }

    @Override
    public JwtBuilder issuedAt(Date date) {
        return (JwtBuilder)((JwtBuilder$BuilderClaims)this.claims().issuedAt(date)).and();
    }

    @Override
    public JwtBuilder setId(String string) {
        return this.id(string);
    }

    @Override
    public JwtBuilder id(String string) {
        return (JwtBuilder)((JwtBuilder$BuilderClaims)this.claims().id(string)).and();
    }

    private void assertPayloadEncoding(String string) {
        if (!this.encodePayload) {
            string = "Payload encoding may not be disabled for " + string + "s, only JWSs.";
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public String compact() {
        boolean bl2 = this.enc != null;
        if (bl2 && this.signFunction != null) {
            String string = "Both 'signWith' and 'encryptWith' cannot be specified. Choose either one.";
            throw new IllegalStateException(string);
        }
        Payload payload = Assert.stateNotNull(this.payload, "Payload instance null, internal error");
        Object object = DefaultJwtBuilder$DefaultBuilderClaims.access$400(this.claimsBuilder);
        if (bl2 && payload.isEmpty() && Collections.isEmpty(object)) {
            object = "Encrypted JWTs must have either 'claims' or non-empty 'content'.";
            throw new IllegalStateException((String)object);
        }
        if (!payload.isEmpty() && !Collections.isEmpty(object)) {
            throw new IllegalStateException("Both 'content' and 'claims' cannot be specified. Choose either one.");
        }
        if (this.serializer == null) {
            this.json(Services.get(Serializer.class));
        }
        if (!Collections.isEmpty(object)) {
            payload = new Payload((Claims)object);
        }
        if (this.compressionAlgorithm != null && !payload.isEmpty()) {
            payload.setZip(this.compressionAlgorithm);
            this.headerBuilder.put(DefaultHeader.COMPRESSION_ALGORITHM.getId(), this.compressionAlgorithm.getId());
        }
        if (Strings.hasText(payload.getContentType())) {
            this.headerBuilder.contentType(payload.getContentType());
        }
        object = ProviderKey.getProvider(this.key, this.provider);
        Key key = ProviderKey.getKey(this.key);
        if (bl2) {
            return this.encrypt(payload, key, (Provider)object);
        }
        if (key != null) {
            return this.sign(payload, key, (Provider)object);
        }
        return this.unprotected(payload);
    }

    private void writeAndClose(String object, Map<String, ?> map, OutputStream outputStream) {
        try {
            object = new NamedSerializer((String)object, this.serializer);
            object.serialize(map, outputStream);
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(outputStream);
            throw throwable;
        }
        Objects.nullSafeClose(outputStream);
    }

    private void writeAndClose(String object, Payload payload, OutputStream outputStream) {
        outputStream = payload.compress(outputStream);
        if (payload.isClaims()) {
            this.writeAndClose((String)object, payload.getRequiredClaims(), outputStream);
            return;
        }
        try {
            object = payload.toInputStream();
            Streams.copy((InputStream)object, outputStream, new byte[4096], "Unable to copy payload.");
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(outputStream);
            throw throwable;
        }
        Objects.nullSafeClose(outputStream);
    }

    private String sign(Payload object, Key object2, Provider provider) {
        Object object3;
        Assert.stateNotNull(object2, "Key is required.");
        Assert.stateNotNull(this.sigAlg, "SignatureAlgorithm is required.");
        Assert.stateNotNull(this.signFunction, "Signature Algorithm function cannot be null.");
        Assert.stateNotNull(object, "Payload argument cannot be null.");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        this.headerBuilder.add(DefaultHeader.ALGORITHM.getId(), this.sigAlg.getId());
        if (!this.encodePayload) {
            object3 = DefaultJwsHeader.B64.getId();
            ((JwtBuilder$BuilderHeader)((NestedCollection)this.headerBuilder.critical().add((String)object3)).and()).add(object3, Boolean.FALSE);
        }
        object3 = Assert.isInstanceOf(JwsHeader.class, DefaultJwtBuilder$DefaultBuilderHeader.access$500(this.headerBuilder));
        this.encodeAndWrite("JWS Protected Header", (Map<String, ?>)object3, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.write(46);
        InputStream inputStream = null;
        if (this.encodePayload) {
            this.encodeAndWrite("JWS Payload", (Payload)object, (OutputStream)byteArrayOutputStream);
            object3 = Streams.of(byteArrayOutputStream.toByteArray());
        } else {
            object3 = Streams.of(byteArrayOutputStream.toByteArray());
            inputStream = this.toInputStream("JWS Unencoded Payload", (Payload)object);
            if (!((Payload)object).isClaims()) {
                inputStream = new CountingInputStream(inputStream);
            }
            if (inputStream.markSupported()) {
                inputStream.mark(0);
            }
            object3 = new SequenceInputStream((InputStream)object3, new UncloseableInputStream(inputStream));
        }
        try {
            object2 = new DefaultSecureRequest<Object, Key>(object3, provider, this.secureRandom, (Key)object2);
            object3 = this.signFunction.apply((SecureRequest<InputStream, Key>)object2);
            if (!this.encodePayload) {
                if (!((Payload)object).isCompressed() && (((Payload)object).isClaims() || ((Payload)object).isString())) {
                    Streams.copy(inputStream, byteArrayOutputStream, new byte[8192], "Unable to copy attached Payload InputStream.");
                }
                if (inputStream instanceof CountingInputStream && ((CountingInputStream)inputStream).getCount() <= 0L) {
                    object = "'b64' Unencoded payload option has been specified, but payload is empty.";
                    throw new IllegalStateException((String)object);
                }
            }
        }
        finally {
            Streams.reset(inputStream);
        }
        byteArrayOutputStream.write(46);
        this.encodeAndWrite("JWS Signature", (byte[])object3, (OutputStream)byteArrayOutputStream);
        return Strings.utf8(byteArrayOutputStream.toByteArray());
    }

    private String unprotected(Payload payload) {
        Assert.stateNotNull(payload, "Content argument cannot be null.");
        this.assertPayloadEncoding("unprotected JWT");
        this.headerBuilder.add(DefaultHeader.ALGORITHM.getId(), Jwts$SIG.NONE.getId());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        Header header = DefaultJwtBuilder$DefaultBuilderHeader.access$500(this.headerBuilder);
        this.encodeAndWrite("JWT Header", header, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.write(46);
        this.encodeAndWrite("JWT Payload", payload, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.write(46);
        return Strings.ascii(byteArrayOutputStream.toByteArray());
    }

    private void encrypt(AeadRequest object, AeadResult aeadResult) throws SecurityException {
        object = Functions.wrap(new DefaultJwtBuilder$3(this, (AeadRequest)object, aeadResult), SecurityException.class, "%s encryption failed.", this.enc.getId());
        object.apply(null);
    }

    private String encrypt(Payload object, Key object2, Provider object3) {
        Assert.stateNotNull(object, "Payload argument cannot be null.");
        Assert.stateNotNull(object2, "Key is required.");
        Assert.stateNotNull(this.enc, "Encryption algorithm is required.");
        Assert.stateNotNull(this.keyAlg, "KeyAlgorithm is required.");
        Assert.stateNotNull(this.keyAlgFunction, "KeyAlgorithm function cannot be null.");
        this.assertPayloadEncoding("JWE");
        object = this.toInputStream("JWE Payload", (Payload)object);
        Object object4 = new DefaultMutableJweHeader(this.headerBuilder);
        object2 = new DefaultKeyRequest<Key>((Key)object2, (Provider)object3, this.secureRandom, (JweHeader)object4, this.enc);
        object2 = this.keyAlgFunction.apply((KeyRequest<Key>)object2);
        Assert.stateNotNull(object2, "KeyAlgorithm must return a KeyResult.");
        object3 = (SecretKey)Assert.notNull(object2.getKey(), "KeyResult must return a content encryption key.");
        object2 = (byte[])Assert.notNull(object2.getPayload(), "KeyResult must return an encrypted key byte array, even if empty.");
        this.headerBuilder.add(DefaultHeader.ALGORITHM.getId(), this.keyAlg.getId());
        this.headerBuilder.put(DefaultJweHeader.ENCRYPTION_ALGORITHM.getId(), this.enc.getId());
        object4 = Assert.isInstanceOf(JweHeader.class, DefaultJwtBuilder$DefaultBuilderHeader.access$500(this.headerBuilder), "Invalid header created: ");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        this.encodeAndWrite("JWE Protected Header", (Map<String, ?>)object4, (OutputStream)byteArrayOutputStream);
        object4 = Streams.of(byteArrayOutputStream.toByteArray());
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(8192);
        object = new DefaultAeadRequest((InputStream)object, null, this.secureRandom, (SecretKey)object3, (InputStream)object4);
        object3 = new DefaultAeadResult(byteArrayOutputStream2);
        this.encrypt((AeadRequest)object, (AeadResult)object3);
        object = Assert.notEmpty(((DefaultAeadResult)object3).getIv(), "Encryption result must have a non-empty initialization vector.");
        object3 = Assert.notEmpty(((DefaultAeadResult)object3).getDigest(), "Encryption result must have a non-empty authentication tag.");
        object4 = Assert.notEmpty(byteArrayOutputStream2.toByteArray(), "Encryption result must have non-empty ciphertext.");
        byteArrayOutputStream.write(46);
        this.encodeAndWrite("JWE Encrypted CEK", (byte[])object2, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.write(46);
        this.encodeAndWrite("JWE Initialization Vector", (byte[])object, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.write(46);
        this.encodeAndWrite("JWE Ciphertext", (byte[])object4, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.write(46);
        this.encodeAndWrite("JWE AAD Tag", (byte[])object3, (OutputStream)byteArrayOutputStream);
        return Strings.utf8(byteArrayOutputStream.toByteArray());
    }

    private OutputStream encode(OutputStream outputStream, String string) {
        outputStream = this.encoder.encode(outputStream);
        return new EncodingOutputStream(outputStream, "base64url", string);
    }

    private void encodeAndWrite(String string, Map<String, ?> map, OutputStream outputStream) {
        outputStream = this.encode(outputStream, string);
        this.writeAndClose(string, map, outputStream);
    }

    private void encodeAndWrite(String string, Payload payload, OutputStream outputStream) {
        outputStream = this.encode(outputStream, string);
        this.writeAndClose(string, payload, outputStream);
    }

    private void encodeAndWrite(String string, byte[] byArray, OutputStream outputStream) {
        outputStream = this.encode(outputStream, string);
        Streams.writeAndClose(outputStream, byArray, "Unable to write bytes");
    }

    private InputStream toInputStream(String string, Payload payload) {
        if (payload.isClaims() || payload.isCompressed()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            this.writeAndClose(string, payload, (OutputStream)byteArrayOutputStream);
            return Streams.of(byteArrayOutputStream.toByteArray());
        }
        return Assert.stateNotNull(payload.toInputStream(), "Payload InputStream cannot be null.");
    }

    static /* synthetic */ SecureDigestAlgorithm access$300(DefaultJwtBuilder defaultJwtBuilder) {
        return defaultJwtBuilder.sigAlg;
    }

    static /* synthetic */ AeadAlgorithm access$600(DefaultJwtBuilder defaultJwtBuilder) {
        return defaultJwtBuilder.enc;
    }
}

