/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ClaimsBuilder;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.CompressionCodecResolver;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.Jwe;
import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtHandler;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Jwts$SIG;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.MissingClaimException;
import io.jsonwebtoken.PrematureJwtException;
import io.jsonwebtoken.ProtectedHeader;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.CompressionCodecLocator;
import io.jsonwebtoken.impl.DefaultClaims;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.DefaultJwe;
import io.jsonwebtoken.impl.DefaultJweHeader;
import io.jsonwebtoken.impl.DefaultJws;
import io.jsonwebtoken.impl.DefaultJwsHeader;
import io.jsonwebtoken.impl.DefaultJwt;
import io.jsonwebtoken.impl.DefaultProtectedHeader;
import io.jsonwebtoken.impl.IdLocator;
import io.jsonwebtoken.impl.JwtTokenizer;
import io.jsonwebtoken.impl.Payload;
import io.jsonwebtoken.impl.TokenizedJwe;
import io.jsonwebtoken.impl.TokenizedJwt;
import io.jsonwebtoken.impl.io.AbstractParser;
import io.jsonwebtoken.impl.io.BytesInputStream;
import io.jsonwebtoken.impl.io.CharSequenceReader;
import io.jsonwebtoken.impl.io.JsonObjectDeserializer;
import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.io.UncloseableInputStream;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.security.DefaultDecryptAeadRequest;
import io.jsonwebtoken.impl.security.DefaultDecryptionKeyRequest;
import io.jsonwebtoken.impl.security.DefaultVerifySecureDigestRequest;
import io.jsonwebtoken.impl.security.LocatingKeyResolver;
import io.jsonwebtoken.impl.security.ProviderKey;
import io.jsonwebtoken.io.CompressionAlgorithm;
import io.jsonwebtoken.io.Decoder;
import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.DateFormats;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.AeadAlgorithm;
import io.jsonwebtoken.security.DecryptAeadRequest;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeyAlgorithm;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.WeakKeyException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;

public class DefaultJwtParser
extends AbstractParser<Jwt<?, ?>>
implements JwtParser {
    static final char SEPARATOR_CHAR = '.';
    private static final JwtTokenizer jwtTokenizer = new JwtTokenizer();
    static final String PRIV_KEY_VERIFY_MSG = "PrivateKeys may not be used to verify digital signatures. PrivateKeys are used to sign, and PublicKeys are used to verify.";
    static final String PUB_KEY_DECRYPT_MSG = "PublicKeys may not be used to decrypt data. PublicKeys are used to encrypt, and PrivateKeys are used to decrypt.";
    public static final String INCORRECT_EXPECTED_CLAIM_MESSAGE_TEMPLATE = "Expected %s claim to be: %s, but was: %s.";
    public static final String MISSING_EXPECTED_CLAIM_VALUE_MESSAGE_TEMPLATE = "Missing expected '%s' value in '%s' claim %s.";
    public static final String MISSING_JWS_ALG_MSG = "JWS header does not contain a required 'alg' (Algorithm) header parameter.  This header parameter is mandatory per the JWS Specification, Section 4.1.1. See https://www.rfc-editor.org/rfc/rfc7515.html#section-4.1.1 for more information.";
    public static final String MISSING_JWE_ALG_MSG = "JWE header does not contain a required 'alg' (Algorithm) header parameter.  This header parameter is mandatory per the JWE Specification, Section 4.1.1. See https://www.rfc-editor.org/rfc/rfc7516.html#section-4.1.1 for more information.";
    public static final String MISSING_JWS_DIGEST_MSG_FMT = "The JWS header references signature algorithm '%s' but the compact JWE string is missing the required signature.";
    public static final String MISSING_JWE_DIGEST_MSG_FMT = "The JWE header references key management algorithm '%s' but the compact JWE string is missing the required AAD authentication tag.";
    private static final String MISSING_ENC_MSG = "JWE header does not contain a required 'enc' (Encryption Algorithm) header parameter.  This header parameter is mandatory per the JWE Specification, Section 4.1.2. See https://www.rfc-editor.org/rfc/rfc7516.html#section-4.1.2 for more information.";
    private static final String UNSECURED_DISABLED_MSG_PREFIX = "Unsecured JWSs (those with an " + DefaultHeader.ALGORITHM + " header value of '" + Jwts$SIG.NONE.getId() + "') are disallowed by default as mandated by https://www.rfc-editor.org/rfc/rfc7518.html#section-3.6. If you wish to " + "allow them to be parsed, call the JwtParserBuilder.unsecured() method, but please read the security considerations covered in that method's JavaDoc before doing so. Header: ";
    private static final String CRIT_UNSECURED_MSG = "Unsecured JWSs (those with an " + DefaultHeader.ALGORITHM + " header value of '" + Jwts$SIG.NONE.getId() + "') may not use the " + DefaultProtectedHeader.CRIT + " header parameter per https://www.rfc-editor.org/rfc/rfc7515.html#section-4.1.11 (\"the [crit] Header Parameter MUST be integrity protected; therefore, it MUST occur only within [a] JWS Protected Header)\"." + " Header: %s";
    private static final String CRIT_MISSING_MSG = "Protected Header " + DefaultProtectedHeader.CRIT + " set references header name '%s', but the header does not contain an associated '%s' header parameter as required by " + "https://www.rfc-editor.org/rfc/rfc7515.html#section-4.1.11. Header: %s";
    private static final String CRIT_UNSUPPORTED_MSG = "Protected Header " + DefaultProtectedHeader.CRIT + " set references unsupported header name '%s'. Application developers expecting to support a JWT extension using header '%s' in their application code must indicate it " + "is supported by using the JwtParserBuilder.critical method. Header: %s";
    private static final String JWE_NONE_MSG = "JWEs do not support key management " + DefaultHeader.ALGORITHM + " header value '" + Jwts$SIG.NONE.getId() + "' per https://www.rfc-editor.org/rfc/rfc7518.html#section-4.1";
    private static final String JWS_NONE_SIG_MISMATCH_MSG = "The JWS header references signature algorithm '" + Jwts$SIG.NONE.getId() + "' yet the compact JWS string contains a signature. This is not permitted per https://tools.ietf.org/html/rfc7518#section-3.6.";
    private static final String B64_MISSING_PAYLOAD = "Unable to verify JWS signature: the parser has encountered an Unencoded Payload JWS with detached payload, but the detached payload value required for signature verification has not been provided. If you expect to receive and parse Unencoded Payload JWSs in your application, the overloaded JwtParser.parseSignedContent or JwtParser.parseSignedClaims methods that accept a byte[] or InputStream must be used for these kinds of JWSs. Header: %s";
    private static final String B64_DECOMPRESSION_MSG = "The JWT header references compression algorithm '%s', but payload decompression for Unencoded JWSs (those with an " + DefaultJwsHeader.B64 + " header value of false) that rely on a SigningKeyResolver are disallowed by default to protect against [Denial of Service attacks](" + "https://www.usenix.org/system/files/conference/usenixsecurity15/sec15-paper-pellegrino.pdf).  If you wish to enable Unencoded JWS payload decompression, configure the JwtParserBuilder." + "keyLocator(Locator) and do not configure a SigningKeyResolver.";
    private static final String UNPROTECTED_DECOMPRESSION_MSG = "The JWT header references compression algorithm '%s', but payload decompression for Unprotected JWTs (those with an " + DefaultHeader.ALGORITHM + " header value of '" + Jwts$SIG.NONE.getId() + "') or Unencoded JWSs (those with a " + DefaultJwsHeader.B64 + " header value of false) that also rely on a SigningKeyResolver are disallowed by default to protect against [Denial of Service attacks](" + "https://www.usenix.org/system/files/conference/usenixsecurity15/sec15-paper-pellegrino.pdf).  If you wish to enable Unsecure JWS or Unencoded JWS payload decompression, call the JwtParserBuilder." + "unsecuredDecompression() method, but please read the security considerations covered in that method's JavaDoc before doing so.";
    private final Provider provider;
    private final SigningKeyResolver signingKeyResolver;
    private final boolean unsecured;
    private final boolean unsecuredDecompression;
    private final Function<JwsHeader, SecureDigestAlgorithm<?, ?>> sigAlgs;
    private final Function<JweHeader, AeadAlgorithm> encAlgs;
    private final Function<JweHeader, KeyAlgorithm<?, ?>> keyAlgs;
    private final Function<Header, CompressionAlgorithm> zipAlgs;
    private final Locator<? extends Key> keyLocator;
    private final Decoder<InputStream, InputStream> decoder;
    private final Deserializer<Map<String, ?>> deserializer;
    private final ClaimsBuilder expectedClaims;
    private final Clock clock;
    private final Set<String> critical;
    private final long allowedClockSkewMillis;

    DefaultJwtParser(Provider provider, SigningKeyResolver signingKeyResolver, boolean bl2, boolean bl3, Locator<? extends Key> locator, Clock clock, Set<String> set, long l2, DefaultClaims defaultClaims, Decoder<InputStream, InputStream> decoder, Deserializer<Map<String, ?>> deserializer, CompressionCodecResolver compressionCodecResolver, Registry<String, CompressionAlgorithm> registry, Registry<String, SecureDigestAlgorithm<?, ?>> registry2, Registry<String, KeyAlgorithm<?, ?>> registry3, Registry<String, AeadAlgorithm> registry4) {
        this.provider = provider;
        this.unsecured = bl2;
        this.unsecuredDecompression = bl3;
        this.signingKeyResolver = signingKeyResolver;
        this.keyLocator = Assert.notNull(locator, "Key Locator cannot be null.");
        this.clock = Assert.notNull(clock, "Clock cannot be null.");
        this.critical = Collections.nullSafe(set);
        this.allowedClockSkewMillis = l2;
        this.expectedClaims = (ClaimsBuilder)Jwts.claims().add(defaultClaims);
        this.decoder = Assert.notNull(decoder, "base64UrlDecoder cannot be null.");
        this.deserializer = Assert.notNull(deserializer, "JSON Deserializer cannot be null.");
        this.sigAlgs = new IdLocator(DefaultHeader.ALGORITHM, registry2, "mac or signature", "signature verification", MISSING_JWS_ALG_MSG);
        this.keyAlgs = new IdLocator(DefaultHeader.ALGORITHM, registry3, "key management", "decryption", MISSING_JWE_ALG_MSG);
        this.encAlgs = new IdLocator<JweHeader, AeadAlgorithm>(DefaultJweHeader.ENCRYPTION_ALGORITHM, registry4, "encryption", "decryption", MISSING_ENC_MSG);
        this.zipAlgs = compressionCodecResolver != null ? new CompressionCodecLocator(compressionCodecResolver) : new IdLocator(DefaultHeader.COMPRESSION_ALGORITHM, registry, "compression", "decompression", null);
    }

    @Override
    public boolean isSigned(CharSequence charSequence) {
        if (!Strings.hasText(charSequence)) {
            return false;
        }
        try {
            charSequence = jwtTokenizer.tokenize(new CharSequenceReader(charSequence));
            return !(charSequence instanceof TokenizedJwe) && Strings.hasText(charSequence.getDigest());
        }
        catch (MalformedJwtException malformedJwtException) {
            return false;
        }
    }

    private static boolean hasContentType(Header header) {
        return header != null && Strings.hasText(header.getContentType());
    }

    private byte[] verifySignature(TokenizedJwt object, JwsHeader defaultVerifySecureDigestRequest, String object2, SigningKeyResolver object3, Claims object4, Payload payload) {
        Object object5;
        SecureDigestAlgorithm<?, ?> secureDigestAlgorithm;
        Assert.notNull(object3, "SigningKeyResolver instance cannot be null.");
        try {
            secureDigestAlgorithm = this.sigAlgs.apply((JwsHeader)((Object)defaultVerifySecureDigestRequest));
        }
        catch (UnsupportedJwtException unsupportedJwtException) {
            object2 = "Unsupported signature algorithm '" + (String)object2 + "': " + unsupportedJwtException.getMessage();
            throw new SignatureException((String)object2, unsupportedJwtException);
        }
        Assert.stateNotNull(secureDigestAlgorithm, "JWS Signature Algorithm cannot be null.");
        object3 = object4 != null ? object3.resolveSigningKey((JwsHeader)((Object)defaultVerifySecureDigestRequest), (Claims)object4) : object3.resolveSigningKey((JwsHeader)((Object)defaultVerifySecureDigestRequest), payload.getBytes());
        if (object3 == null) {
            object2 = "Cannot verify JWS signature: unable to locate signature verification key for JWS with header: " + defaultVerifySecureDigestRequest;
            throw new UnsupportedJwtException((String)object2);
        }
        object2 = ProviderKey.getProvider((Key)object3, this.provider);
        object3 = ProviderKey.getKey(object3);
        Assert.stateNotNull(object3, "ProviderKey cannot be null.");
        if (object3 instanceof PrivateKey) {
            throw new InvalidKeyException(PRIV_KEY_VERIFY_MSG);
        }
        object4 = this.decode(object.getDigest(), "JWS signature");
        InputStream inputStream = null;
        if (defaultVerifySecureDigestRequest.isPayloadEncoded()) {
            int n2 = object.getProtected().length() + 1 + object.getPayload().length();
            object5 = CharBuffer.allocate(n2);
            ((CharBuffer)object5).put(Strings.wrap(object.getProtected()));
            ((CharBuffer)object5).put('.');
            ((CharBuffer)object5).put(Strings.wrap(object.getPayload()));
            ((CharBuffer)object5).rewind();
            object = StandardCharsets.US_ASCII.encode((CharBuffer)object5);
            ((ByteBuffer)object).rewind();
            defaultVerifySecureDigestRequest = (DefaultVerifySecureDigestRequest<Object>)new byte[((Buffer)object).remaining()];
            ((ByteBuffer)object).get((byte[])defaultVerifySecureDigestRequest);
            object = Streams.of((byte[])defaultVerifySecureDigestRequest);
        } else {
            defaultVerifySecureDigestRequest = StandardCharsets.US_ASCII.encode(Strings.wrap(object.getProtected()));
            ((ByteBuffer)((Object)defaultVerifySecureDigestRequest)).rewind();
            object5 = ByteBuffer.allocate(((Buffer)((Object)defaultVerifySecureDigestRequest)).remaining() + 1);
            ((ByteBuffer)object5).put((ByteBuffer)((Object)defaultVerifySecureDigestRequest));
            ((ByteBuffer)object5).put((byte)46);
            ((ByteBuffer)object5).rewind();
            object = new byte[((Buffer)object5).remaining()];
            ((ByteBuffer)object5).get((byte[])object);
            defaultVerifySecureDigestRequest = Streams.of((byte[])object);
            inputStream = payload.toInputStream();
            object = new SequenceInputStream((InputStream)((Object)defaultVerifySecureDigestRequest), new UncloseableInputStream(inputStream));
        }
        try {
            defaultVerifySecureDigestRequest = new DefaultVerifySecureDigestRequest<Object>((InputStream)object, (Provider)object2, null, object3, (byte[])object4);
            if (!secureDigestAlgorithm.verify(defaultVerifySecureDigestRequest)) {
                object5 = "JWT signature does not match locally computed signature. JWT validity cannot be asserted and should not be trusted.";
                throw new SignatureException((String)object5);
            }
        }
        catch (WeakKeyException weakKeyException) {
            defaultVerifySecureDigestRequest = weakKeyException;
            throw weakKeyException;
        }
        catch (InvalidKeyException | IllegalArgumentException runtimeException) {
            object5 = secureDigestAlgorithm.getId();
            object = "The parsed JWT indicates it was signed with the '" + (String)object5 + "' signature algorithm, but the provided " + object3.getClass().getName() + " key may not be used to verify " + (String)object5 + " signatures.  Because the specified key reflects a specific and expected algorithm, and the JWT does not reflect " + "this algorithm, it is likely that the JWT was not expected and therefore should not be trusted.  Another possibility is that the parser was provided the incorrect " + "signature verification key, but this cannot be assumed for security reasons.";
            throw new UnsupportedJwtException((String)object, runtimeException);
        }
        finally {
            Streams.reset(inputStream);
        }
        return object4;
    }

    @Override
    public Jwt<?, ?> parse(Reader reader) {
        Assert.notNull(reader, "Reader cannot be null.");
        return this.parse(reader, Payload.EMPTY);
    }

    private Jwt<?, ?> parse(Reader object, Payload object2) {
        boolean bl2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        DefaultJws<byte[]> defaultJws;
        Object object7;
        Object object8;
        Object object9;
        Assert.notNull(object, "Compact reader cannot be null.");
        Assert.stateNotNull(object2, "internal error: unencodedPayload is null.");
        object = jwtTokenizer.tokenize((Reader)object);
        Object object10 = object.getProtected();
        if (!Strings.hasText((CharSequence)object10)) {
            String string = "Compact JWT strings MUST always have a Base64Url protected header per https://tools.ietf.org/html/rfc7519#section-7.2 (steps 2-4).";
            throw new MalformedJwtException(string);
        }
        Object object11 = this.decode((CharSequence)object10, "protected header");
        object11 = this.deserialize(Streams.of((byte[])object11), "protected header");
        try {
            object11 = object.createHeader((Map<String, ?>)object11);
        }
        catch (Exception exception) {
            String string = "Invalid protected header: " + exception.getMessage();
            throw new MalformedJwtException(string, exception);
        }
        String string = Strings.clean(object11.getAlgorithm());
        if (!Strings.hasText(string)) {
            String string2 = object instanceof TokenizedJwe ? MISSING_JWE_ALG_MSG : MISSING_JWS_ALG_MSG;
            throw new MalformedJwtException(string2);
        }
        boolean bl3 = Jwts$SIG.NONE.getId().equalsIgnoreCase(string);
        CharSequence charSequence = object.getDigest();
        boolean bl4 = Strings.hasText(charSequence);
        if (bl3) {
            if (object instanceof TokenizedJwe) {
                throw new MalformedJwtException(JWE_NONE_MSG);
            }
            if (!this.unsecured) {
                String string3 = UNSECURED_DISABLED_MSG_PREFIX + object11;
                throw new UnsupportedJwtException(string3);
            }
            if (bl4) {
                throw new MalformedJwtException(JWS_NONE_SIG_MISMATCH_MSG);
            }
            if (object11.containsKey(DefaultProtectedHeader.CRIT.getId())) {
                String string4 = String.format(CRIT_UNSECURED_MSG, object11);
                throw new MalformedJwtException(string4);
            }
        } else if (!bl4) {
            String string5 = object instanceof TokenizedJwe ? MISSING_JWE_DIGEST_MSG_FMT : MISSING_JWS_DIGEST_MSG_FMT;
            String string6 = String.format(string5, string);
            throw new MalformedJwtException(string6);
        }
        if (object11 instanceof ProtectedHeader) {
            Object object12 = Collections.nullSafe(((ProtectedHeader)object11).getCritical());
            object9 = this.critical;
            String string7 = DefaultJwsHeader.B64.getId();
            if (!((Payload)object2).isEmpty() && !this.critical.contains(string7)) {
                object9 = new LinkedHashSet<String>(Collections.size(this.critical) + 1);
                object9.add(DefaultJwsHeader.B64.getId());
                object9.addAll(this.critical);
            }
            Iterator<String> iterator = object12.iterator();
            while (iterator.hasNext()) {
                object12 = iterator.next();
                if (!object11.containsKey(object12)) {
                    object2 = String.format(CRIT_MISSING_MSG, object12, object12, object11);
                    throw new MalformedJwtException((String)object2);
                }
                if (object9.contains(object12)) continue;
                object2 = String.format(CRIT_UNSUPPORTED_MSG, object12, object12, object11);
                throw new UnsupportedJwtException((String)object2);
            }
        }
        Object object13 = object.getPayload();
        boolean bl5 = false;
        boolean bl6 = !(object11 instanceof JwsHeader) || ((JwsHeader)object11).isPayloadEncoded();
        if (bl6) {
            object13 = this.decode((CharSequence)object13, "payload");
            object9 = new Payload((byte[])object13, object11.getContentType());
        } else if (Strings.hasText((CharSequence)object13)) {
            object9 = new Payload((CharSequence)object13, object11.getContentType());
        } else {
            if (((Payload)object2).isEmpty()) {
                object13 = String.format(B64_MISSING_PAYLOAD, object11);
                throw new SignatureException((String)object13);
            }
            object9 = object2;
        }
        if (object instanceof TokenizedJwe && ((Payload)object9).isEmpty()) {
            object13 = "Compact JWE strings MUST always contain a payload (ciphertext).";
            throw new MalformedJwtException((String)object13);
        }
        object13 = null;
        object2 = null;
        if (object instanceof TokenizedJwe) {
            object8 = (TokenizedJwe)object;
            JweHeader jweHeader = Assert.stateIsInstance(JweHeader.class, object11, "Not a JweHeader. ");
            AeadAlgorithm aeadAlgorithm = this.encAlgs.apply(jweHeader);
            object7 = aeadAlgorithm;
            Assert.stateNotNull(aeadAlgorithm, "JWE Encryption Algorithm cannot be null.");
            defaultJws = this.keyAlgs.apply(jweHeader);
            Assert.stateNotNull(defaultJws, "JWE Key Algorithm cannot be null.");
            object6 = Bytes.EMPTY;
            object5 = object8.getEncryptedKey();
            if (Strings.hasText((CharSequence)object5) && Bytes.isEmpty(object6 = this.decode((CharSequence)object5, "JWE encrypted key"))) {
                object2 = "Compact JWE string represents an encrypted key, but the key is empty.";
                throw new MalformedJwtException((String)object2);
            }
            object5 = object8.getIv();
            if (Strings.hasText((CharSequence)object5)) {
                object13 = this.decode((CharSequence)object5, "JWE Initialization Vector");
            }
            if (Bytes.isEmpty((byte[])object13)) {
                object2 = "Compact JWE strings must always contain an Initialization Vector.";
                throw new MalformedJwtException((String)object2);
            }
            object2 = StandardCharsets.US_ASCII.encode(Strings.wrap((CharSequence)object10));
            byte[] byArray = new byte[((Buffer)object2).remaining()];
            ((ByteBuffer)object2).get(byArray);
            InputStream inputStream = Streams.of(byArray);
            object5 = charSequence;
            Assert.hasText(object5, "JWE AAD Authentication Tag cannot be null or empty.");
            byte[] byArray2 = this.decode((CharSequence)object5, "JWE AAD Authentication Tag");
            object2 = byArray2;
            if (Bytes.isEmpty(byArray2)) {
                object10 = "Compact JWE strings must always contain an AAD Authentication Tag.";
                throw new MalformedJwtException((String)object10);
            }
            object10 = this.keyLocator.locate(jweHeader);
            if (object10 == null) {
                String string8 = "Cannot decrypt JWE payload: unable to locate key for JWE with header: " + jweHeader;
                throw new UnsupportedJwtException(string8);
            }
            if (object10 instanceof PublicKey) {
                throw new InvalidKeyException(PUB_KEY_DECRYPT_MSG);
            }
            Provider provider = ProviderKey.getProvider((Key)object10, this.provider);
            DefaultDecryptionKeyRequest<Object> defaultDecryptionKeyRequest = new DefaultDecryptionKeyRequest<Object>((byte[])object6, provider, null, jweHeader, (AeadAlgorithm)object7, object10 = ProviderKey.getKey(object10));
            object4 = defaultJws.getDecryptionKey(defaultDecryptionKeyRequest);
            if (object4 == null) {
                object9 = "The '" + defaultJws.getId() + "' JWE key algorithm did not return a decryption key. Unable to perform '" + object7.getId() + "' decryption.";
                throw new IllegalStateException((String)object9);
            }
            object9 = ((Payload)object9).toInputStream();
            object8 = new ByteArrayOutputStream(8192);
            object3 = new DefaultDecryptAeadRequest((InputStream)object9, (SecretKey)object4, inputStream, (byte[])object13, (byte[])object2);
            object7.decrypt((DecryptAeadRequest)object3, (OutputStream)object8);
            object9 = new Payload(((ByteArrayOutputStream)object8).toByteArray(), object11.getContentType());
            bl5 = true;
        } else if (bl4 && this.signingKeyResolver == null) {
            object8 = Assert.stateIsInstance(JwsHeader.class, object11, "Not a JwsHeader. ");
            object2 = this.verifySignature((TokenizedJwt)object, (JwsHeader)object8, string, new LocatingKeyResolver(this.keyLocator), null, (Payload)object9);
            bl5 = true;
        }
        object8 = this.zipAlgs.apply((Header)object11);
        if (object8 != null) {
            if (!bl5) {
                if (!bl6) {
                    String string9 = String.format(B64_DECOMPRESSION_MSG, object8.getId());
                    throw new UnsupportedJwtException(string9);
                }
                if (!this.unsecuredDecompression) {
                    String string10 = String.format(UNPROTECTED_DECOMPRESSION_MSG, object8.getId());
                    throw new UnsupportedJwtException(string10);
                }
            }
            object9 = ((Payload)object9).decompress((CompressionAlgorithm)object8);
        }
        Object object14 = null;
        object7 = ((Payload)object9).getBytes();
        if (((Payload)object9).isConsumable()) {
            block58: {
                defaultJws = null;
                try {
                    defaultJws = ((Payload)object9).toInputStream();
                    if (!DefaultJwtParser.hasContentType((Header)object11)) {
                        object6 = null;
                        try {
                            if (!((InputStream)((Object)defaultJws)).markSupported()) {
                                defaultJws = new BufferedInputStream((InputStream)((Object)defaultJws));
                                ((InputStream)((Object)defaultJws)).mark(0);
                            }
                            object6 = this.deserialize(new UncloseableInputStream((InputStream)((Object)defaultJws)), "claims");
                        }
                        catch (MalformedJwtException | DeserializationException jwtException) {
                        }
                        finally {
                            Streams.reset((InputStream)((Object)defaultJws));
                        }
                        if (object6 != null) {
                            try {
                                object14 = new DefaultClaims((Map<String, ?>)object6);
                            }
                            catch (Throwable throwable) {
                                object2 = "Invalid claims: " + throwable.getMessage();
                                throw new MalformedJwtException((String)object2);
                            }
                        }
                    }
                    if (object14 != null) break block58;
                    object7 = Streams.bytes((InputStream)((Object)defaultJws), "Unable to convert payload to byte array.");
                }
                catch (Throwable throwable) {
                    Objects.nullSafeClose(new Closeable[]{defaultJws});
                    throw throwable;
                }
            }
            Objects.nullSafeClose(new Closeable[]{defaultJws});
        }
        if (bl4 && this.signingKeyResolver != null) {
            defaultJws = Assert.stateIsInstance(JwsHeader.class, object11, "Not a JwsHeader. ");
            object2 = this.verifySignature((TokenizedJwt)object, (JwsHeader)((Object)defaultJws), string, this.signingKeyResolver, (Claims)object14, (Payload)object9);
        }
        Object object15 = object6 = object14 != null ? object14 : object7;
        if (object11 instanceof JweHeader) {
            defaultJws = new DefaultJwe<byte[]>((JweHeader)object11, (byte[])object6, (byte[])object13, (byte[])object2);
        } else if (bl4) {
            object5 = Assert.isInstanceOf(JwsHeader.class, object11, "JwsHeader required.");
            defaultJws = new DefaultJws<byte[]>((JwsHeader)object5, (byte[])object6, (byte[])object2, charSequence.toString());
        } else {
            defaultJws = new DefaultJwt<Object, byte[]>(object11, (byte[])object6);
        }
        boolean bl7 = bl2 = this.allowedClockSkewMillis > 0L;
        if (object14 != null) {
            Date date;
            object2 = this.clock.now();
            long l2 = ((Date)object2).getTime();
            object10 = object14.getExpiration();
            if (object10 != null) {
                long l3 = l2 - this.allowedClockSkewMillis;
                object4 = bl2 ? new Date(l3) : object2;
                if (((Date)object4).after((Date)object10)) {
                    object9 = DateFormats.formatIso8601((Date)object10, true);
                    object8 = DateFormats.formatIso8601((Date)object2, true);
                    long l4 = l2 - ((Date)object10).getTime();
                    String string11 = "JWT expired " + l4 + " milliseconds ago at " + (String)object9 + ". Current time: " + (String)object8 + ". Allowed clock skew: " + this.allowedClockSkewMillis + " milliseconds.";
                    throw new ExpiredJwtException((Header)object11, (Claims)object14, string11);
                }
            }
            if ((date = object14.getNotBefore()) != null) {
                long l5 = l2 + this.allowedClockSkewMillis;
                object9 = bl2 ? new Date(l5) : object2;
                if (((Date)object9).before(date)) {
                    object8 = DateFormats.formatIso8601(date, true);
                    object3 = DateFormats.formatIso8601((Date)object2, true);
                    long l6 = date.getTime() - l2;
                    object = "JWT early by " + l6 + " milliseconds before " + (String)object8 + ". Current time: " + (String)object3 + ". Allowed clock skew: " + this.allowedClockSkewMillis + " milliseconds.";
                    throw new PrematureJwtException((Header)object11, (Claims)object14, (String)object);
                }
            }
            this.validateExpectedClaims((Header)object11, (Claims)object14);
        }
        return defaultJws;
    }

    private static Object normalize(Object object) {
        if (object instanceof Integer) {
            object = ((Integer)object).longValue();
        }
        return object;
    }

    private void validateExpectedClaims(Header header, Claims claims) {
        Object object = (Claims)this.expectedClaims.build();
        for (String string : object.keySet()) {
            Object object2;
            Object object3 = DefaultJwtParser.normalize(object.get(string));
            Object object4 = DefaultJwtParser.normalize(claims.get(string));
            if (object3 instanceof Date) {
                try {
                    object4 = claims.get(string, Date.class);
                }
                catch (Exception exception) {
                    object4 = "JWT Claim '" + string + "' was expected to be a Date, but its value cannot be converted to a Date using current heuristics.  Value: " + object4;
                    throw new IncorrectClaimException(header, claims, string, object3, (String)object4);
                }
            }
            if (object4 == null) {
                boolean bl2 = object3 instanceof Collection;
                object4 = "Missing '" + string + "' claim. Expected value";
                object4 = bl2 ? (String)object4 + "s: " + object3 : (String)object4 + ": " + object3;
                throw new MissingClaimException(header, claims, string, object3, (String)object4);
            }
            if (object3 instanceof Collection) {
                object2 = (Collection)object3;
                object4 = object4 instanceof Collection ? (Set<Object>)object4 : Collections.setOf(object4);
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Object e2 = object2.next();
                    if (Collections.contains(object4.iterator(), e2)) continue;
                    object = String.format(MISSING_EXPECTED_CLAIM_VALUE_MESSAGE_TEMPLATE, e2, string, object4);
                    throw new IncorrectClaimException(header, claims, string, object3, (String)object);
                }
                continue;
            }
            if (object3.equals(object4)) continue;
            object2 = String.format(INCORRECT_EXPECTED_CLAIM_MESSAGE_TEMPLATE, string, object3, object4);
            throw new IncorrectClaimException(header, claims, string, object3, (String)object2);
        }
    }

    @Override
    public <T> T parse(CharSequence charSequence, JwtHandler<T> jwtHandler) {
        return this.parse(charSequence, Payload.EMPTY).accept(jwtHandler);
    }

    private Jwt<?, ?> parse(CharSequence charSequence, Payload payload) {
        Assert.hasText(charSequence, "JWT String argument cannot be null or empty.");
        return this.parse(new CharSequenceReader(charSequence), payload);
    }

    @Override
    public Jwt<Header, byte[]> parseContentJwt(CharSequence charSequence) {
        return ((Jwt)this.parse(charSequence)).accept(Jwt.UNSECURED_CONTENT);
    }

    @Override
    public Jwt<Header, Claims> parseClaimsJwt(CharSequence charSequence) {
        return ((Jwt)this.parse(charSequence)).accept(Jwt.UNSECURED_CLAIMS);
    }

    @Override
    public Jws<byte[]> parseContentJws(CharSequence charSequence) {
        return this.parseSignedContent(charSequence);
    }

    @Override
    public Jws<Claims> parseClaimsJws(CharSequence charSequence) {
        return this.parseSignedClaims(charSequence);
    }

    @Override
    public Jwt<Header, byte[]> parseUnsecuredContent(CharSequence charSequence) throws JwtException, IllegalArgumentException {
        return ((Jwt)this.parse(charSequence)).accept(Jwt.UNSECURED_CONTENT);
    }

    @Override
    public Jwt<Header, Claims> parseUnsecuredClaims(CharSequence charSequence) throws JwtException, IllegalArgumentException {
        return ((Jwt)this.parse(charSequence)).accept(Jwt.UNSECURED_CLAIMS);
    }

    @Override
    public Jws<byte[]> parseSignedContent(CharSequence charSequence) {
        return ((Jwt)this.parse(charSequence)).accept(Jws.CONTENT);
    }

    private Jws<byte[]> parseSignedContent(CharSequence charSequence, Payload payload) {
        return this.parse(charSequence, payload).accept(Jws.CONTENT);
    }

    @Override
    public Jws<Claims> parseSignedClaims(CharSequence charSequence) {
        return ((Jwt)this.parse(charSequence)).accept(Jws.CLAIMS);
    }

    private Jws<Claims> parseSignedClaims(CharSequence charSequence, Payload payload) {
        payload.setClaimsExpected(true);
        return this.parse(charSequence, payload).accept(Jws.CLAIMS);
    }

    @Override
    public Jws<byte[]> parseSignedContent(CharSequence charSequence, byte[] byArray) {
        Assert.notEmpty(byArray, "unencodedPayload argument cannot be null or empty.");
        return this.parseSignedContent(charSequence, new Payload(byArray, null));
    }

    private static Payload payloadFor(InputStream object) {
        if (object instanceof BytesInputStream) {
            object = Streams.bytes((InputStream)object, "Unable to obtain payload InputStream bytes.");
            return new Payload((byte[])object, null);
        }
        return new Payload((InputStream)object, null);
    }

    @Override
    public Jws<byte[]> parseSignedContent(CharSequence charSequence, InputStream inputStream) {
        Assert.notNull(inputStream, "unencodedPayload InputStream cannot be null.");
        return this.parseSignedContent(charSequence, DefaultJwtParser.payloadFor(inputStream));
    }

    @Override
    public Jws<Claims> parseSignedClaims(CharSequence charSequence, byte[] byArray) {
        Assert.notEmpty(byArray, "unencodedPayload argument cannot be null or empty.");
        return this.parseSignedClaims(charSequence, new Payload(byArray, null));
    }

    @Override
    public Jws<Claims> parseSignedClaims(CharSequence charSequence, InputStream object) {
        Assert.notNull(object, "unencodedPayload InputStream cannot be null.");
        object = Streams.bytes((InputStream)object, "Unable to obtain Claims bytes from unencodedPayload InputStream");
        return this.parseSignedClaims(charSequence, new Payload((byte[])object, null));
    }

    @Override
    public Jwe<byte[]> parseEncryptedContent(CharSequence charSequence) throws JwtException {
        return ((Jwt)this.parse(charSequence)).accept(Jwe.CONTENT);
    }

    @Override
    public Jwe<Claims> parseEncryptedClaims(CharSequence charSequence) throws JwtException {
        return ((Jwt)this.parse(charSequence)).accept(Jwe.CLAIMS);
    }

    protected byte[] decode(CharSequence charSequence, String string) {
        try {
            InputStream inputStream = this.decoder.decode(Streams.of(Strings.utf8(charSequence)));
            return Streams.bytes(inputStream, "Unable to Base64Url-decode input.");
        }
        catch (Throwable throwable) {
            charSequence = "payload".equals(string) ? "<redacted>" : charSequence.toString();
            charSequence = "Invalid Base64Url " + string + ": " + (String)charSequence;
            throw new MalformedJwtException((String)charSequence, throwable);
        }
    }

    protected Map<String, ?> deserialize(InputStream inputStream, String map) {
        try {
            Reader reader = Streams.reader(inputStream);
            map = new JsonObjectDeserializer(this.deserializer, (String)((Object)map));
            map = ((JsonObjectDeserializer)((Object)map)).apply(reader);
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(inputStream);
            throw throwable;
        }
        Objects.nullSafeClose(inputStream);
        return map;
    }
}

