/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.lang.Strings;

public class IdLocator<H extends Header, R extends Identifiable>
implements Locator<R>,
Function<H, R> {
    private final Parameter<String> param;
    private final Registry<String, R> registry;
    private final String algType;
    private final String behavior;
    private final String requiredMsg;

    public IdLocator(Parameter<String> parameter, Registry<String, R> registry, String string, String string2, String string3) {
        this.param = Assert.notNull(parameter, "Header param cannot be null.");
        this.registry = Assert.notNull(registry, "Registry cannot be null.");
        this.algType = Assert.hasText(string, "algType cannot be null or empty.");
        this.behavior = Assert.hasText(string2, "behavior cannot be null or empty.");
        this.requiredMsg = Strings.clean(string3);
    }

    @Override
    public R locate(Header object) {
        Object object2 = object.get(this.param.getId());
        object2 = object2 != null ? object2.toString() : null;
        if (!Strings.hasText((String)object2)) {
            if (this.requiredMsg != null) {
                throw new MalformedJwtException(this.requiredMsg);
            }
            return null;
        }
        try {
            return (R)((Identifiable)this.registry.forKey((String)object2));
        }
        catch (Exception exception) {
            object = new StringBuilder("Unsupported ").append(DefaultHeader.nameOf((Header)object)).append(" ").append(this.param).append(" value '").append((String)object2).append("'");
            if (this.registry.isEmpty()) {
                ((StringBuilder)object).append(": ").append(this.behavior).append(" is disabled (no ").append(this.algType).append(" algorithms have been configured)");
            }
            ((StringBuilder)object).append(".");
            object = ((StringBuilder)object).toString();
            throw new UnsupportedJwtException((String)object, exception);
        }
    }

    @Override
    public R apply(H h2) {
        return (R)this.locate((Header)h2);
    }
}

