/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.compression;

import io.jsonwebtoken.CompressionCodec;
import io.jsonwebtoken.CompressionException;
import io.jsonwebtoken.impl.compression.AbstractCompressionAlgorithm$1;
import io.jsonwebtoken.impl.compression.AbstractCompressionAlgorithm$2;
import io.jsonwebtoken.impl.compression.AbstractCompressionAlgorithm$3;
import io.jsonwebtoken.impl.compression.AbstractCompressionAlgorithm$4;
import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.CheckedFunction;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.lang.PropagatingExceptionFunction;
import io.jsonwebtoken.io.CompressionAlgorithm;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractCompressionAlgorithm
implements CompressionCodec,
CompressionAlgorithm {
    private final String id;
    private final Function<OutputStream, OutputStream> OS_WRAP_FN;
    private final Function<InputStream, InputStream> IS_WRAP_FN;
    private final Function<byte[], byte[]> COMPRESS_FN;
    private final Function<byte[], byte[]> DECOMPRESS_FN;

    private static <T, R> Function<T, R> propagate(CheckedFunction<T, R> checkedFunction, String string) {
        return new PropagatingExceptionFunction<T, R, CompressionException>(checkedFunction, CompressionException.class, string);
    }

    private static <T, R> Function<T, R> forCompression(CheckedFunction<T, R> checkedFunction) {
        return AbstractCompressionAlgorithm.propagate(checkedFunction, "Compression failed.");
    }

    private static <T, R> Function<T, R> forDecompression(CheckedFunction<T, R> checkedFunction) {
        return AbstractCompressionAlgorithm.propagate(checkedFunction, "Decompression failed.");
    }

    protected AbstractCompressionAlgorithm(String string) {
        this.id = Assert.hasText(Strings.clean(string), "id argument cannot be null or empty.");
        this.OS_WRAP_FN = AbstractCompressionAlgorithm.forCompression(new AbstractCompressionAlgorithm$1(this));
        this.COMPRESS_FN = AbstractCompressionAlgorithm.forCompression(new AbstractCompressionAlgorithm$2(this));
        this.IS_WRAP_FN = AbstractCompressionAlgorithm.forDecompression(new AbstractCompressionAlgorithm$3(this));
        this.DECOMPRESS_FN = AbstractCompressionAlgorithm.forDecompression(new AbstractCompressionAlgorithm$4(this));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getAlgorithmName() {
        return this.getId();
    }

    @Override
    public final OutputStream compress(OutputStream outputStream) throws CompressionException {
        return this.OS_WRAP_FN.apply(outputStream);
    }

    protected abstract OutputStream doCompress(OutputStream var1) throws IOException;

    @Override
    public final InputStream decompress(InputStream inputStream) throws CompressionException {
        return this.IS_WRAP_FN.apply(inputStream);
    }

    protected abstract InputStream doDecompress(InputStream var1) throws IOException;

    @Override
    public final byte[] compress(byte[] byArray) {
        if (Bytes.isEmpty(byArray)) {
            return Bytes.EMPTY;
        }
        return this.COMPRESS_FN.apply(byArray);
    }

    private byte[] doCompress(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        OutputStream outputStream = this.compress(byteArrayOutputStream);
        try {
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(outputStream);
            throw throwable;
        }
        Objects.nullSafeClose(outputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public final byte[] decompress(byte[] byArray) {
        if (Bytes.isEmpty(byArray)) {
            return Bytes.EMPTY;
        }
        return this.DECOMPRESS_FN.apply(byArray);
    }

    protected byte[] doDecompress(byte[] object) throws IOException {
        object = Streams.of((byte[])object);
        object = this.decompress((InputStream)object);
        byte[] byArray = new byte[512];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n2 = 0;
        try {
            while (n2 != -1) {
                n2 = ((InputStream)object).read(byArray);
                if (n2 <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n2);
            }
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(new Closeable[]{object});
            throw throwable;
        }
        Objects.nullSafeClose(new Closeable[]{object});
        return byteArrayOutputStream.toByteArray();
    }

    static /* synthetic */ byte[] access$000(AbstractCompressionAlgorithm abstractCompressionAlgorithm, byte[] byArray) throws IOException {
        return abstractCompressionAlgorithm.doCompress(byArray);
    }
}

