/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import io.jsonwebtoken.impl.io.BaseNCodec;
import io.jsonwebtoken.impl.io.BaseNCodec$Context;
import io.jsonwebtoken.impl.io.CodecPolicy;
import io.jsonwebtoken.lang.Strings;

class Base64Codec
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 6;
    private static final int BYTES_PER_UNENCODED_BLOCK = 3;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int MASK_6BITS = 63;
    private static final int MASK_4BITS = 15;
    private static final int MASK_2BITS = 3;
    private final byte[] encodeTable;
    private final byte[] decodeTable = DECODE_TABLE;
    private final byte[] lineSeparator;
    private final int decodeSize;
    private final int encodeSize;

    Base64Codec() {
        this(0);
    }

    Base64Codec(boolean bl2) {
        this(76, CHUNK_SEPARATOR, bl2);
    }

    Base64Codec(int n2) {
        this(n2, CHUNK_SEPARATOR);
    }

    Base64Codec(int n2, byte[] byArray) {
        this(n2, byArray, false);
    }

    Base64Codec(int n2, byte[] byArray, boolean bl2) {
        this(n2, byArray, bl2, DECODING_POLICY_DEFAULT);
    }

    Base64Codec(int n2, byte[] byArray, boolean bl2, CodecPolicy codecPolicy) {
        super(3, 4, n2, BaseNCodec.length(byArray), (byte)61, codecPolicy);
        if (byArray != null) {
            if (this.containsAlphabetOrPad(byArray)) {
                String string = Strings.utf8(byArray);
                throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + string + "]");
            }
            if (n2 > 0) {
                this.encodeSize = 4 + byArray.length;
                this.lineSeparator = (byte[])byArray.clone();
            } else {
                this.encodeSize = 4;
                this.lineSeparator = null;
            }
        } else {
            this.encodeSize = 4;
            this.lineSeparator = null;
        }
        this.decodeSize = this.encodeSize - 1;
        this.encodeTable = bl2 ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
    }

    @Override
    void decode(byte[] byArray, int n2, int n3, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.eof) {
            return;
        }
        if (n3 < 0) {
            baseNCodec$Context.eof = true;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by2;
            Base64Codec base64Codec = this;
            byte[] byArray2 = base64Codec.ensureBufferSize(base64Codec.decodeSize, baseNCodec$Context);
            if ((by2 = byArray[n2++]) == this.pad) {
                baseNCodec$Context.eof = true;
                break;
            }
            if (by2 < 0 || by2 >= DECODE_TABLE.length || (by2 = DECODE_TABLE[by2]) < 0) continue;
            baseNCodec$Context.modulus = (baseNCodec$Context.modulus + 1) % 4;
            baseNCodec$Context.ibitWorkArea = (baseNCodec$Context.ibitWorkArea << 6) + by2;
            if (baseNCodec$Context.modulus != 0) continue;
            byArray2[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.ibitWorkArea >> 16);
            byArray2[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.ibitWorkArea >> 8);
            byArray2[baseNCodec$Context.pos++] = (byte)baseNCodec$Context.ibitWorkArea;
        }
        if (baseNCodec$Context.eof && baseNCodec$Context.modulus != 0) {
            Base64Codec base64Codec = this;
            byte[] byArray3 = base64Codec.ensureBufferSize(base64Codec.decodeSize, baseNCodec$Context);
            switch (baseNCodec$Context.modulus) {
                case 1: {
                    this.validateTrailingCharacter();
                    return;
                }
                case 2: {
                    this.validateCharacter(15, baseNCodec$Context);
                    baseNCodec$Context.ibitWorkArea >>= 4;
                    byArray3[baseNCodec$Context.pos++] = (byte)baseNCodec$Context.ibitWorkArea;
                    return;
                }
                case 3: {
                    this.validateCharacter(3, baseNCodec$Context);
                    baseNCodec$Context.ibitWorkArea >>= 2;
                    byArray3[baseNCodec$Context.pos++] = (byte)(baseNCodec$Context.ibitWorkArea >> 8);
                    byArray3[baseNCodec$Context.pos++] = (byte)baseNCodec$Context.ibitWorkArea;
                    return;
                }
            }
            throw new IllegalStateException("Impossible modulus " + baseNCodec$Context.modulus);
        }
    }

    @Override
    void encode(byte[] byArray, int n2, int n3, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.eof) {
            return;
        }
        if (n3 < 0) {
            baseNCodec$Context.eof = true;
            if (baseNCodec$Context.modulus == 0 && this.lineLength == 0) {
                return;
            }
            Base64Codec base64Codec = this;
            byte[] byArray2 = base64Codec.ensureBufferSize(base64Codec.encodeSize, baseNCodec$Context);
            int n4 = baseNCodec$Context.pos;
            switch (baseNCodec$Context.modulus) {
                case 0: {
                    break;
                }
                case 1: {
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 2 & 0x3F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea << 4 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    break;
                }
                case 2: {
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 10 & 0x3F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 4 & 0x3F];
                    byArray2[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea << 2 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    byArray2[baseNCodec$Context.pos++] = this.pad;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + baseNCodec$Context.modulus);
                }
            }
            baseNCodec$Context.currentLinePos += baseNCodec$Context.pos - n4;
            if (this.lineLength > 0 && baseNCodec$Context.currentLinePos > 0) {
                System.arraycopy(this.lineSeparator, 0, byArray2, baseNCodec$Context.pos, this.lineSeparator.length);
                baseNCodec$Context.pos += this.lineSeparator.length;
            }
            return;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5;
            Base64Codec base64Codec = this;
            byte[] byArray3 = base64Codec.ensureBufferSize(base64Codec.encodeSize, baseNCodec$Context);
            baseNCodec$Context.modulus = (baseNCodec$Context.modulus + 1) % 3;
            if ((n5 = byArray[n2++]) < 0) {
                n5 += 256;
            }
            baseNCodec$Context.ibitWorkArea = (baseNCodec$Context.ibitWorkArea << 8) + n5;
            if (baseNCodec$Context.modulus != 0) continue;
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 18 & 0x3F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 12 & 0x3F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea >> 6 & 0x3F];
            byArray3[baseNCodec$Context.pos++] = this.encodeTable[baseNCodec$Context.ibitWorkArea & 0x3F];
            baseNCodec$Context.currentLinePos += 4;
            if (this.lineLength <= 0 || this.lineLength > baseNCodec$Context.currentLinePos) continue;
            System.arraycopy(this.lineSeparator, 0, byArray3, baseNCodec$Context.pos, this.lineSeparator.length);
            baseNCodec$Context.pos += this.lineSeparator.length;
            baseNCodec$Context.currentLinePos = 0;
        }
    }

    @Override
    protected boolean isInAlphabet(byte by2) {
        return by2 >= 0 && by2 < this.decodeTable.length && this.decodeTable[by2] != -1;
    }

    public boolean isUrlSafe() {
        return this.encodeTable == URL_SAFE_ENCODE_TABLE;
    }

    private void validateCharacter(int n2, BaseNCodec$Context baseNCodec$Context) {
        if (this.isStrictDecoding() && (baseNCodec$Context.ibitWorkArea & n2) != 0) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character (before the paddings if any) is a valid base 64 alphabet but not a possible encoding. Expected the discarded bits from the character to be zero.");
        }
    }

    private void validateTrailingCharacter() {
        if (this.isStrictDecoding()) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character (before the paddings if any) is a valid base 64 alphabet but not a possible encoding. Decoding requires at least two trailing 6-bit characters to create bytes.");
        }
    }
}

