/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import io.jsonwebtoken.impl.io.BaseNCodec;
import io.jsonwebtoken.impl.io.BaseNCodec$Context;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

class BaseNCodecInputStream
extends FilterInputStream {
    private final BaseNCodec baseNCodec;
    private final boolean doEncode;
    private final byte[] singleByte = new byte[1];
    private final byte[] buf;
    private final BaseNCodec$Context context = new BaseNCodec$Context();

    protected BaseNCodecInputStream(InputStream inputStream, BaseNCodec baseNCodec, boolean bl2) {
        super(inputStream);
        this.doEncode = bl2;
        this.baseNCodec = baseNCodec;
        this.buf = new byte[bl2 ? 4096 : 8192];
    }

    @Override
    public int available() throws IOException {
        if (this.context.eof) {
            return 0;
        }
        return 1;
    }

    public boolean isStrictDecoding() {
        return this.baseNCodec.isStrictDecoding();
    }

    @Override
    public synchronized void mark(int n2) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        BaseNCodecInputStream baseNCodecInputStream = this;
        int n2 = baseNCodecInputStream.read(baseNCodecInputStream.singleByte, 0, 1);
        while (n2 == 0) {
            BaseNCodecInputStream baseNCodecInputStream2 = this;
            n2 = baseNCodecInputStream2.read(baseNCodecInputStream2.singleByte, 0, 1);
        }
        if (n2 > 0) {
            n2 = this.singleByte[0];
            if (n2 < 0) {
                return n2 + 256;
            }
            return n2;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        Objects.requireNonNull(byArray, "array");
        if (n2 < 0 || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 > byArray.length || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        for (n4 = 0; n4 < n3; n4 += n5) {
            if (!this.baseNCodec.hasData(this.context)) {
                n5 = this.in.read(this.buf);
                if (this.doEncode) {
                    this.baseNCodec.encode(this.buf, 0, n5, this.context);
                } else {
                    this.baseNCodec.decode(this.buf, 0, n5, this.context);
                }
            }
            if ((n5 = this.baseNCodec.readResults(byArray, n2 + n4, n3 - n4, this.context)) >= 0) continue;
            if (n4 != 0) {
                return n4;
            }
            return -1;
        }
        return n4;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3;
        int n2;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative skip length: " + l2);
        }
        byte[] byArray = new byte[512];
        for (l3 = l2; l3 > 0L; l3 -= (long)n2) {
            int cfr_ignored_0 = byArray.length;
            n2 = (int)Math.min(512L, l3);
            n2 = this.read(byArray, 0, n2);
            if (n2 == -1) break;
        }
        return l2 - l3;
    }
}

