/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import io.jsonwebtoken.impl.io.BytesInputStream;
import io.jsonwebtoken.impl.io.CharSequenceReader;
import io.jsonwebtoken.impl.io.Streams$1;
import io.jsonwebtoken.impl.io.Streams$2;
import io.jsonwebtoken.impl.io.Streams$3;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import java.io.ByteArrayOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.concurrent.Callable;

public class Streams {
    public static final int EOF = -1;

    public static byte[] bytes(InputStream inputStream, String string) {
        if (inputStream instanceof BytesInputStream) {
            return ((BytesInputStream)inputStream).getBytes();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        Streams.copy(inputStream, byteArrayOutputStream, new byte[8192], string);
        return byteArrayOutputStream.toByteArray();
    }

    public static InputStream of(byte[] byArray) {
        return new BytesInputStream(byArray);
    }

    public static InputStream of(CharSequence charSequence) {
        return Streams.of(Strings.utf8(charSequence));
    }

    public static Reader reader(byte[] byArray) {
        return Streams.reader(Streams.of(byArray));
    }

    public static Reader reader(InputStream inputStream) {
        return new InputStreamReader(inputStream, Strings.UTF_8);
    }

    public static Reader reader(CharSequence charSequence) {
        return new CharSequenceReader(charSequence);
    }

    public static void flush(Flushable ... flushableArray) {
        Objects.nullSafeFlush(flushableArray);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        Assert.notNull(inputStream, "inputStream cannot be null.");
        Assert.notNull(outputStream, "outputStream cannot be null.");
        Assert.notEmpty(byArray, "buffer cannot be null or empty.");
        long l2 = 0L;
        int n2 = 0;
        while (n2 != -1) {
            n2 = inputStream.read(byArray);
            if (n2 > 0) {
                outputStream.write(byArray, 0, n2);
            }
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, byte[] byArray, String string) {
        return Streams.run(new Streams$1(inputStream, outputStream, byArray), string);
    }

    public static void reset(InputStream object) {
        if (object == null) {
            return;
        }
        object = new Streams$2((InputStream)object);
        try {
            object.call();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static void write(OutputStream outputStream, byte[] byArray, String string) {
        Streams.write(outputStream, byArray, 0, Bytes.length(byArray), string);
    }

    public static void write(OutputStream outputStream, byte[] byArray, int n2, int n3, String string) {
        if (outputStream == null || Bytes.isEmpty(byArray) || n3 <= 0) {
            return;
        }
        Streams.run(new Streams$3(outputStream, byArray, n2, n3), string);
    }

    public static void writeAndClose(OutputStream outputStream, byte[] byArray, String string) {
        try {
            Streams.write(outputStream, byArray, string);
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(outputStream);
            throw throwable;
        }
        Objects.nullSafeClose(outputStream);
    }

    public static <V> V run(Callable<V> callable, String string) {
        Assert.hasText(string, "IO Exception Message cannot be null or empty.");
        try {
            return callable.call();
        }
        catch (Throwable throwable) {
            string = "IO failure: " + string;
            if (!string.endsWith(".")) {
                string = string + ".";
            }
            string = string + " Cause: " + throwable.getMessage();
            throw new io.jsonwebtoken.io.IOException(string, throwable);
        }
    }
}

