/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;
import java.math.BigInteger;

public class BigIntegerUBytesConverter
implements Converter<BigInteger, byte[]> {
    private static final String NEGATIVE_MSG = "JWA Base64urlUInt values MUST be >= 0 (non-negative) per the 'Base64urlUInt' definition in [JWA RFC 7518, Section 2](https://www.rfc-editor.org/rfc/rfc7518.html#section-2)";

    @Override
    public byte[] applyTo(BigInteger object) {
        Assert.notNull(object, "BigInteger argument cannot be null.");
        if (BigInteger.ZERO.compareTo((BigInteger)object) > 0) {
            throw new IllegalArgumentException(NEGATIVE_MSG);
        }
        int n2 = ((BigInteger)object).bitLength();
        if (((Object)(object = (Object)((BigInteger)object).toByteArray())).length == (n2 = Math.max(1, Bytes.length(n2)))) {
            return object;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(object, 1, byArray, 0, n2);
        return byArray;
    }

    @Override
    public BigInteger applyFrom(byte[] byArray) {
        Assert.notEmpty(byArray, "Byte array cannot be null or empty.");
        return new BigInteger(1, byArray);
    }
}

