/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.CollectionConverter$CreateListFunction;
import io.jsonwebtoken.impl.lang.CollectionConverter$CreateSetFunction;
import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import java.util.Collection;
import java.util.List;
import java.util.Set;

class CollectionConverter<T, C extends Collection<T>>
implements Converter<C, Object> {
    private final Converter<T, Object> elementConverter;
    private final Function<Integer, C> fn;

    public static <T> CollectionConverter<T, List<T>> forList(Converter<T, Object> converter) {
        return new CollectionConverter(converter, new CollectionConverter$CreateListFunction(null));
    }

    public static <T> CollectionConverter<T, Set<T>> forSet(Converter<T, Object> converter) {
        return new CollectionConverter(converter, new CollectionConverter$CreateSetFunction(null));
    }

    public CollectionConverter(Converter<T, Object> converter, Function<Integer, C> function) {
        this.elementConverter = Assert.notNull(converter, "Element converter cannot be null.");
        this.fn = Assert.notNull(function, "Collection function cannot be null.");
    }

    @Override
    public Object applyTo(C object) {
        if (Collections.isEmpty(object)) {
            return object;
        }
        Collection collection = (Collection)this.fn.apply(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = this.elementConverter.applyTo(object2);
            collection.add(object2);
        }
        return collection;
    }

    private C toElementList(Collection<?> object) {
        Assert.notEmpty(object, "Collection cannot be null or empty.");
        Collection collection = (Collection)this.fn.apply(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = this.elementConverter.applyFrom(object2);
            collection.add(object2);
        }
        return (C)collection;
    }

    @Override
    public C applyFrom(Object collection) {
        if (collection == null) {
            return null;
        }
        collection = collection.getClass().isArray() && !collection.getClass().getComponentType().isPrimitive() ? Collections.arrayToList(collection) : (collection instanceof Collection ? (Collection)collection : java.util.Collections.singletonList(collection));
        collection = Collections.isEmpty(collection) ? (Collection)this.fn.apply(0) : this.toElementList(collection);
        return (C)collection;
    }
}

