/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;

public final class CompactMediaTypeIdConverter
implements Converter<String, Object> {
    public static final Converter<String, Object> INSTANCE = new CompactMediaTypeIdConverter();
    private static final char FORWARD_SLASH = '/';
    private static final String APP_MEDIA_TYPE_PREFIX = "application/";

    static String compactIfPossible(String string) {
        Assert.hasText(string, "Value cannot be null or empty.");
        if (Strings.startsWithIgnoreCase(string, APP_MEDIA_TYPE_PREFIX)) {
            for (int i2 = string.length() - 1; i2 >= 12; --i2) {
                char c2 = string.charAt(i2);
                if (c2 != '/') continue;
                return string;
            }
            return string.substring(12);
        }
        return string;
    }

    @Override
    public final Object applyTo(String string) {
        return CompactMediaTypeIdConverter.compactIfPossible(string);
    }

    @Override
    public final String applyFrom(Object object) {
        Assert.notNull(object, "Value cannot be null.");
        object = Assert.isInstanceOf(String.class, object, "Value must be a string.");
        if (((String)object).indexOf(47) < 0) {
            object = APP_MEDIA_TYPE_PREFIX + (String)object;
        }
        return object;
    }
}

