/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.DelegatingMap;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.lang.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultRegistry<K, V>
extends DelegatingMap<K, V, Map<K, V>>
implements Function<K, V>,
Registry<K, V> {
    private final String qualifiedKeyName;

    private static <K, V> Map<K, V> toMap(Collection<? extends V> object, Function<V, K> function) {
        Assert.notNull(object, "Collection of values may not be null.");
        Assert.notNull(function, "Key function cannot be null.");
        LinkedHashMap linkedHashMap = new LinkedHashMap(Collections.size(object));
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            K k2 = Assert.notNull(function.apply(e2), "Key function cannot return a null value.");
            linkedHashMap.put(k2, e2);
        }
        return Collections.immutable(linkedHashMap);
    }

    public DefaultRegistry(String string, String string2, Collection<? extends V> collection, Function<V, K> function) {
        super(DefaultRegistry.toMap(collection, function));
        string = Assert.hasText(Strings.clean(string), "name cannot be null or empty.");
        string2 = Assert.hasText(Strings.clean(string2), "keyName cannot be null or empty.");
        this.qualifiedKeyName = string + " " + string2;
    }

    @Override
    public V apply(K k2) {
        return this.get(k2);
    }

    @Override
    public V forKey(K object) {
        Object v2 = this.get(object);
        if (v2 == null) {
            object = "Unrecognized " + this.qualifiedKeyName + ": " + object;
            throw new IllegalArgumentException((String)object);
        }
        return v2;
    }

    static <T> T immutable() {
        throw new UnsupportedOperationException("Registries are immutable and cannot be modified.");
    }

    @Override
    public V put(K k2, V v2) {
        return (V)DefaultRegistry.immutable();
    }

    @Override
    public V remove(Object object) {
        return (V)DefaultRegistry.immutable();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        DefaultRegistry.immutable();
    }

    @Override
    public void clear() {
        DefaultRegistry.immutable();
    }

    @Override
    public int hashCode() {
        return this.DELEGATE.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultRegistry) {
            object = (DefaultRegistry)object;
            return this.qualifiedKeyName.equals(((DefaultRegistry)object).qualifiedKeyName) && this.DELEGATE.equals(((DelegatingMap)object).DELEGATE);
        }
        return false;
    }

    public String toString() {
        return this.DELEGATE.toString();
    }
}

