/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.CheckedFunction;
import io.jsonwebtoken.impl.lang.DelegatingCheckedFunction;
import io.jsonwebtoken.impl.lang.FormattedStringFunction;
import io.jsonwebtoken.impl.lang.FormattedStringSupplier;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.lang.Functions$1;
import io.jsonwebtoken.impl.lang.Functions$2;
import io.jsonwebtoken.impl.lang.Functions$3;
import io.jsonwebtoken.impl.lang.PropagatingExceptionFunction;
import io.jsonwebtoken.lang.Assert;

public final class Functions {
    private Functions() {
    }

    public static <T> Function<T, T> identity() {
        return new Functions$1();
    }

    public static <T, R, E extends RuntimeException> Function<T, R> wrapFmt(CheckedFunction<T, R> checkedFunction, Class<E> clazz, String string) {
        return new PropagatingExceptionFunction<T, R, E>(checkedFunction, clazz, new FormattedStringFunction(string));
    }

    public static <T, R, E extends RuntimeException> Function<T, R> wrap(Function<T, R> function, Class<E> clazz, String string, Object ... objectArray) {
        return new PropagatingExceptionFunction<T, R, E>(new DelegatingCheckedFunction<T, R>(function), clazz, new FormattedStringSupplier(string, objectArray));
    }

    public static <T, V, R> Function<T, R> andThen(Function<T, ? extends V> function, Function<V, R> function2) {
        Assert.notNull(function, "Before function cannot be null.");
        Assert.notNull(function2, "After function cannot be null.");
        return new Functions$2(function, function2);
    }

    @SafeVarargs
    public static <T, R> Function<T, R> firstResult(Function<T, R> ... functionArray) {
        Assert.notEmpty(functionArray, "Function list cannot be null or empty.");
        return new Functions$3(functionArray);
    }
}

