/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Converters;
import io.jsonwebtoken.impl.lang.DefaultParameterBuilder;
import io.jsonwebtoken.impl.lang.IdRegistry;
import io.jsonwebtoken.impl.lang.JwtDateConverter;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.ParameterBuilder;
import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.lang.Arrays;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Registry;
import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class Parameters {
    private Parameters() {
    }

    public static Parameter<String> string(String string, String string2) {
        return (Parameter)Parameters.builder(String.class).setId(string).setName(string2).build();
    }

    public static Parameter<Date> rfcDate(String string, String string2) {
        return (Parameter)Parameters.builder(Date.class).setConverter(JwtDateConverter.INSTANCE).setId(string).setName(string2).build();
    }

    public static Parameter<List<X509Certificate>> x509Chain(String string, String string2) {
        return (Parameter)Parameters.builder(X509Certificate.class).setConverter(Converters.X509_CERTIFICATE).list().setId(string).setName(string2).build();
    }

    public static <T> ParameterBuilder<T> builder(Class<T> clazz) {
        return new DefaultParameterBuilder<T>(clazz);
    }

    public static Parameter<Set<String>> stringSet(String string, String string2) {
        return (Parameter)Parameters.builder(String.class).set().setId(string).setName(string2).build();
    }

    public static Parameter<URI> uri(String string, String string2) {
        return (Parameter)Parameters.builder(URI.class).setConverter(Converters.URI).setId(string).setName(string2).build();
    }

    public static ParameterBuilder<byte[]> bytes(String string, String string2) {
        return Parameters.builder(byte[].class).setConverter(Converters.BASE64URL_BYTES).setId(string).setName(string2);
    }

    public static ParameterBuilder<BigInteger> bigInt(String string, String string2) {
        return Parameters.builder(BigInteger.class).setConverter(Converters.BIGINT).setId(string).setName(string2);
    }

    public static Parameter<BigInteger> secretBigInt(String string, String string2) {
        return (Parameter)Parameters.bigInt(string, string2).setSecret(true).build();
    }

    public static Registry<String, Parameter<?>> registry(Parameter<?> ... parameterArray) {
        return Parameters.registry(Arrays.asList(parameterArray));
    }

    public static Registry<String, Parameter<?>> registry(Collection<Parameter<?>> collection) {
        return new IdRegistry("Parameter", collection, true);
    }

    public static Registry<String, Parameter<?>> registry(Registry<String, Parameter<?>> registry, Parameter<?> ... parameterArray) {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(registry.size() + parameterArray.length);
        linkedHashSet.addAll(registry.values());
        linkedHashSet.addAll(Arrays.asList(parameterArray));
        return new IdRegistry("Parameter", linkedHashSet, true);
    }

    public static Registry<String, ? extends Parameter<?>> replace(Registry<String, ? extends Parameter<?>> map, Parameter<?> parameter) {
        Assert.notEmpty(map, "Registry cannot be null or empty.");
        Assert.notNull(parameter, "Parameter cannot be null.");
        String string = Assert.hasText(parameter.getId(), "Parameter id cannot be null or empty.");
        map = new LinkedHashMap(map);
        map.remove(string);
        map.put(string, parameter);
        return Parameters.registry(map.values());
    }

    private static byte[] bytes(BigInteger bigInteger) {
        if (bigInteger != null) {
            return bigInteger.toByteArray();
        }
        return null;
    }

    public static boolean bytesEquals(BigInteger object, BigInteger object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        object = Parameters.bytes((BigInteger)object);
        object2 = Parameters.bytes((BigInteger)object2);
        try {
            boolean bl2 = MessageDigest.isEqual((byte[])object, (byte[])object2);
            return bl2;
        }
        finally {
            Bytes.clear((byte[])object);
            Bytes.clear((byte[])object2);
        }
    }

    private static <T> boolean equals(T t2, T t3, Parameter<T> parameter) {
        if (t2 == t3) {
            return true;
        }
        if (t2 == null || t3 == null) {
            return false;
        }
        if (parameter.isSecret()) {
            if (t2 instanceof byte[]) {
                return t3 instanceof byte[] && MessageDigest.isEqual((byte[])t2, (byte[])t3);
            }
            if (t2 instanceof BigInteger) {
                return t3 instanceof BigInteger && Parameters.bytesEquals((BigInteger)t2, (BigInteger)t3);
            }
        }
        return Objects.nullSafeEquals(t2, t3);
    }

    public static <T> boolean equals(ParameterReadable parameterReadable, Object object, Parameter<T> parameter) {
        if (parameterReadable == object) {
            return true;
        }
        if (parameterReadable == null || !(object instanceof ParameterReadable)) {
            return false;
        }
        object = (ParameterReadable)object;
        return Parameters.equals(parameterReadable.get(parameter), object.get(parameter), parameter);
    }
}

