/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;
import java.util.concurrent.atomic.AtomicInteger;

public class PositiveIntegerConverter
implements Converter<Integer, Object> {
    public static final PositiveIntegerConverter INSTANCE = new PositiveIntegerConverter();

    @Override
    public Object applyTo(Integer n2) {
        return n2;
    }

    @Override
    public Integer applyFrom(Object object) {
        int n2;
        Assert.notNull(object, "Argument cannot be null.");
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof AtomicInteger) {
            n2 = ((Number)object).intValue();
        } else {
            object = String.valueOf(object);
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = "Value cannot be represented as a java.lang.Integer.";
                throw new IllegalArgumentException(string, numberFormatException);
            }
        }
        if (n2 <= 0) {
            String string = "Value must be a positive integer.";
            throw new IllegalArgumentException(string);
        }
        return n2;
    }
}

