/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.CheckedFunction;
import io.jsonwebtoken.impl.lang.ConstantFunction;
import io.jsonwebtoken.impl.lang.DelegatingCheckedFunction;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.lang.PropagatingExceptionFunction$1;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Classes;
import io.jsonwebtoken.lang.Supplier;
import java.lang.reflect.GenericDeclaration;

public class PropagatingExceptionFunction<T, R, E extends RuntimeException>
implements Function<T, R> {
    private final CheckedFunction<T, R> function;
    private final Function<T, String> msgFunction;
    private final Class<E> clazz;

    public PropagatingExceptionFunction(Function<T, R> function, Class<E> clazz, String string) {
        this(new DelegatingCheckedFunction<T, R>(function), clazz, new ConstantFunction(string));
    }

    public PropagatingExceptionFunction(CheckedFunction<T, R> checkedFunction, Class<E> clazz, String string) {
        this(checkedFunction, clazz, new ConstantFunction(string));
    }

    public PropagatingExceptionFunction(CheckedFunction<T, R> checkedFunction, Class<E> clazz, Supplier<String> supplier) {
        this(checkedFunction, clazz, new PropagatingExceptionFunction$1(supplier));
    }

    public PropagatingExceptionFunction(CheckedFunction<T, R> checkedFunction, Class<E> clazz, Function<T, String> function) {
        this.clazz = Assert.notNull(clazz, "Exception class cannot be null.");
        this.msgFunction = Assert.notNull(function, "msgFunction cannot be null.");
        this.function = Assert.notNull(checkedFunction, "Function cannot be null");
    }

    @Override
    public R apply(T object) {
        try {
            return this.function.apply(object);
        }
        catch (Exception exception) {
            if (this.clazz.isAssignableFrom(exception.getClass())) {
                throw (RuntimeException)this.clazz.cast(exception);
            }
            if (!((String)(object = this.msgFunction.apply(object))).endsWith(".")) {
                object = object + ".";
            }
            object = object + " Cause: " + exception.getMessage();
            GenericDeclaration genericDeclaration = this.clazz;
            genericDeclaration = Classes.getConstructor(genericDeclaration, new Class[]{String.class, Throwable.class});
            throw (RuntimeException)Classes.instantiate(genericDeclaration, new Object[]{object, exception});
        }
    }
}

