/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;

public class RequiredTypeConverter<T>
implements Converter<T, Object> {
    private final Class<T> type;

    public RequiredTypeConverter(Class<T> clazz) {
        this.type = Assert.notNull(clazz, "type argument cannot be null.");
    }

    @Override
    public Object applyTo(T t2) {
        return t2;
    }

    @Override
    public T applyFrom(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (!this.type.isAssignableFrom(clazz)) {
            object = "Unsupported value type. Expected: " + this.type.getName() + ", found: " + clazz.getName();
            throw new IllegalArgumentException((String)object);
        }
        return this.type.cast(object);
    }
}

