/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Services$1;
import io.jsonwebtoken.impl.lang.Services$2;
import io.jsonwebtoken.impl.lang.Services$3;
import io.jsonwebtoken.impl.lang.Services$ClassLoaderAccessor;
import io.jsonwebtoken.impl.lang.UnavailableImplementationException;
import io.jsonwebtoken.lang.Arrays;
import io.jsonwebtoken.lang.Assert;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Services {
    private static final ConcurrentMap<Class<?>, Object> SERVICES = new ConcurrentHashMap();
    private static final List<Services$ClassLoaderAccessor> CLASS_LOADER_ACCESSORS = Arrays.asList(new Services$ClassLoaderAccessor[]{new Services$1(), new Services$2(), new Services$3()});

    private Services() {
    }

    public static <T> T get(Class<T> clazz) {
        T t2 = Services.findCached(clazz);
        if (t2 == null) {
            t2 = Services.loadFirst(clazz);
            SERVICES.putIfAbsent(clazz, t2);
        }
        return t2;
    }

    private static <T> T findCached(Class<T> clazz) {
        Assert.notNull(clazz, "Service interface cannot be null.");
        Object v2 = SERVICES.get(clazz);
        if (v2 != null) {
            return Assert.isInstanceOf(clazz, v2, "Unexpected cached service implementation type.");
        }
        return null;
    }

    private static <T> T loadFirst(Class<T> clazz) {
        for (Services$ClassLoaderAccessor services$ClassLoaderAccessor : CLASS_LOADER_ACCESSORS) {
            ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, services$ClassLoaderAccessor.getClassLoader());
            Assert.stateNotNull(serviceLoader, "JDK ServiceLoader#load should never return null.");
            Iterator<T> iterator = serviceLoader.iterator();
            Assert.stateNotNull(iterator, "JDK ServiceLoader#iterator() should never return null.");
            if (!iterator.hasNext()) continue;
            return iterator.next();
        }
        throw new UnavailableImplementationException(clazz);
    }

    public static void reload() {
        SERVICES.clear();
    }
}

