/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Converters;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import io.jsonwebtoken.impl.security.ECCurve;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.UnsupportedKeyException;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.ECKey;
import java.security.spec.EllipticCurve;
import java.util.Set;

abstract class AbstractEcJwkFactory<K extends Key & ECKey, J extends Jwk<K>>
extends AbstractFamilyJwkFactory<K, J> {
    protected static ECCurve getCurveByJwaId(String string) {
        ECCurve eCCurve = ECCurve.findById(string);
        if (eCCurve == null) {
            string = "Unrecognized JWA EC curve id '" + string + "'";
            throw new UnsupportedKeyException(string);
        }
        return eCCurve;
    }

    static String toOctetString(EllipticCurve ellipticCurve, BigInteger object) {
        object = Converters.BIGINT_UBYTES.applyTo((BigInteger)object);
        int n2 = ellipticCurve.getField().getFieldSize();
        n2 = Bytes.length(n2);
        object = Bytes.prepad((byte[])object, n2);
        return Encoders.BASE64URL.encode((byte[])object);
    }

    AbstractEcJwkFactory(Class<K> clazz, Set<Parameter<?>> set) {
        super("EC", clazz, set);
    }
}

