/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.DelegatingMapMutator;
import io.jsonwebtoken.impl.lang.IdRegistry;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.Parameters;
import io.jsonwebtoken.impl.security.AbstractJwk;
import io.jsonwebtoken.impl.security.AbstractJwkBuilder$1;
import io.jsonwebtoken.impl.security.DispatchingJwkFactory;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.JwkFactory;
import io.jsonwebtoken.impl.security.KeyOperationConverter;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.security.HashAlgorithm;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkBuilder;
import io.jsonwebtoken.security.Jwks$HASH;
import io.jsonwebtoken.security.Jwks$OP;
import io.jsonwebtoken.security.KeyOperation;
import io.jsonwebtoken.security.KeyOperationPolicy;
import io.jsonwebtoken.security.MalformedKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Map;

abstract class AbstractJwkBuilder<K extends Key, J extends Jwk<K>, T extends JwkBuilder<K, J, T>>
extends DelegatingMapMutator<String, Object, JwkContext<K>, T>
implements JwkBuilder<K, J, T> {
    protected final JwkFactory<K, J> jwkFactory;
    static final KeyOperationPolicy DEFAULT_OPERATION_POLICY = (KeyOperationPolicy)Jwks$OP.policy().build();
    protected KeyOperationPolicy opsPolicy = DEFAULT_OPERATION_POLICY;

    protected AbstractJwkBuilder(JwkContext<K> jwkContext) {
        this(jwkContext, DispatchingJwkFactory.DEFAULT_INSTANCE);
    }

    protected AbstractJwkBuilder(JwkContext<K> jwkContext, JwkFactory<K, J> jwkFactory) {
        super(jwkContext);
        this.jwkFactory = Assert.notNull(jwkFactory, "JwkFactory cannot be null.");
    }

    protected <A extends Key> JwkContext<A> newContext(A a2) {
        return this.jwkFactory.newContext((JwkContext)this.DELEGATE, a2);
    }

    @Override
    public T provider(Provider provider) {
        ((JwkContext)this.DELEGATE).setProvider(provider);
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public T random(SecureRandom secureRandom) {
        ((JwkContext)this.DELEGATE).setRandom(secureRandom);
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public T algorithm(String string) {
        Assert.hasText(string, "Algorithm cannot be null or empty.");
        ((JwkContext)this.DELEGATE).setAlgorithm(string);
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public T id(String string) {
        Assert.hasText(string, "Id cannot be null or empty.");
        ((JwkContext)this.DELEGATE).setIdThumbprintAlgorithm(null);
        ((JwkContext)this.DELEGATE).setId(string);
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public T idFromThumbprint() {
        return this.idFromThumbprint(Jwks$HASH.SHA256);
    }

    @Override
    public T idFromThumbprint(HashAlgorithm hashAlgorithm) {
        Assert.notNull(hashAlgorithm, "Thumbprint HashAlgorithm cannot be null.");
        Assert.notNull(hashAlgorithm.getId(), "Thumbprint HashAlgorithm ID cannot be null.");
        ((JwkContext)this.DELEGATE).setId(null);
        ((JwkContext)this.DELEGATE).setIdThumbprintAlgorithm(hashAlgorithm);
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public NestedCollection<KeyOperation, T> operations() {
        AbstractJwkBuilder abstractJwkBuilder = this;
        return new AbstractJwkBuilder$1(abstractJwkBuilder, (JwkBuilder)abstractJwkBuilder.self(), ((JwkContext)this.DELEGATE).getOperations());
    }

    @Override
    public T operationPolicy(KeyOperationPolicy object) throws IllegalArgumentException {
        Assert.notNull(object, "Policy cannot be null.");
        Collection<KeyOperation> collection = object.getOperations();
        Assert.notEmpty(collection, "Policy operations cannot be null or empty.");
        this.opsPolicy = object;
        object = new IdRegistry<KeyOperation>("JSON Web Key Operation", collection);
        object = (Parameter)Parameters.builder(KeyOperation.class).setConverter(new KeyOperationConverter((Registry<String, KeyOperation>)object)).set().setId(AbstractJwk.KEY_OPS.getId()).setName(AbstractJwk.KEY_OPS.getName()).build();
        AbstractJwkBuilder abstractJwkBuilder = this;
        abstractJwkBuilder.setDelegate(((JwkContext)abstractJwkBuilder.DELEGATE).parameter((Parameter<?>)object));
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public J build() {
        Assert.stateNotNull(this.DELEGATE, "JwkContext should always be non-null");
        Object object = ((JwkContext)this.DELEGATE).getKey();
        if (object == null && this.isEmpty()) {
            object = "A " + Key.class.getName() + " or one or more name/value pairs must be provided to create a JWK.";
            throw new IllegalStateException((String)object);
        }
        try {
            this.opsPolicy.validate((Collection<? extends KeyOperation>)((JwkContext)this.DELEGATE).get(AbstractJwk.KEY_OPS));
            return this.jwkFactory.createJwk((JwkContext)this.DELEGATE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "Unable to create JWK: " + illegalArgumentException.getMessage();
            throw new MalformedKeyException(string, illegalArgumentException);
        }
    }

    static /* synthetic */ Map access$000(AbstractJwkBuilder abstractJwkBuilder) {
        return abstractJwkBuilder.DELEGATE;
    }
}

