/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.CryptoAlgorithm;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.KeyException;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.VerifySecureDigestRequest;
import java.io.InputStream;
import java.security.Key;

abstract class AbstractSecureDigestAlgorithm<S extends Key, V extends Key>
extends CryptoAlgorithm
implements SecureDigestAlgorithm<S, V> {
    AbstractSecureDigestAlgorithm(String string, String string2) {
        super(string, string2);
    }

    protected static String keyType(boolean bl2) {
        if (bl2) {
            return "signing";
        }
        return "verification";
    }

    protected abstract void validateKey(Key var1, boolean var2);

    @Override
    public final byte[] digest(SecureRequest<InputStream, S> object) throws SecurityException {
        Assert.notNull(object, "Request cannot be null.");
        Object object2 = (Key)Assert.notNull(object.getKey(), "Signing key cannot be null.");
        Assert.notNull(object.getPayload(), "Request content cannot be null.");
        try {
            this.validateKey((Key)object2, true);
            return this.doDigest((SecureRequest<InputStream, S>)object);
        }
        catch (KeyException | SignatureException securityException) {
            object = securityException;
            throw securityException;
        }
        catch (Exception exception) {
            object2 = "Unable to compute " + this.getId() + " signature with JCA algorithm '" + this.getJcaName() + "' using key {" + KeysBridge.toString((Key)object2) + "}: " + exception.getMessage();
            throw new SignatureException((String)object2, exception);
        }
    }

    protected abstract byte[] doDigest(SecureRequest<InputStream, S> var1) throws Exception;

    @Override
    public final boolean verify(VerifySecureDigestRequest<V> object) throws SecurityException {
        Assert.notNull(object, "Request cannot be null.");
        Object object2 = (Key)Assert.notNull(object.getKey(), "Verification key cannot be null.");
        Assert.notNull(object.getPayload(), "Request content cannot be null or empty.");
        Assert.notEmpty(object.getDigest(), "Request signature byte array cannot be null or empty.");
        try {
            this.validateKey((Key)object2, false);
            return this.doVerify((VerifySecureDigestRequest<V>)object);
        }
        catch (KeyException | SignatureException securityException) {
            object = securityException;
            throw securityException;
        }
        catch (Exception exception) {
            object2 = "Unable to verify " + this.getId() + " signature with JCA algorithm '" + this.getJcaName() + "' using key {" + KeysBridge.toString((Key)object2) + "}: " + exception.getMessage();
            throw new SignatureException((String)object2, exception);
        }
    }

    protected abstract boolean doVerify(VerifySecureDigestRequest<V> var1);
}

