/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.impl.DefaultJweHeader;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.AesAlgorithm;
import io.jsonwebtoken.impl.security.AesGcmKeyAlgorithm$1;
import io.jsonwebtoken.impl.security.AesGcmKeyAlgorithm$2;
import io.jsonwebtoken.impl.security.DefaultKeyResult;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.DecryptionKeyRequest;
import io.jsonwebtoken.security.KeyRequest;
import io.jsonwebtoken.security.KeyResult;
import io.jsonwebtoken.security.Request;
import io.jsonwebtoken.security.SecretKeyAlgorithm;
import io.jsonwebtoken.security.SecurityException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class AesGcmKeyAlgorithm
extends AesAlgorithm
implements SecretKeyAlgorithm {
    public static final String TRANSFORMATION = "AES/GCM/NoPadding";

    public AesGcmKeyAlgorithm(int n2) {
        super("A" + n2 + "GCMKW", TRANSFORMATION, n2);
    }

    @Override
    public KeyResult getEncryptionKey(KeyRequest<SecretKey> object) throws SecurityException {
        Assert.notNull(object, "request cannot be null.");
        JweHeader jweHeader = Assert.notNull(object.getHeader(), "Request JweHeader cannot be null.");
        SecretKey secretKey = this.assertKey((SecretKey)object.getPayload());
        SecretKey secretKey2 = this.generateCek((KeyRequest<?>)object);
        byte[] byArray = this.ensureInitializationVector((Request<?>)object);
        AlgorithmParameterSpec algorithmParameterSpec = this.getIvSpec(byArray);
        object = this.jca((Request<?>)object).withCipher(new AesGcmKeyAlgorithm$1(this, secretKey, algorithmParameterSpec, secretKey2));
        int n2 = this.tagBitLength / 8;
        int n3 = ((Object)object).length - n2;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(object, 0, byArray2, 0, n3);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(object, n3, byArray3, 0, n2);
        object = Encoders.BASE64URL.encode(byArray);
        String string = Encoders.BASE64URL.encode(byArray3);
        jweHeader.put(DefaultJweHeader.IV.getId(), object);
        jweHeader.put(DefaultJweHeader.TAG.getId(), string);
        return new DefaultKeyResult(secretKey2, byArray2);
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<SecretKey> decryptionKeyRequest) throws SecurityException {
        Assert.notNull(decryptionKeyRequest, "request cannot be null.");
        SecretKey secretKey = this.assertKey((SecretKey)decryptionKeyRequest.getKey());
        byte[] byArray = Assert.notEmpty((byte[])decryptionKeyRequest.getPayload(), "Decryption request content (ciphertext) cannot be null or empty.");
        Object object = Assert.notNull(decryptionKeyRequest.getHeader(), "Request JweHeader cannot be null.");
        object = Assert.isInstanceOf(ParameterReadable.class, object, "Header must implement ParameterReadable.");
        object = new RequiredParameterReader((ParameterReadable)object);
        byte[] byArray2 = object.get(DefaultJweHeader.TAG);
        object = object.get(DefaultJweHeader.IV);
        object = this.getIvSpec((byte[])object);
        byArray = Bytes.concat(byArray, byArray2);
        return this.jca(decryptionKeyRequest).withCipher(new AesGcmKeyAlgorithm$2(this, secretKey, (AlgorithmParameterSpec)object, byArray));
    }
}

