/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.AesAlgorithm;
import io.jsonwebtoken.impl.security.AesWrapKeyAlgorithm$1;
import io.jsonwebtoken.impl.security.AesWrapKeyAlgorithm$2;
import io.jsonwebtoken.impl.security.DefaultKeyResult;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.DecryptionKeyRequest;
import io.jsonwebtoken.security.KeyRequest;
import io.jsonwebtoken.security.KeyResult;
import io.jsonwebtoken.security.Request;
import io.jsonwebtoken.security.SecretKeyAlgorithm;
import io.jsonwebtoken.security.SecurityException;
import javax.crypto.SecretKey;

public class AesWrapKeyAlgorithm
extends AesAlgorithm
implements SecretKeyAlgorithm {
    private static final String TRANSFORMATION = "AESWrap";

    public AesWrapKeyAlgorithm(int n2) {
        super("A" + n2 + "KW", TRANSFORMATION, n2);
    }

    @Override
    public KeyResult getEncryptionKey(KeyRequest<SecretKey> object) throws SecurityException {
        Assert.notNull(object, "request cannot be null.");
        SecretKey secretKey = this.assertKey((SecretKey)object.getPayload());
        SecretKey secretKey2 = this.generateCek((KeyRequest<?>)object);
        object = this.jca((Request<?>)object).withCipher(new AesWrapKeyAlgorithm$1(this, secretKey, secretKey2));
        return new DefaultKeyResult(secretKey2, (byte[])object);
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<SecretKey> decryptionKeyRequest) throws SecurityException {
        Assert.notNull(decryptionKeyRequest, "request cannot be null.");
        SecretKey secretKey = this.assertKey((SecretKey)decryptionKeyRequest.getKey());
        byte[] byArray = Assert.notEmpty((byte[])decryptionKeyRequest.getPayload(), "Request content (encrypted key) cannot be null or empty.");
        return this.jca(decryptionKeyRequest).withCipher(new AesWrapKeyAlgorithm$2(this, secretKey, byArray));
    }
}

