/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.security.ConcatKDF$1;
import io.jsonwebtoken.impl.security.ConcatKDF$2;
import io.jsonwebtoken.impl.security.ConcatKDF$ClearableByteArrayOutputStream;
import io.jsonwebtoken.impl.security.CryptoAlgorithm;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.UnsupportedKeyException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class ConcatKDF
extends CryptoAlgorithm {
    private static final long MAX_REP_COUNT = 0xFFFFFFFFL;
    private static final long MAX_HASH_INPUT_BYTE_LENGTH = Integer.MAX_VALUE;
    private static final long MAX_HASH_INPUT_BIT_LENGTH = 0x3FFFFFFF8L;
    private final int hashBitLength;
    private static final long MAX_DERIVED_KEY_BIT_LENGTH = 0x3FFFFFFF8L;

    ConcatKDF(String string) {
        super("ConcatKDF", string);
        int n2 = this.jca().withMessageDigest(new ConcatKDF$1(this));
        this.hashBitLength = n2 << 3;
        Assert.state(this.hashBitLength > 0, "MessageDigest length must be a positive value.");
    }

    public final SecretKey deriveKey(byte[] object, long l2, byte[] byArray) throws UnsupportedKeyException, SecurityException {
        Assert.notEmpty(object, "Z cannot be null or empty.");
        Assert.isTrue(l2 > 0L, "derivedKeyBitLength must be a positive integer.");
        if (l2 > 0x3FFFFFFF8L) {
            String string = "derivedKeyBitLength may not exceed " + Bytes.bitsMsg(0x3FFFFFFF8L) + ". Specified size: " + Bytes.bitsMsg(l2) + ".";
            throw new IllegalArgumentException(string);
        }
        long l3 = l2 / 8L;
        byArray = byArray == null ? Bytes.EMPTY : byArray;
        double d2 = (double)l2 / (double)this.hashBitLength;
        long l4 = (long)Math.ceil(d2);
        boolean bl2 = d2 != (double)l4;
        Assert.state(l4 <= 0xFFFFFFFFL, "derivedKeyBitLength is too large.");
        byte[] byArray2 = new byte[]{0, 0, 0, 1};
        long l5 = Bytes.bitLength(byArray2) + Bytes.bitLength(object) + Bytes.bitLength(byArray);
        Assert.state(l5 <= 0x3FFFFFFF8L, "Hash input is too large.");
        ConcatKDF$ClearableByteArrayOutputStream concatKDF$ClearableByteArrayOutputStream = new ConcatKDF$ClearableByteArrayOutputStream((int)l3);
        byte[] byArray3 = Bytes.EMPTY;
        try {
            byArray3 = this.jca().withMessageDigest(new ConcatKDF$2(this, l4, byArray2, (byte[])object, byArray, bl2, l2, concatKDF$ClearableByteArrayOutputStream));
            object = new SecretKeySpec(byArray3, "AES");
            return object;
        }
        finally {
            Bytes.clear(byArray3);
            Bytes.clear(byArray2);
            concatKDF$ClearableByteArrayOutputStream.reset();
        }
    }

    static /* synthetic */ int access$000(ConcatKDF concatKDF) {
        return concatKDF.hashBitLength;
    }
}

