/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.AbstractX509Context;
import io.jsonwebtoken.impl.ParameterMap;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.Parameters;
import io.jsonwebtoken.impl.security.AbstractAsymmetricJwk;
import io.jsonwebtoken.impl.security.AbstractJwk;
import io.jsonwebtoken.impl.security.DefaultEcPrivateJwk;
import io.jsonwebtoken.impl.security.DefaultEcPublicJwk;
import io.jsonwebtoken.impl.security.DefaultOctetPrivateJwk;
import io.jsonwebtoken.impl.security.DefaultRsaPrivateJwk;
import io.jsonwebtoken.impl.security.DefaultSecretJwk;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.HashAlgorithm;
import io.jsonwebtoken.security.Jwks$OP;
import io.jsonwebtoken.security.KeyOperation;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DefaultJwkContext<K extends Key>
extends AbstractX509Context<JwkContext<K>>
implements JwkContext<K> {
    private static final Set<Parameter<?>> DEFAULT_PARAMS;
    private K key;
    private PublicKey publicKey;
    private Provider provider;
    private SecureRandom random;
    private HashAlgorithm idThumbprintAlgorithm;

    public DefaultJwkContext() {
        this(DEFAULT_PARAMS);
    }

    public DefaultJwkContext(Set<Parameter<?>> set) {
        super(set);
    }

    public DefaultJwkContext(Set<Parameter<?>> set, JwkContext<?> jwkContext) {
        this(set, jwkContext, true);
    }

    public DefaultJwkContext(Set<Parameter<?>> set, JwkContext<?> jwkContext, K k2) {
        this(set, jwkContext, k2 == null || k2 instanceof PublicKey);
        this.key = (Key)Assert.notNull(k2, "Key cannot be null.");
    }

    public DefaultJwkContext(Set<Parameter<?>> object, JwkContext<?> iterator, boolean bl2) {
        super((Set)Assert.notEmpty(object, "Parameters cannot be null or empty."));
        Assert.notNull(iterator, "JwkContext cannot be null.");
        Assert.isInstanceOf(DefaultJwkContext.class, iterator, "JwkContext must be a DefaultJwkContext instance.");
        object = (DefaultJwkContext)((Object)iterator);
        this.provider = iterator.getProvider();
        this.random = iterator.getRandom();
        this.idThumbprintAlgorithm = iterator.getIdThumbprintAlgorithm();
        this.values.putAll(((ParameterMap)object).values);
        for (Map.Entry entry : ((ParameterMap)object).idiomaticValues.entrySet()) {
            String string = (String)entry.getKey();
            Object v2 = entry.getValue();
            Parameter parameter = (Parameter)this.PARAMS.get(string);
            if (parameter != null && !parameter.supports(v2)) {
                Object object2 = this.values.get(parameter.getId());
                this.put(parameter, object2);
                continue;
            }
            this.idiomaticValues.put(string, v2);
        }
        if (bl2) {
            for (Parameter parameter : ((ParameterMap)object).PARAMS.values()) {
                if (!parameter.isSecret()) continue;
                this.remove(parameter.getId());
            }
        }
    }

    @Override
    public JwkContext<K> parameter(Parameter<?> linkedHashSet) {
        linkedHashSet = Parameters.replace(this.PARAMS, linkedHashSet);
        linkedHashSet = new LinkedHashSet(linkedHashSet.values());
        if (this.key != null) {
            DefaultJwkContext defaultJwkContext = this;
            return new DefaultJwkContext<K>(linkedHashSet, defaultJwkContext, defaultJwkContext.key);
        }
        return new DefaultJwkContext<K>((Set<Parameter<?>>)linkedHashSet, (JwkContext<?>)this, false);
    }

    @Override
    public String getName() {
        CharSequence charSequence = this.get(AbstractJwk.KTY);
        if ("oct".equals(charSequence)) {
            charSequence = "Secret";
        } else if ("OKP".equals(charSequence)) {
            charSequence = "Octet";
        }
        charSequence = charSequence != null ? new StringBuilder((String)charSequence) : new StringBuilder();
        K k2 = this.getKey();
        if (k2 instanceof PublicKey) {
            Strings.nespace((StringBuilder)charSequence).append("Public");
        } else if (k2 instanceof PrivateKey) {
            Strings.nespace((StringBuilder)charSequence).append("Private");
        }
        Strings.nespace((StringBuilder)charSequence).append("JWK");
        return ((StringBuilder)charSequence).toString();
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        Assert.notEmpty(map, "JWK values cannot be null or empty.");
        super.putAll(map);
    }

    @Override
    public String getAlgorithm() {
        return this.get(AbstractJwk.ALG);
    }

    @Override
    public JwkContext<K> setAlgorithm(String string) {
        this.put(AbstractJwk.ALG, (Object)string);
        return this;
    }

    @Override
    public String getId() {
        return this.get(AbstractJwk.KID);
    }

    @Override
    public JwkContext<K> setId(String string) {
        this.put(AbstractJwk.KID, (Object)string);
        return this;
    }

    @Override
    public JwkContext<K> setIdThumbprintAlgorithm(HashAlgorithm hashAlgorithm) {
        this.idThumbprintAlgorithm = hashAlgorithm;
        return this;
    }

    @Override
    public HashAlgorithm getIdThumbprintAlgorithm() {
        return this.idThumbprintAlgorithm;
    }

    @Override
    public Set<KeyOperation> getOperations() {
        return this.get(AbstractJwk.KEY_OPS);
    }

    @Override
    public JwkContext<K> setOperations(Collection<? extends KeyOperation> collection) {
        this.put(AbstractJwk.KEY_OPS, (Object)collection);
        return this;
    }

    @Override
    public String getType() {
        return this.get(AbstractJwk.KTY);
    }

    @Override
    public JwkContext<K> setType(String string) {
        this.put(AbstractJwk.KTY, (Object)string);
        return this;
    }

    @Override
    public String getPublicKeyUse() {
        return this.get(AbstractAsymmetricJwk.USE);
    }

    @Override
    public JwkContext<K> setPublicKeyUse(String string) {
        this.put(AbstractAsymmetricJwk.USE, (Object)string);
        return this;
    }

    @Override
    public boolean isSigUse() {
        if ("sig".equals(this.getPublicKeyUse())) {
            return true;
        }
        Set<KeyOperation> set = this.getOperations();
        if (Collections.isEmpty(set)) {
            return false;
        }
        return set.contains(Jwks$OP.SIGN) || set.contains(Jwks$OP.VERIFY);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public JwkContext<K> setKey(K k2) {
        this.key = k2;
        return this;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public JwkContext<K> setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    @Override
    public JwkContext<K> setProvider(Provider provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public SecureRandom getRandom() {
        return this.random;
    }

    @Override
    public JwkContext<K> setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    static {
        LinkedHashSet<Parameter<Object>> linkedHashSet = new LinkedHashSet<Parameter<Object>>();
        linkedHashSet.addAll(DefaultSecretJwk.PARAMS);
        linkedHashSet.addAll(DefaultEcPrivateJwk.PARAMS);
        linkedHashSet.addAll(DefaultRsaPrivateJwk.PARAMS);
        linkedHashSet.addAll(DefaultOctetPrivateJwk.PARAMS);
        linkedHashSet.remove(DefaultEcPublicJwk.X);
        linkedHashSet.remove(DefaultEcPrivateJwk.D);
        linkedHashSet.add(Parameters.string(DefaultEcPublicJwk.X.getId(), "Elliptic Curve public key X coordinate"));
        linkedHashSet.add((Parameter<Object>)Parameters.builder(String.class).setSecret(true).setId(DefaultEcPrivateJwk.D.getId()).setName("Elliptic Curve private key").build());
        DEFAULT_PARAMS = Collections.immutable(linkedHashSet);
    }
}

