/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.ParameterMap;
import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.Parameters;
import io.jsonwebtoken.impl.security.AbstractJwkBuilder;
import io.jsonwebtoken.impl.security.AbstractSecurityBuilder;
import io.jsonwebtoken.impl.security.DefaultJwkSet;
import io.jsonwebtoken.impl.security.JwkBuilderSupplier;
import io.jsonwebtoken.impl.security.JwkConverter;
import io.jsonwebtoken.impl.security.JwkSetConverter;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkSet;
import io.jsonwebtoken.security.JwkSetBuilder;
import io.jsonwebtoken.security.KeyOperationPolicy;
import java.security.Provider;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DefaultJwkSetBuilder
extends AbstractSecurityBuilder<JwkSet, JwkSetBuilder>
implements JwkSetBuilder {
    private KeyOperationPolicy operationPolicy = AbstractJwkBuilder.DEFAULT_OPERATION_POLICY;
    private JwkSetConverter converter = new JwkSetConverter();
    private ParameterMap map = new ParameterMap(Parameters.registry(DefaultJwkSet.KEYS));

    @Override
    public JwkSetBuilder delete(String string) {
        this.map.remove(string);
        return this;
    }

    @Override
    public JwkSetBuilder empty() {
        this.map.clear();
        return this;
    }

    @Override
    public JwkSetBuilder add(String string, Object object) {
        this.map.put(string, object);
        return this;
    }

    @Override
    public JwkSetBuilder add(Map<? extends String, ?> map) {
        this.map.putAll(map);
        return this;
    }

    private JwkSetBuilder refresh() {
        Iterator iterator = new JwkConverter(new JwkBuilderSupplier(this.provider, this.operationPolicy));
        this.converter = new JwkSetConverter((Converter<Jwk<?>, Object>)((Object)iterator), this.converter.isIgnoreUnsupported());
        iterator = DefaultJwkSet.param(iterator);
        this.map = new ParameterMap(Parameters.registry(new Parameter[]{iterator}), this.map, true);
        if (!Collections.isEmpty(iterator = (Set)((Object)this.map.get(iterator)))) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Jwk jwk = (Jwk)iterator.next();
                this.operationPolicy.validate(jwk.getOperations());
            }
        }
        return this;
    }

    @Override
    public JwkSetBuilder provider(Provider provider) {
        super.provider(provider);
        return this.refresh();
    }

    @Override
    public JwkSetBuilder operationPolicy(KeyOperationPolicy keyOperationPolicy) throws IllegalArgumentException {
        this.operationPolicy = keyOperationPolicy != null ? keyOperationPolicy : AbstractJwkBuilder.DEFAULT_OPERATION_POLICY;
        return this.refresh();
    }

    Collection<Jwk<?>> ensureKeys() {
        Collection collection = this.map.get(DefaultJwkSet.KEYS);
        if (Collections.isEmpty(collection)) {
            return new LinkedHashSet();
        }
        return collection;
    }

    @Override
    public JwkSetBuilder add(Jwk<?> jwk) {
        if (jwk != null) {
            this.operationPolicy.validate(jwk.getOperations());
            Collection<Jwk<?>> collection = this.ensureKeys();
            collection.add(jwk);
            this.keys(collection);
        }
        return this;
    }

    @Override
    public JwkSetBuilder add(Collection<Jwk<?>> object) {
        if (!Collections.isEmpty(object)) {
            object = object.iterator();
            while (object.hasNext()) {
                Jwk jwk = (Jwk)object.next();
                this.add(jwk);
            }
        }
        return this;
    }

    @Override
    public JwkSetBuilder keys(Collection<Jwk<?>> collection) {
        return this.add(DefaultJwkSet.KEYS.getId(), (Object)collection);
    }

    @Override
    public JwkSet build() {
        return this.converter.applyFrom(this.map);
    }
}

