/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.security.AbstractSecureDigestAlgorithm;
import io.jsonwebtoken.impl.security.DefaultMacAlgorithm$1;
import io.jsonwebtoken.impl.security.DefaultSecretKeyBuilder;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.MacAlgorithm;
import io.jsonwebtoken.security.Password;
import io.jsonwebtoken.security.SecretKeyBuilder;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.VerifySecureDigestRequest;
import io.jsonwebtoken.security.WeakKeyException;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;

final class DefaultMacAlgorithm
extends AbstractSecureDigestAlgorithm<SecretKey, SecretKey>
implements MacAlgorithm {
    private static final String HS256_OID = "1.2.840.113549.2.9";
    private static final String HS384_OID = "1.2.840.113549.2.10";
    private static final String HS512_OID = "1.2.840.113549.2.11";
    private static final Set<String> JWA_STANDARD_IDS = new LinkedHashSet<String>(Collections.of("HS256", "HS384", "HS512"));
    static final DefaultMacAlgorithm HS256 = new DefaultMacAlgorithm(256);
    static final DefaultMacAlgorithm HS384 = new DefaultMacAlgorithm(384);
    static final DefaultMacAlgorithm HS512 = new DefaultMacAlgorithm(512);
    private static final Map<String, DefaultMacAlgorithm> JCA_NAME_MAP = new LinkedHashMap<String, DefaultMacAlgorithm>(6);
    private final int minKeyBitLength;

    private DefaultMacAlgorithm(int n2) {
        this("HS" + n2, "HmacSHA" + n2, n2);
    }

    DefaultMacAlgorithm(String string, String string2, int n2) {
        super(string, string2);
        Assert.isTrue(n2 > 0, "minKeyLength must be greater than zero.");
        this.minKeyBitLength = n2;
    }

    @Override
    public final int getKeyBitLength() {
        return this.minKeyBitLength;
    }

    private boolean isJwaStandard() {
        return JWA_STANDARD_IDS.contains(this.getId());
    }

    private static boolean isJwaStandardJcaName(String string) {
        string = string.toUpperCase(Locale.ENGLISH);
        return JCA_NAME_MAP.containsKey(string);
    }

    static DefaultMacAlgorithm findByKey(Key object) {
        Object object2 = KeysBridge.findAlgorithm((Key)object);
        if (!Strings.hasText((String)object2)) {
            return null;
        }
        object2 = ((String)object2).toUpperCase(Locale.ENGLISH);
        if ((object2 = JCA_NAME_MAP.get(object2)) == null) {
            return null;
        }
        byte[] byArray = KeysBridge.findEncoded((Key)object);
        object = byArray;
        long l2 = Bytes.bitLength(byArray);
        if (l2 >= (long)((DefaultMacAlgorithm)object2).getKeyBitLength()) {
            return object2;
        }
        return null;
    }

    @Override
    public final SecretKeyBuilder key() {
        return new DefaultSecretKeyBuilder(this.getJcaName(), this.getKeyBitLength());
    }

    private void assertAlgorithmName(SecretKey object, boolean bl2) {
        String string = object.getAlgorithm();
        if (!Strings.hasText(string)) {
            object = "The " + DefaultMacAlgorithm.keyType(bl2) + " key's algorithm cannot be null or empty.";
            throw new InvalidKeyException((String)object);
        }
        boolean bl3 = KeysBridge.isGenericSecret((Key)object);
        if (!bl3 && this.isJwaStandard() && !DefaultMacAlgorithm.isJwaStandardJcaName(string)) {
            throw new InvalidKeyException("The " + DefaultMacAlgorithm.keyType(bl2) + " key's algorithm '" + string + "' does not equal a valid HmacSHA* algorithm name or PKCS12 OID and cannot be used with " + this.getId() + ".");
        }
    }

    @Override
    protected final void validateKey(Key object, boolean bl2) {
        String string = DefaultMacAlgorithm.keyType(bl2);
        if (object == null) {
            throw new IllegalArgumentException("MAC " + string + " key cannot be null.");
        }
        if (!(object instanceof SecretKey)) {
            object = "MAC " + string + " keys must be SecretKey instances.  Specified key is of type " + object.getClass().getName();
            throw new InvalidKeyException((String)object);
        }
        if (object instanceof Password) {
            object = "Passwords are intended for use with key derivation algorithms only.";
            throw new InvalidKeyException((String)object);
        }
        object = (SecretKey)object;
        String string2 = this.getId();
        this.assertAlgorithmName((SecretKey)object, bl2);
        int n2 = KeysBridge.findBitLength((Key)object);
        if (n2 < 0) {
            return;
        }
        if (n2 < this.minKeyBitLength) {
            String string3 = "The " + string + " key's size is " + n2 + " bits which is not secure enough for the " + string2 + " algorithm.";
            string3 = this.isJwaStandard() && DefaultMacAlgorithm.isJwaStandardJcaName(this.getJcaName()) ? string3 + " The JWT JWA Specification (RFC 7518, Section 3.2) states that keys used with " + string2 + " MUST have a size >= " + this.minKeyBitLength + " bits (the key size must be greater than or equal to the hash output size). Consider using the Jwts.SIG." + string2 + ".key() builder to create a key guaranteed to be secure enough for " + string2 + ".  See https://tools.ietf.org/html/rfc7518#section-3.2 for more information." : string3 + " The " + string2 + " algorithm requires keys to have a size >= " + this.minKeyBitLength + " bits.";
            throw new WeakKeyException(string3);
        }
    }

    @Override
    public final byte[] doDigest(SecureRequest<InputStream, SecretKey> secureRequest) {
        return this.jca(secureRequest).withMac(new DefaultMacAlgorithm$1(this, secureRequest));
    }

    @Override
    protected final boolean doVerify(VerifySecureDigestRequest<SecretKey> object) {
        byte[] byArray = object.getDigest();
        Assert.notEmpty(byArray, "Request signature byte array cannot be null or empty.");
        object = this.digest(object);
        return MessageDigest.isEqual(byArray, (byte[])object);
    }

    static {
        JCA_NAME_MAP.put(HS256.getJcaName().toUpperCase(Locale.ENGLISH), HS256);
        JCA_NAME_MAP.put(HS256_OID, HS256);
        JCA_NAME_MAP.put(HS384.getJcaName().toUpperCase(Locale.ENGLISH), HS384);
        JCA_NAME_MAP.put(HS384_OID, HS384);
        JCA_NAME_MAP.put(HS512.getJcaName().toUpperCase(Locale.ENGLISH), HS512);
        JCA_NAME_MAP.put(HS512_OID, HS512);
    }
}

