/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.CryptoAlgorithm;
import io.jsonwebtoken.impl.security.DefaultKeyResult;
import io.jsonwebtoken.impl.security.DefaultRsaKeyAlgorithm$1;
import io.jsonwebtoken.impl.security.DefaultRsaKeyAlgorithm$2;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.impl.security.RsaSignatureAlgorithm;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.DecryptionKeyRequest;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeyAlgorithm;
import io.jsonwebtoken.security.KeyRequest;
import io.jsonwebtoken.security.KeyResult;
import io.jsonwebtoken.security.Request;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.WeakKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class DefaultRsaKeyAlgorithm
extends CryptoAlgorithm
implements KeyAlgorithm<PublicKey, PrivateKey> {
    private final AlgorithmParameterSpec SPEC;
    private static final int MIN_KEY_BIT_LENGTH = 2048;

    public DefaultRsaKeyAlgorithm(String string, String string2) {
        this(string, string2, null);
    }

    public DefaultRsaKeyAlgorithm(String string, String string2, AlgorithmParameterSpec algorithmParameterSpec) {
        super(string, string2);
        this.SPEC = algorithmParameterSpec;
    }

    private static String keyType(boolean bl2) {
        if (bl2) {
            return "encryption";
        }
        return "decryption";
    }

    protected void validate(Key object, boolean bl2) {
        if (!RsaSignatureAlgorithm.isRsaAlgorithmName((Key)object)) {
            throw new InvalidKeyException("Invalid RSA key algorithm name.");
        }
        if (RsaSignatureAlgorithm.isPss((Key)object)) {
            object = "RSASSA-PSS keys may not be used for " + DefaultRsaKeyAlgorithm.keyType(bl2) + ", only digital signature algorithms.";
            throw new InvalidKeyException((String)object);
        }
        int n2 = KeysBridge.findBitLength((Key)object);
        if (n2 < 0) {
            return;
        }
        if (n2 < 2048) {
            String string = this.getId();
            String string2 = string.startsWith("RSA1") ? "4.2" : "4.3";
            String string3 = "The RSA " + DefaultRsaKeyAlgorithm.keyType(bl2) + " key size (aka modulus bit length) is " + n2 + " bits which is not secure enough for the " + string + " algorithm. The JWT JWA Specification (RFC 7518, Section " + string2 + ") states that RSA keys MUST have a size >= " + 2048 + " bits. See https://www.rfc-editor.org/rfc/rfc7518.html#section-" + string2 + " for more information.";
            throw new WeakKeyException(string3);
        }
    }

    @Override
    public KeyResult getEncryptionKey(KeyRequest<PublicKey> object) throws SecurityException {
        Assert.notNull(object, "Request cannot be null.");
        PublicKey publicKey = (PublicKey)Assert.notNull(object.getPayload(), "RSA PublicKey encryption key cannot be null.");
        this.validate(publicKey, true);
        SecretKey secretKey = this.generateCek((KeyRequest<?>)object);
        object = this.jca((Request<?>)object).withCipher(new DefaultRsaKeyAlgorithm$1(this, publicKey, (KeyRequest)object, secretKey));
        return new DefaultKeyResult(secretKey, (byte[])object);
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<PrivateKey> decryptionKeyRequest) throws SecurityException {
        Assert.notNull(decryptionKeyRequest, "request cannot be null.");
        PrivateKey privateKey = (PrivateKey)Assert.notNull(decryptionKeyRequest.getKey(), "RSA PrivateKey decryption key cannot be null.");
        this.validate(privateKey, false);
        byte[] byArray = Assert.notEmpty((byte[])decryptionKeyRequest.getPayload(), "Request content (encrypted key) cannot be null or empty.");
        return this.jca(decryptionKeyRequest).withCipher(new DefaultRsaKeyAlgorithm$2(this, privateKey, byArray));
    }

    static /* synthetic */ AlgorithmParameterSpec access$000(DefaultRsaKeyAlgorithm defaultRsaKeyAlgorithm) {
        return defaultRsaKeyAlgorithm.SPEC;
    }
}

