/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.AbstractSecurityBuilder;
import io.jsonwebtoken.impl.security.JcaTemplate;
import io.jsonwebtoken.impl.security.Randoms;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.SecretKeyBuilder;
import javax.crypto.SecretKey;

public class DefaultSecretKeyBuilder
extends AbstractSecurityBuilder<SecretKey, SecretKeyBuilder>
implements SecretKeyBuilder {
    protected final String JCA_NAME;
    protected final int BIT_LENGTH;

    public DefaultSecretKeyBuilder(String string, int n2) {
        this.JCA_NAME = Assert.hasText(string, "jcaName cannot be null or empty.");
        if (n2 % 8 != 0) {
            string = "bitLength must be an even multiple of 8";
            throw new IllegalArgumentException(string);
        }
        this.BIT_LENGTH = Assert.gt(n2, 0, "bitLength must be > 0");
        this.random(Randoms.secureRandom());
    }

    @Override
    public SecretKey build() {
        JcaTemplate jcaTemplate = new JcaTemplate(this.JCA_NAME, this.provider, this.random);
        return jcaTemplate.generateSecretKey(this.BIT_LENGTH);
    }
}

