/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.AbstractEcJwkFactory;
import io.jsonwebtoken.impl.security.DefaultEcPublicJwk;
import io.jsonwebtoken.impl.security.ECCurve;
import io.jsonwebtoken.impl.security.EcPublicJwkFactory$1;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.EcPublicJwk;
import io.jsonwebtoken.security.InvalidKeyException;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Map;

class EcPublicJwkFactory
extends AbstractEcJwkFactory<ECPublicKey, EcPublicJwk> {
    private static final String UNSUPPORTED_CURVE_MSG = "The specified ECKey curve does not match a JWA standard curve id.";
    static final EcPublicJwkFactory INSTANCE = new EcPublicJwkFactory();

    EcPublicJwkFactory() {
        super(ECPublicKey.class, DefaultEcPublicJwk.PARAMS);
    }

    protected static String keyContainsErrorMessage(String string) {
        Assert.hasText(string, "curveId cannot be null or empty.");
        String string2 = "ECPublicKey's ECPoint does not exist on elliptic curve '%s' and may not be used to create '%s' JWKs.";
        return String.format("ECPublicKey's ECPoint does not exist on elliptic curve '%s' and may not be used to create '%s' JWKs.", string, string);
    }

    protected static String jwkContainsErrorMessage(String string, Map<String, ?> map) {
        Assert.hasText(string, "curveId cannot be null or empty.");
        String string2 = "EC JWK x,y coordinates do not exist on elliptic curve '%s'. This could be due simply to an incorrectly-created JWK or possibly an attempted Invalid Curve Attack (see https://safecurves.cr.yp.to/twist.html for more information).";
        return String.format("EC JWK x,y coordinates do not exist on elliptic curve '%s'. This could be due simply to an incorrectly-created JWK or possibly an attempted Invalid Curve Attack (see https://safecurves.cr.yp.to/twist.html for more information).", string, map);
    }

    protected static String getJwaIdByCurve(EllipticCurve object) {
        if ((object = ECCurve.findByJcaCurve((EllipticCurve)object)) == null) {
            throw new InvalidKeyException(UNSUPPORTED_CURVE_MSG);
        }
        return ((ECCurve)object).getId();
    }

    @Override
    protected EcPublicJwk createJwkFromKey(JwkContext<ECPublicKey> jwkContext) {
        Object object = jwkContext.getKey();
        Object object2 = object.getParams();
        object2 = ((ECParameterSpec)object2).getCurve();
        object = object.getW();
        String string = EcPublicJwkFactory.getJwaIdByCurve((EllipticCurve)object2);
        if (!ECCurve.contains((EllipticCurve)object2, (ECPoint)object)) {
            string = EcPublicJwkFactory.keyContainsErrorMessage(string);
            throw new InvalidKeyException(string);
        }
        jwkContext.put((ECPublicKey)((Object)DefaultEcPublicJwk.CRV.getId()), string);
        string = EcPublicJwkFactory.toOctetString((EllipticCurve)object2, ((ECPoint)object).getAffineX());
        jwkContext.put((ECPublicKey)((Object)DefaultEcPublicJwk.X.getId()), string);
        object = EcPublicJwkFactory.toOctetString((EllipticCurve)object2, ((ECPoint)object).getAffineY());
        jwkContext.put((ECPublicKey)((Object)DefaultEcPublicJwk.Y.getId()), object);
        return new DefaultEcPublicJwk(jwkContext);
    }

    @Override
    protected EcPublicJwk createJwkFromValues(JwkContext<ECPublicKey> jwkContext) {
        Object object = new RequiredParameterReader(jwkContext);
        String string = object.get(DefaultEcPublicJwk.CRV);
        BigInteger bigInteger = object.get(DefaultEcPublicJwk.X);
        object = object.get(DefaultEcPublicJwk.Y);
        ECCurve eCCurve = EcPublicJwkFactory.getCurveByJwaId(string);
        if (!eCCurve.contains((ECPoint)(object = new ECPoint(bigInteger, (BigInteger)object)))) {
            object = EcPublicJwkFactory.jwkContainsErrorMessage(string, jwkContext);
            throw new InvalidKeyException((String)object);
        }
        object = new ECPublicKeySpec((ECPoint)object, eCCurve.toParameterSpec());
        object = this.generateKey(jwkContext, new EcPublicJwkFactory$1(this, (ECPublicKeySpec)object));
        jwkContext.setKey((ECPublicKey)object);
        return new DefaultEcPublicJwk(jwkContext);
    }
}

