/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.security.AbstractSignatureAlgorithm;
import io.jsonwebtoken.impl.security.DefaultKeyPairBuilder;
import io.jsonwebtoken.impl.security.EcSignatureAlgorithm$1;
import io.jsonwebtoken.impl.security.EcSignatureAlgorithm$2;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.impl.security.Randoms;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeyPairBuilder;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SignatureAlgorithm;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.VerifySecureDigestRequest;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

final class EcSignatureAlgorithm
extends AbstractSignatureAlgorithm {
    private static final String REQD_ORDER_BIT_LENGTH_MSG = "orderBitLength must equal 256, 384, or 521.";
    private static final String DER_ENCODING_SYS_PROPERTY_NAME = "io.jsonwebtoken.impl.crypto.EllipticCurveSignatureValidator.derEncodingSupported";
    private static final String ES256_OID = "1.2.840.10045.4.3.2";
    private static final String ES384_OID = "1.2.840.10045.4.3.3";
    private static final String ES512_OID = "1.2.840.10045.4.3.4";
    private static final Set<String> KEY_ALG_NAMES = Collections.setOf("EC", "ECDSA", "1.2.840.10045.4.3.2", "1.2.840.10045.4.3.3", "1.2.840.10045.4.3.4");
    private final ECGenParameterSpec KEY_PAIR_GEN_PARAMS;
    private final int orderBitLength;
    private final String OID;
    private final int signatureByteLength;
    private final int sigFieldByteLength;
    static final EcSignatureAlgorithm ES256 = new EcSignatureAlgorithm(256, "1.2.840.10045.4.3.2");
    static final EcSignatureAlgorithm ES384 = new EcSignatureAlgorithm(384, "1.2.840.10045.4.3.3");
    static final EcSignatureAlgorithm ES512 = new EcSignatureAlgorithm(521, "1.2.840.10045.4.3.4");
    private static final Map<String, SignatureAlgorithm> BY_OID = new LinkedHashMap<String, SignatureAlgorithm>(3);

    private static int shaSize(int n2) {
        if (n2 == 521) {
            return 512;
        }
        return n2;
    }

    private static boolean isSupportedOrderBitLength(int n2) {
        return n2 == 256 || n2 == 384 || n2 == 521;
    }

    static SignatureAlgorithm findByKey(Key key) {
        String string = KeysBridge.findAlgorithm(key);
        if (!Strings.hasText(string)) {
            return null;
        }
        SignatureAlgorithm signatureAlgorithm = BY_OID.get(string = string.toUpperCase(Locale.ENGLISH));
        if (signatureAlgorithm != null) {
            return signatureAlgorithm;
        }
        if ("EC".equalsIgnoreCase(string) || "ECDSA".equalsIgnoreCase(string)) {
            int n2 = KeysBridge.findBitLength(key);
            if (n2 == EcSignatureAlgorithm.ES512.orderBitLength) {
                return ES512;
            }
            if (n2 == EcSignatureAlgorithm.ES384.orderBitLength) {
                return ES384;
            }
            if (n2 == EcSignatureAlgorithm.ES256.orderBitLength) {
                return ES256;
            }
        }
        return null;
    }

    private EcSignatureAlgorithm(int n2, String string) {
        super("ES" + EcSignatureAlgorithm.shaSize(n2), "SHA" + EcSignatureAlgorithm.shaSize(n2) + "withECDSA");
        Assert.isTrue(EcSignatureAlgorithm.isSupportedOrderBitLength(n2), REQD_ORDER_BIT_LENGTH_MSG);
        this.OID = Assert.hasText(string, "Invalid OID.");
        string = "secp" + n2 + "r1";
        this.KEY_PAIR_GEN_PARAMS = new ECGenParameterSpec(string);
        this.orderBitLength = n2;
        this.sigFieldByteLength = Bytes.length(this.orderBitLength);
        this.signatureByteLength = this.sigFieldByteLength << 1;
    }

    @Override
    public final KeyPairBuilder keyPair() {
        return (KeyPairBuilder)new DefaultKeyPairBuilder("EC", this.KEY_PAIR_GEN_PARAMS).random(Randoms.secureRandom());
    }

    @Override
    protected final void validateKey(Key key, boolean bl2) {
        super.validateKey(key, bl2);
        if (!KEY_ALG_NAMES.contains(KeysBridge.findAlgorithm(key))) {
            throw new InvalidKeyException("Unrecognized EC key algorithm name.");
        }
        int n2 = KeysBridge.findBitLength(key);
        if (n2 < 0) {
            return;
        }
        int n3 = Bytes.length(n2);
        if ((n3 <<= 1) != this.signatureByteLength) {
            String string = "The provided Elliptic Curve " + EcSignatureAlgorithm.keyType(bl2) + " key size (aka order bit length) is " + Bytes.bitsMsg(n2) + ", but the '" + this.getId() + "' algorithm requires EC Keys with " + Bytes.bitsMsg(this.orderBitLength) + " per [RFC 7518, Section 3.4](https://www.rfc-editor.org/rfc/rfc7518.html#section-3.4).";
            throw new InvalidKeyException(string);
        }
    }

    @Override
    protected final byte[] doDigest(SecureRequest<InputStream, PrivateKey> secureRequest) {
        return this.jca(secureRequest).withSignature(new EcSignatureAlgorithm$1(this, secureRequest));
    }

    final boolean isValidRAndS(PublicKey object, byte[] object2) {
        if (object instanceof ECKey) {
            object = (ECKey)object;
            object = object.getParams().getOrder();
            BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange((byte[])object2, 0, this.sigFieldByteLength));
            object2 = new BigInteger(1, Arrays.copyOfRange((byte[])object2, this.sigFieldByteLength, ((byte[])object2).length));
            return bigInteger.signum() > 0 && ((BigInteger)object2).signum() > 0 && bigInteger.compareTo((BigInteger)object) < 0 && ((BigInteger)object2).compareTo((BigInteger)object) < 0;
        }
        return true;
    }

    @Override
    protected final boolean doVerify(VerifySecureDigestRequest<PublicKey> verifySecureDigestRequest) {
        PublicKey publicKey = (PublicKey)verifySecureDigestRequest.getKey();
        return this.jca(verifySecureDigestRequest).withSignature(new EcSignatureAlgorithm$2(this, verifySecureDigestRequest, publicKey));
    }

    public static byte[] transcodeDERToConcat(byte[] byArray, int n2) throws JwtException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (byArray.length < 8 || byArray[0] != 48) {
            throw new JwtException("Invalid ECDSA signature format");
        }
        if (byArray[1] > 0) {
            n7 = 2;
        } else if (byArray[1] == -127) {
            n7 = 3;
        } else {
            throw new JwtException("Invalid ECDSA signature format");
        }
        for (n6 = n5 = byArray[n7 + 1]; n6 > 0 && byArray[n7 + 2 + n5 - n6] == 0; --n6) {
        }
        for (n4 = n3 = byArray[n7 + 2 + n5 + 1]; n4 > 0 && byArray[n7 + 2 + n5 + 2 + n3 - n4] == 0; --n4) {
        }
        int n8 = Math.max(n6, n4);
        n8 = Math.max(n8, n2 / 2);
        if ((byArray[n7 - 1] & 0xFF) != byArray.length - n7 || (byArray[n7 - 1] & 0xFF) != n5 + 2 + 2 + n3 || byArray[n7] != 2 || byArray[n7 + 2 + n5] != 2) {
            throw new JwtException("Invalid ECDSA signature format");
        }
        byte[] byArray2 = new byte[2 * n8];
        System.arraycopy(byArray, n7 + 2 + n5 - n6, byArray2, n8 - n6, n6);
        System.arraycopy(byArray, n7 + 2 + n5 + 2 + n3 - n4, byArray2, 2 * n8 - n4, n4);
        return byArray2;
    }

    public static byte[] transcodeConcatToDER(byte[] byArray) throws JwtException {
        try {
            return EcSignatureAlgorithm.concatToDER(byArray);
        }
        catch (Exception exception) {
            String string = "Invalid ECDSA signature format.";
            throw new SignatureException(string, exception);
        }
    }

    private static byte[] concatToDER(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        int n2;
        byte[] byArray2;
        int n3;
        int n4;
        int n5;
        int n6;
        for (n6 = n5 = byArray.length / 2; n6 > 0 && byArray[n5 - n6] == 0; --n6) {
        }
        int n7 = n6;
        if (byArray[n5 - n6] < 0) {
            ++n7;
        }
        for (n4 = n5; n4 > 0 && byArray[2 * n5 - n4] == 0; --n4) {
        }
        int n8 = n4;
        if (byArray[2 * n5 - n4] < 0) {
            ++n8;
        }
        if ((n3 = n7 + 2 + 2 + n8) > 255) {
            throw new JwtException("Invalid ECDSA signature format");
        }
        if (n3 < 128) {
            byArray2 = new byte[n7 + 4 + 2 + n8];
            n2 = 1;
        } else {
            byte[] byArray3 = new byte[n7 + 5 + 2 + n8];
            byArray2 = byArray3;
            byArray3[1] = -127;
            n2 = 2;
        }
        byArray2[0] = 48;
        byArray2[n2++] = (byte)n3;
        byArray2[n2++] = 2;
        byArray2[n2++] = (byte)n7;
        System.arraycopy(byArray, n5 - n6, byArray2, n2 + n7 - n6, n6);
        n2 += n7;
        byArray2[n2++] = 2;
        byArray2[n2++] = (byte)n8;
        System.arraycopy(byArray, 2 * n5 - n4, byArray2, n2 + n8 - n4, n4);
        return byArray2;
    }

    static /* synthetic */ int access$000(EcSignatureAlgorithm ecSignatureAlgorithm) {
        return ecSignatureAlgorithm.signatureByteLength;
    }

    static {
        for (EcSignatureAlgorithm ecSignatureAlgorithm : Collections.of(ES256, ES384, ES512)) {
            BY_OID.put(ecSignatureAlgorithm.OID, ecSignatureAlgorithm);
        }
    }
}

